<?php

require_once("ManejoXML.php");

/**
 * Manejo de XMLs que interpreta Broadsoft
 */
class BroadsoftXMLWS {
	
	const GRUPO_AGREGAR = 1;
	const GRUPO_CONSULTA = 2;
	
	//Maqueta
	const USER_WS = "extprovis_desa";
	const PASSWORD_WS = "iplan2009.!";
	//const SERVER_WS = "web1lab.hpbx.iplannetworks.net";
	//const WSDL_WS = "https://web1lab.hpbx.iplannetworks.net/webservice/services/ProvisioningService?wsdl";
	
	//Produccion
	//const SERVER_WS = "172.16.208.40"; // PRIMARIO
	//const SERVER_WS = "172.16.208.41"; // SECUNDARIO
	//const WSDL_WS = "http://172.16.208.40/webservice/services/ProvisioningService?wsdl"; //PRIMARIO
	//const WSDL_WS = "http://172.16.208.41/webservice/services/ProvisioningService?wsdl"; //SECUNDARIO
	//const USER_WS = "extprovis_desa";
	//const PASSWORD_WS = "caHweW85!";
	
	//Maqueta REL 17
	//const USER_WS = "extprovis_desa";
	//const PASSWORD_WS = "ext123";
	const SERVER_WS = "172.16.205.140";
	//const WSDL_WS = "http://172.16.205.140/OCIOverSoap/services/ProvisioningService?wsdl";
	const WSDL_WS = "http://172.16.208.140/webservice/services/ProvisioningService?wsdl";

	const COMANDOS_AGRUPADOS_MAX = 5;

	/**
	 *
	 * @var LogMessages Contiene la instancia de log a utilizar
	 */
	private static $log;

	private $dom;
	private $root;

	private $wsdl;

	private $ssid;
	private $jssid;
	private $soap_client;

	private $time_retry = 1;
	private $cant_retry = 10;

	private static $instance;

	private static $user;
	private static $passwd;

	private $lastRequest;
	private $lastResponse;

	private $lastRequestHeaders;
	private $lastResponseHeaders;
	
	private $commands = array();

	/**
	 * Devuelve y/o Crea la instancia a utilizar de la clase.
	 * 
	 * @param string $wsdl La ruta al WSDL de Broadsoft
	 * @param string $user Usuario de login al Web Service
	 * @param string $passwd Password de login al Web Service
	 * @param LogMessages $log La instancia de log en la cual escribe.
	 * @return BroadsoftXMLWS 
	 */
	public static function getInstance($wsdl = null, $user = null, $passwd = null, $log = null) {
		if (!isset(self::$instance)) {
			$c = __CLASS__;
			self::$instance = new $c($wsdl);
			self::$user = $user;
			self::$passwd = $passwd;
			self::$log = $log;
		}
		return self::$instance;
	}

	/**
	 * Cierra la conexión al web service y destruye la clase xd.-
	 */
	public static function closeInstance() {
		self::$instance->logout();
		self::$instance->__destruct();
	}

	/**
	 * Constructor privado de clase singleton.
	 * 
	 * @param string $wsdl La ruta al WSDL de Broadsoft
	 */
	private function __construct($wsdl) {
		$this->wsdl = $wsdl;
		$this->conectar();
	}

	/**
	 * Prepara el documento XML: lo crea y setea los nodos y atributos basicos
	 */
	private function prepareDOM() {
		$this->dom = new  DOMDocument("1.0");
		$this->root = new DOMElement("processOCIMessage");
		$this->dom->appendChild($this->root);
		$this->root->setAttribute("SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
		$this->root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
	}

	/**
	 * Agrega el contenido completo del documento XML.
	 * 
	 * @param string $datosXML el XML completo que toma como parametro el web service
	 */
	private function addXML($datosXML) {
		$eleme_arg0 = new DOMElement("in0", $datosXML);
		$this->root->appendChild($eleme_arg0);
		$eleme_arg0->setAttribute("xsi:type", "soapenc:string");
		$eleme_arg0->setAttribute("xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
	}

	/**
	 * Retorna el XML completo del documento completo. 
	 * 
	 * @return string el XML.
	 */
	public function getXML() {
		return ($this->dom->saveXML($this->root));
	}
	
	/**
	 * Conecta al Web Service de Broadsoft
	 */
	private function conectar() {
		try {
			$this->soap_client = new SoapClient($this->wsdl, array('soap_version' => SOAP_1_1, 'trace' => true, "exceptions" => true, "connection_timeout" => "3", "user_agent" => "PHP Provisioning"));
		} catch (SoapFault $fault) {
			throw new ProvisioningException("Fallo al conectar al Web Service de Broadsoft", ProvisioningException::EXP_UNABLE_CONNECT_SOAP_SERVER, $fault);
		}
		$this->prepareDOM();
	}

	/**
	 * Loguea contra el web service de broadsoft.
	 */
	public function login() {
		$this->conectar();
		$this->prepareDOM();
		$base = new BroadsoftXMLBase();

		$cmdAuthRequest = new BroadsoftXMLCommandAuthenticationRequest();

		$base->addCommand($cmdAuthRequest->getCommand());
		$cmdAuthRequest->setUser(self::$user);
		$cmdAuthRequest->setCommand();

		$this->ssid = $base->getsessionId();
      $this->addXML($base->getXML());
		$reintentos = 0;
		$ejecuto = false;
		while ($reintentos < $this->cant_retry) {
			$reintentos++;
			try {
				$this->soap_client->processOCIMessage(new SoapVar(utf8_encode($this->getXML()), XSD_ANYXML));
				$reintentos = $this->cant_retry;
				$ejecuto = true;
			} catch (SoapFault $fault) {
				$fdetail = (isset($fault->detail)) ? $fault->detail->string : "";
				sleep($this->time_retry);
				self::$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "WS: INTENTO CONECTAR NUEVAMENTE: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "] detail: [" . $fdetail . "]");
				$this->conectar();
			}
		}

		$lastRequest = $this->soap_client->__getLastRequest();
		$lastResponse = $this->soap_client->__getLastResponse();

		$lastRequestHeaders = $this->soap_client->__getLastRequestHeaders();
		$lastResponseHeaders = $this->soap_client->__getLastResponseHeaders();
		$respuesta = new BroadsoftXMLAuthenticationRequestResponse($this->soap_client->__getLastResponse(), $this->soap_client->__getLastResponseHeaders());
		
		$this->jssid = $respuesta->getJSESSIONID();

		$bs_rt1		= new BroadsoftXMLBase($this->ssid);
		$bs_rt2		= new BroadsoftXMLCommandLoginRequest();
		unset($this->dom);
		unset($this->root);
		$this->prepareDOM();


		$bs_rt1->addCommand($bs_rt2->getCommand());
		$bs_rt2->setData(BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $respuesta->getnonce());
		$bs_rt2->setCommand();

		$this->addXML($bs_rt1->getXML());
		$this->soap_client->__setCookie($this->jssid);
		$this->soap_client->processOCIMessage(new SoapVar(utf8_encode($this->getXML()), XSD_ANYXML));
		$this->lastRequest = $this->soap_client->__getLastRequest();
		$this->lastResponse = $this->soap_client->__getLastResponse();

		$this->lastRequestHeaders = $this->soap_client->__getLastRequestHeaders();
		$this->lastResponseHeaders = $this->soap_client->__getLastResponseHeaders();

	}

	/**
	 * Desloguea del web service de broadsoft.
	 */
	public function logout() {
		$base = new BroadsoftXMLBase($this->ssid);

		$cmdLogOut = new BroadsoftXMLCommandLogoutRequest();
		unset($this->dom);
		unset($this->root);
		
		$this->prepareDOM();
		$base->addCommand($cmdLogOut->getCommand());
		$cmdLogOut->setUser(self::$user);
		$cmdLogOut->setCommand();

		$this->addXML($base->getXML());
		try {
			$this->soap_client->processOCIMessage(new SoapVar(utf8_encode($this->getXML()), XSD_ANYXML));
		} catch (SoapFault $fault) {
			throw new ProvisioningException("Fallo al ejecutar processOCIMessage del Web Service de Broadsoft", ProvisioningException::EXP_UNABLE_EXECUTE_FUNCTION, $fault);
		}
	}

	/**
	 * Ejecuta el XML con los comandos.
	 * 
	 * @param BroadsoftXMLCommands $commands Los comandos a mandar a ejecutar
	 * @return bool true si lo pudo ejecutar, false si fallo algo 
	 */
	public function execute($commands) {
		
		$this->commands = $commands;
		
		$reintentos = 0;
		$ejecuto = false;

		try {
			while ($reintentos < $this->cant_retry) {
				$this->login(self::$user, self::$passwd);
				unset($this->dom);
				unset($this->root);
				$this->prepareDOM();

				/*$pos = strpos($xml, "?>") ;
				$domDocumentito = new DOMDocument('1.0', 'ISO-8859-1');
				$domDocumentito->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xml, $pos + 2)));
				$comandos = $domDocumentito->getElementsByTagName("command");*/
				
				$xd = new BroadsoftXMLBase($this->ssid);
				
				$aComandos = $commands->getCommands();
				
				if (count($aComandos) > 0) {
					foreach ($aComandos as $identificador => $aCmd) {
						$xd->addCommand($aCmd["Command"]->getCommand());
						$aCmd["Command"]->setCommand();
					}
				}
				
				/*for ($i = 0; $i < $comandos->length; $i++) {
					$elem1 = $comandos->item($i);
					$nodin = ManejoXML::cloneNode($elem1, $xd->dom);
					$nodin->setAttribute("xmlns", "");
					$xd->addCommand($nodin);
				}*/
				
				$this->addXML($xd->getXML());
				$this->soap_client->__setCookie($this->jssid);
				$reintentos++;
				try {
					$this->soap_client->processOCIMessage(new SoapVar($this->getXML(), XSD_ANYXML));
					$reintentos = $this->cant_retry;
					$ejecuto = true;
				} catch (SoapFault $fault){
					$fdetail = (isset($fault->detail)) ? $fault->detail->string : "";
					self::$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "WS: Error al ejecutar algun comando - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "] detail: [" . $fdetail . "]");
					sleep($this->time_retry);
				}
				$this->lastRequest = $this->soap_client->__getLastRequest();
				$this->lastResponse = $this->soap_client->__getLastResponse();

				$this->lastRequestHeaders = $this->soap_client->__getLastRequestHeaders();
				$this->lastResponseHeaders = $this->soap_client->__getLastResponseHeaders();
				$this->logout();
				unset($this->soap_client);
			}
		} catch (ProvisioningException $pe) {
			self::$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "WS: Error al ejecutar la funcion: " . $pe);
			return false;
		}
		return ($ejecuto);
	}

	/**
	 * Devuelve la ultima respuesta del Web Service
	 * 
	 * @return string La ultima respuesta del Web Service
	 */
	public function getLastResponse() {
		return($this->lastResponse);
	}

	/**
	 * Devuelve los headers de la ultima respuesta del Web Service
	 * 
	 * @return string Los headers de la ultima respuesta del Web Service
	 */
	public function getLastResponseHeaders() {
		return($this->lastResponseHeaders);
	}

	/**
	 * Devuelve los headers del ultimo pedido al Web Service
	 * 
	 * @return string Los headers del ultimo pedido al Web Service
	 */
	public function getLastRequestHeaders() {
		return($this->lastRequestHeaders);
	}

	/**
	 * Devuelve el ultimo pedido al Web Service
	 * 
	 * @return string El ultimo pedido al Web Service
	 */
	public function getLastRequest() {
		return($this->lastRequest);
	}

	/**
	 * Lee los resultados de la ejecucion de comandos de broadsoft.
	 * 
	 * @return array Un arreglo de true/string indicando el comando si fallo o el detalle del error
	 */
	public function getResultados() {
		$aComandos = $this->commands->getCommands();
		reset($aComandos);
		
		$respuestaXML = new DOMDocument("1.0");
		$respuestaXML->loadXML($this->getLastResponse());
		$res = array();
		$processOCIMessageReturn = $respuestaXML->getElementsByTagName("processOCIMessageReturn");

		if ($processOCIMessageReturn->length > 0) {
			$xmlBS = $processOCIMessageReturn->item(0)->nodeValue;
			$respuestaXMLBS = new DOMDocument("1.0", "ISO-8859-1");
			$respuestaXMLBS->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", $xmlBS));

			$respuestaComandos = $respuestaXMLBS->getElementsByTagName("command");
			for ($i = 0; $i < $respuestaComandos->length; $i++) {
				$comandito = each($aComandos);
				$item = $respuestaComandos->item($i);
				$resComando = $item->getAttributeNode("xsi:type")->value;
				$cmdErrores = 0;
				switch ($resComando) {
					case "c:SuccessResponse";
						break;
					case "c:ErrorResponse";
						$hijos = $item->childNodes;
						$cmdErrores++;
						$amsgs = array();
						for ($j = 0; $j < $hijos->length; $j++) {
							if (($hijos->item($j)->nodeName == "summary") || ($hijos->item($j)->nodeName == "detail")) {
								$amsgs[] = $hijos->item($j)->nodeValue;
							}
						}
						$msgError = implode("|", $amsgs);
						break;
				}
				if ($cmdErrores > 0) {
					$res[$comandito["key"]] = $comandito["value"]["Description"] . ": " . $msgError;
				} else {
					$res[$comandito["key"]] = 1;
				}
			}
		} else {
			$Fault = $respuestaXML->getElementsByTagName("Fault");
			if ($Fault->length > 0) {
				$hijosDeFault = $Fault->item(0)->childNodes;
				$cFaultCode = "";
				$cFaultString = "";
				$cDetailString = "";
				for ($i = 0; $i < $hijosDeFault->length; $i++) {
					switch ($hijosDeFault->item($i)->nodeName) {
						case "faultcode":
							$cFaultCode = $hijosDeFault->item($i)->nodeValue;
							break;
						case "faultstring":
							$cFaultString = $hijosDeFault->item($i)->nodeValue;
							break;
						case "detail":
							$hijosDeDetail = $hijosDeFault->item($i)->childNodes;
							for ($j = 0; $j < $hijosDeDetail->length; $j++) {
								switch ($hijosDeDetail->item($j)->nodeName) {
									case "string":
										$cDetailString = $hijosDeDetail->item($j)->nodeValue;
									break;
								}
							}
							break;
					}
				}
				$res = "SoapFault: faultcode[" . $cFaultCode . "] faultstring [" . $cFaultString . "] detail[" . $cDetailString . "]";
			} else {
				$res = "Error-> No hubo una respuesta success, failure o fault";
			}
		}
		return ($res);
	}

}

/**
 * Clase de Documento Base de Broadsoft (BroadsoftDocument).
 */
class BroadsoftXMLBase {
	
	const SESSION_DESCRIPTION =  "172.16.213.10,";

	private $comandos = array();
	public $dom;
	private $root;
	private $id_session;

	/**
	 * Crea un documento de broadsoft.
	 * 
	 * @param string $id_session El id de sesion, si no se pasa lo genera.
	 */
	public function __construct($id_session = null) {

		$this->id_session = ($id_session) ? $id_session : BroadsoftXMLBase::SESSION_DESCRIPTION . substr(md5(time()), 0, 10) ;

		$this->dom = new DOMDocument('1.0', 'iso-8859-1');
		$this->root = new DOMElement("BroadsoftDocument");
		$this->dom->appendChild($this->root);
		$this->root->setAttribute("protocol", "OCI");
		$this->root->setAttribute("xmlns", "C");
		$this->root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
		$elem2 = new DOMElement("sessionId", $this->id_session);
		$this->root->appendChild($elem2);
		$elem2->setAttribute("xmlns", "");
	}

	/**
	 * Devuelve el XML del documento actual completo
	 * 
	 * @return string El XML.
	 */
	public function getXML() {
		return $this->dom->saveXML($this->root);
	}

	/**
	 * Devuelve el ID de sesion
	 * 
	 * @return string El ID de sesion
	 */
	public function getsessionId() {
		return $this->id_session;
	}
	
	/**
	 *  Devuelve el HTML del documento actual completo
	 * 
	 * @return string El HTML.
	 */
	public function getHTML() {

		$elem2 = new DOMElement("sessionId", $this->id_session);
		$this->root->appendChild($elem2);
		$elem2->setAttribute("xmlns", "");
		
		return $this->dom->saveHTML(); /* <?xml version="1.0" encoding="iso-8859-1"?> */
	}

	/**
	 * Agrega un comando al documento.
	 * 
	 * @param BroadsoftXMLCommand $comando El comando a agregar
	 */
	public function addCommand($comando, $identificador = "", $description = "") {
      $this->root->appendChild($comando);
	}

	/**
	 * Retorna el Documento sobre el cual se esta trabajando
	 * 
	 * @return DOMDocument la raiz del documento.
	 */
	public function getDom() {
		return $this->dom;
	}

}

/**
 * Clase que agrupa los comandos BroadsoftXMLCommand
 */
class BroadsoftXMLCommands {
	
	private $aComandos = array();
	
	/**
	 * Agrega un comando a la lista de comandos.
	 * 
	 * @param BroadsoftXMLCommand $comando el comando
	 * @param string $identificador un identificador para el comando
	 * @param string $description la descripcion en caso de error del comando
	 * @param bool $validation true/false el estado de ejecucion del comando
	 */
    public function addCommand($comando, $identificador, $description = "", $validation = true) {
		if ($identificador) {
			$this->aComandos[$identificador]["Command"] = $comando;
			$this->aComandos[$identificador]["Description"] = $description;
			$this->aComandos[$identificador]["Validation"] = $validation;
		}
	}
	
	/**
	 * Devuelve el comando identificado
	 * 
	 * @param string $identificador
	 * @return BroadsoftXMLCommand 
	 */
	public function getCommand($identificador) {
		return ($this->aComandos[$identificador]["Command"]);
	}
	
	/**
	 * Devuelve la descripcion del comando identificado
	 * 
	 * @param string $identificador el identificador del comando
	 * @return string 
	 */
	public function getDescription($identificador) {
		return ($this->aComandos[$identificador]["Description"]);
	}
	
	/**
	 * Devuelve la validacion del comando identificado
	 * 
	 * @param string $identificador el identificador del comando
	 * @return string 
	 */
	public function getValidation($identificador) {
		return ($this->aComandos[$identificador]["Validation"]);
	}
	
	/**
	 * Devuelve los comandos que no se ejecutaron correctamente
	 * 
	 * @return array un arreglo con los comandos
	 */
	public function getInvalidCommands() {
		$aRes = array();
		if (count($this->aComandos) > 0) {
			foreach($this->aComandos as $id => $datosCommand) {
				if ($datosCommand["Validation"] !== true) {
					$aRes[] = $datosCommand;
				}
			}
		}
		return $aRes;
	}
	
	/**
	 * Separa los comandos en un arreglo por la cantidad indicada
	 * 
	 * @param integer $count la cantidad de agrupado
	 * @return BroadsoftXMLCommands 
	 */
	public function splitCommands($count) {
		$aComandosSeparados = array();
		$aComandosAux = $this->aComandos;
		$i = 0;
		while($i < count($aComandosAux)) {
			$aComandosNuevos = array_slice($this->aComandos, $i, $count, true);
			$i += $count;
			$aNuevito = new BroadsoftXMLCommands();
			$aNuevito->setCommands($aComandosNuevos);
			$aComandosSeparados[] = $aNuevito;
		}
		
		return $aComandosSeparados;
	}
	
	/**
	 * Devuelve los nombres de comandos que fallaron junto con la descripcion del fallo
	 * 
	 * @return string Una cadena con los comandos y la descripcion de sus errores 
	 */
	public function getInvalidCommandsString() {
		$aRes = array();
		if (count($this->aComandos) > 0) {
			foreach($this->aComandos as $id => $datosCommand) {
				if ($datosCommand["Validation"] !== true) {
					$aRes[] = $id . " [" . $datosCommand["Description"] . "]";
				}
			}
		}
		return (implode("|", $aRes));
	}
	
	/**
	 * Devuelve el arreglo de los comandos
	 * 
	 * @return array Arreglo con los comandos
	 */
	public function getCommands() {
		return $this->aComandos;
	}
	
	/**
	 * Setea un array de comandos como propio.
	 * 
	 * @param array $aComandos un arreglo con los comandos.
	 */
	public function setCommands($aComandos) {
		$this->aComandos = $aComandos;
	}
	
	/**
	 * Devuelve la cantidad de comandos asignados
	 * 
	 * @return integer la cantidad. 
	 */
	public function getCantidadComandos() {
		return count($this->aComandos);
	}
	
}

/**
 * Clase de Comando de Broadsoft, corresponde a un elemento "command"
 */
class BroadsoftXMLCommand {

	protected $comando;
	protected $type;

	/**
	 * Constructor crea el comando vacio
	 */
	public function __construct() {
		$this->comando = new DOMElement("command");
	}

	/**
	 * Devuelve el Comando
	 * 
	 * @return DOMElement el Elemento del comando 
	 */
	public function getCommand() {
		return $this->comando;
	}

}

/**
 * Clase para interpertar una respuesta de Broadsoft.
 */
class BroadsoftXMLResponse {
	
	protected $dom_response;
	protected $headers_response;
	protected $xml_response;
	
	/**
	 * Crea el objeto
	 * 
	 * @param string $response La respuesta XML del web service
	 * @param string $headers los Headers de la respuesta
	 */
	public function __construct($response, $headers) {
		$this->dom_response = new DOMDocument();
		$this->dom_response->loadXML($response);

		$asd = $this->dom_response->getElementsByTagName("processOCIMessageReturn");
		$this->xml_response = new DOMDocument();
		$this->xml_response->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", $asd->item(0)->nodeValue));
		$headers = explode("\r\n", $headers);
		foreach($headers as $xd1 => $xd2) {
			if ($xd2 == "") {
				unset($headers[$xd1]);
			} else {
				$axd2 = explode(":", $xd2);
				$axd2[1] = (!isset($axd2[1])) ? "" : $axd2[1];
				list($a, $b) = $axd2;
				$headers[trim($a)] = trim($b);
				unset($headers[$xd1]);
				if (count(explode(";", $headers[trim($a)])) > 1) {
					$headers[trim($a)][1] = (!isset($headers[trim($a)][1])) ? "" : $headers[trim($a)][1];
					$headers[trim($a)] = explode(";", $headers[trim($a)]);
					foreach($headers[trim($a)] as $l => $v) {
						if ($v == "") {
							unset($headers[trim($a)][$l]);
						} else {
							$aasd = explode("=", $headers[trim($a)][$l]);
							$aasd[1] = (!isset($aasd[1])) ? "" : $aasd[1];
							list($c, $d) = $aasd;
							unset($headers[trim($a)][$l]);
							$headers[trim($a)][trim($c)] = $d;
						}
					}
				}
			}
		}

		$this->headers_response = $headers;
	}

	/**
	 * Devuelve los headers de la respuesta
	 * 
	 * @return string Los headers.
	 */
	public function getHeadersRespose() {
		return ($this->headers_response);
	}

	/**
	 * Devuelve el XML de la respuesta
	 * 
	 * @return string El XML. 
	 */
	public function getResponseXML() {
		return ($this->dom_response->saveXML());
	}

	/**
	 * Devuelve el XML de la respuesta
	 * 
	 * @return string El XML.
	 */
	public function getContenidoXML() {
		return ($this->xml_response->saveXML());
	}

}

/**
 * Respuesta de la autenticación
 */
class BroadsoftXMLAuthenticationRequestResponse extends BroadsoftXMLResponse {

	protected $JSESSIONID;
	protected $sessionId;
	protected $userId;
	protected $passwordAlgorithm;
	protected $nonce;

	/**
	 * Crea el Objeto 
	 * 
	 * @param string $response La respuesta
	 * @param string $headers  Los headers
	 */
	public function __construct($response, $headers) {

		parent::__construct($response, $headers);

		$this->JSESSIONID = $this->headers_response["Set-Cookie"]["JSESSIONID"];

		$asd = $this->xml_response->getElementsByTagName("nonce");
		$this->nonce = $asd->item(0)->textContent;

		$asd = $this->xml_response->getElementsByTagName("sessionId");
		$this->sessionId = $asd->item(0)->textContent;

		$asd = $this->xml_response->getElementsByTagName("passwordAlgorithm");
		$this->passwordAlgorithm = $asd->item(0)->textContent;

		$asd = $this->xml_response->getElementsByTagName("userId");
		$this->userId = $asd->item(0)->textContent;


	}

	/**
	 * Devuelve el JSESSIONID de la respuesta
	 * 
	 * @return string JSESSIONID
	 */
	public function getJSESSIONID() {
		return ($this->JSESSIONID);
	}
	
	/**
	 * Devuelve el "nonce" que viene en la respuesta
	 * 
	 * @return string El nonce. 
	 */
	public function getnonce() {
		return ($this->nonce);
	}

	/**
	 * Devuelve el algoritmo para encriptar el password 
	 * 
	 * @return string El algoritmo
	 */
	public function getpasswordAlgorithm() {
		return ($this->passwordAlgorithm);
	}

	/**
	 * Devuelve el user ID que solicita
	 * @return string el user ID
	 */
	public function getuserId() {
		return ($this->userId);
	}

	/**
	 * Devuelve el sessionId de la respuesta
	 * @return string el sessionId. 
	 */
	public function getsessionId() {
		return ($this->sessionId);
	}


}
/**
 * Comando de pedido de autenticación.
 */
class BroadsoftXMLCommandAuthenticationRequest extends BroadsoftXMLCommand {

	private $user;
	/*private $passwordAlgorithm;
	private $nonce;*/

	/**
	 * Cronstruye el objeto creando el comando
	 */
	public function __construct() {
		parent::__construct();
		//$this->comando = new DOMElement("command");
	}

	/**
	 * Asigna el user de la autenticacion
	 * 
	 * @param string $user El usuario
	 */
	public function setUser($user) {
		$this->user = $user;

		$elem = new DOMElement("userId", $this->user);
		$this->comando->appendChild($elem);
	}
	
	/**
	 * Setea el Comando, para usar luego de estar en un DOMDocument
	 */
	public function setCommand() {
		$this->comando->setAttribute("xsi:type", "AuthenticationRequest");
		$this->comando->setAttribute("xmlns", "");
	}

}

/**
 * Clase para manejar el pedido de logout del Web Service de Broadsoft
 */
class BroadsoftXMLCommandLogoutRequest extends BroadsoftXMLCommand {

	private $user;

	/**
	 * Crea el comando
	 */
	public function __construct() {
		parent::__construct();
		//$this->comando = new DOMElement("command");
	}

	/**
	 * Asigna el user que va a desloguear
	 * 
	 * @param string $user El usuario
	 */
	public function setUser($user) {
		$this->$user = $user;

		$elem = new DOMElement("userId", $this->user);
		$this->comando->appendChild($elem);
	}

	/**
	 * Setea el Comando, para usar luego de estar en un DOMDocument
	 */
	public function setCommand() {
		$this->comando->setAttribute("xsi:type", "LogoutRequest");
		$this->comando->setAttribute("xmlns", "");
	}

}

/**
 * Comando de request de login una vez que hice el pedido de autenticacion
 */
class BroadsoftXMLCommandLoginRequest extends BroadsoftXMLCommand {

	private $user;
	private $passwd;

	/*private $passwordAlgorithm;*/
	private $nonce;


	public function __construct() {
		parent::__construct();
		//$this->comando = new DOMElement("command");
	}

	/**
	 * Asigna los valores de usuario, password y nonce, para ser procesados y metidos en el XML.
	 * 
	 * @param string $user
	 * @param string $passwd
	 * @param string $nonce 
	 */
	public function setData($user, $passwd, $nonce) {
		$this->user = $user;
		$this->passwd = $passwd;
		$this->nonce = $nonce;

		$passLoco = md5($nonce . ":" . sha1($passwd));

		$elem = new DOMElement("userId", $this->user);
		$this->comando->appendChild($elem);

		$elem2 = new DOMElement("signedPassword", $passLoco);
		$this->comando->appendChild($elem2);

	}

	/**
	 * Setea el Comando, para usar luego de estar en un DOMDocument
	 */
	public function setCommand() {
		$this->comando->setAttribute("xsi:type", "LoginRequest14sp4");
		$this->comando->setAttribute("xmlns", "");
	}

}

?>
