<?php

require_once("ProductoTelefonia.php");

class AutoAttendantIUNI extends ProductoTelefonia {
	
	/**
	 *
	 * @var integer Numero PSTN del AutoAttendant
	 */
	private $nroPSTN;
	
	/**
	 *
	 * @var integer Numero de Interno del AutoAttendant xd
	 */
	private $nroInterno = 200;
	
	/* id de Subscripcion (para core) */
	private $subscriptionID;
	
	/* id de Locacion (para core) */
	private $locacionID;

	/* Grupo de Broadsoft, usado para modificaciones */
	private $grupoBS = null;

	private $serviceOrderTaskId = null;
	
	/**
	 *
	 * @var string Password del AutoAttendant
	 */
	private $password;
	
	/**
	 * Setea el password del AutoAttendant
	 * @param string $password El password
	 */
	public function setPassword($password){
		$this->password = $password;
	}
	
	/**
	 * Devuelve el password del AutoAttendant
	 * 
	 * @return string El password
	 */
	public function getPassword() {
		return ($this->password);
	}
	
	
	/**
	 * Constructor, por comodidad se asigna Nro de Interno y Nro PSTN
	 * 
	 * @param integer $nroPSTN El Numero PSTN
	 * @param integer $nroInterno El Nrumero de Interno
	 */
	public function __construct($nroPSTN, $nroInterno = null) {
		$this->nroPSTN = $nroPSTN;
		$this->nroInterno = $nroInterno;
	}
	
	/**
	 * Setea el Numero PSTN de la linea
	 * 
	 * @param integer $nroPSTN El numero PSTN
	 */
	public function setNroPSTN($nroPSTN) {
		$this->nroPSTN = $nroPSTN;
	}

	/**
	 * Setea el Numero de Interno del interno
	 * 
	 * @param integer $nroInterno El numero de interno
	 */
	public function setNroInterno($nroInterno) {
		$this->nroInterno = $nroInterno;
	}

	/**
	 * Setea el ID de Subscription de la linea en tenfold
	 * 
	 * @param integer $subscriptionID ID de Subscription
	 */
	public function setSubscriptionID($subscriptionID) {
		$this->subscriptionID = $subscriptionID;
	}

	/**
	 * Setea el ID de Locacion del sitio donde se encuentra la linea
	 * 
	 * @param integer $locacionID ID de Locacion
	 */
	public function setLocacionID($locacionID) {
		$this->locacionID = $locacionID;
	}

	/**
	 * Setea el nombre del grupo de broadsoft al cual pertenece la linea
	 * 
	 * @param string $grupoBS Nombre del Grupo.
	 */
	public function setGrupoBS($grupoBS) {
		$this->grupoBS = $grupoBS;
	}

	/**
	 * Setea el ID de Orden de Servicio correspondiente a la linea
	 * 
	 * @param bool $serviceOrderTaskId true|false|null
	 */
	public function setServiceOrderTaskId($serviceOrderTaskId) {
		$this->serviceOrderTaskId = $serviceOrderTaskId;
	}

	
	/**
	 * Devuelve el Numero PSTN de la linea
	 * 
	 * @return integer Numero PSTN
	 */
	public function getNroPSTN() {
		return ($this->nroPSTN);
	}
	
	/**
	 * Devuelve el ID de Subscription de la linea
	 * 
	 * @return integer ID de Subscription
	 */
	public function getSubscriptionID() {
		return ($this->subscriptionID);
	}

	/**
	 * Devuelve el ID de locacion al cual pertenece la linea
	 * 
	 * @return integer ID de Locacion 
	 */
	public function getLocacionID() {
		return ($this->locacionID);
	}

	/**
	 * Setea el Numero de Interno de la linea
	 * 
	 * @return integer Numero de Interno
	 */
	public function getNroInterno() {
		return ($this->nroInterno);
	}

	/**
	 * Devuelve el grupo de broadsoft al cual pertence la linea.
	 * 
	 * @return string Grupo de Broadsoft
	 */
	public function getGrupoBS() {
		return ($this->grupoBS);
	}
	
	/**
	 * Devuelve el ID de Orden de Servicio de la linea.
	 * 
	 * @return integer ID de Orden de Servicio.
	 */
	public function getServiceOrderTaskId() {
		return ($this->serviceOrderTaskId);
	}

}

?>
