<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/models/provisioning/ProvisioningContext.php';
require_once 'iplan/models/provisioning/ProvisioningOldObject.php';
require_once 'iplan/models/provisioning/ProvisioningStatus.php';
require_once 'iplan/models/provisioning/ProvisioningTask.php';
require_once 'iplan/models/provisioning/ProvisionableObject.php';



/**
* Author: Federico G. Bernoldi
* 
*/
abstract class AbstractProvisioningPlataform {
  /**
   * @var ORM la instancia desde la cual se recuperan los valores de la tarea
   */
  protected $orm;

  /**
   * @var ProvisioningContext el contexto en el cual se realiza la tarea
   */
  private $context;

  public function __construct(&$orm, &$context = null)
  {
    // Bouml preserved body begin 00185C85
    // Bouml preserved body end 00185C85
  }

  /**
   * Ejecuta una determinada tarea en base al nuevo objeto y a los valores anteriores del mismo.
   * 
   * @param ProvisioningTask $task la tearea a realizar
   * @param ProvisioningOldObject $old la representación virtual del estado del objeto antes de los cambios
   * @param ProvisionableObject $actual el objeto con la representación que se quiere plasmar en la plataforma
   * 
   * @return ProvisioningStatus el estado en el que quedó la tarea tras su ejecución.
   */
  public abstract function execute(&$task, &$old, &$actual = null)
  ;
  /**
   * Recupera el contexto de ejecución de la plataforma
   * 
   * @return ProvisioningContext el valor de contexto configurado para la plataforma
   */
  final public function getContext()
  {
    return $this->context;
  }

  /**
   * Cambia el contexto de aprovisionamiento.
   * 
   * @param ProvisioningContext $value el nuevo contexto en el cual se realizará el aprovisionamiento
   * 
   * @return AbstractProvisioningPlataform la instancia con el nuevo contexto embebido.
   */
  public function setContext($context)
  {
    // Bouml preserved body begin 00187D85
    // Bouml preserved body end 00187D85
  }

}
?>