<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GoogleTxtForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001C8B85
	parent::__construct($orm, $context);
	
	$this->setClass('GoogleAccount')
		 ->setTitle('Ingreso de Registro TXT')
		 ->setMethod('post')
		 ->addComponent(new TextComponent(array('label'=>'Código de Verificación', 'maps'=>'txt', 'size'=>80)))
		 ->setFormType(ABMForm::FORM_OK_CANCEL);
	return $this;
    // Bouml preserved body end 001C8B85
  }

  /**
   * Esta función se encarga de validar si un usuario tiene acceso a trabajar con una cierta entidad. La intención es verificar en este paso que el usuario tiene permiso para crear, editar o borrar la entidad que solicitó.
   * 
   * @param ApplicationContext $context el contexto en el cual se mandó a ejecutar la acción. De aquí se puede obtener la información de User, Domain y Provider.
   * @param ORM $orm la instancia del ORM
   * @param string $action un texto que indica lo que se pretende hacer. Puede tomar valores de: 'NEW', 'MODIFY', 'SAVE' o 'DELETE'.
   * @param mixed $id el identificador de la entidad que se pasó por parámetro
   * 
   * @return boolean La función debe devolver True si el usuario puede realizar la acción o arrojar una excepción con la descripción del problema.
   */
  public function checkAccess(&$context, &$orm, $action, $id = null)
  {
    // Bouml preserved body begin 001C8F05
	$profiles = $context->getUser()->getProfiles();
	$isClient = false;
	foreach($profiles as $profile) {/* @var $profile Profile */
		if ($profile->getName() == 'Cliente GoogleApps')
			$isClient = true;
	}
	if ($isClient) {
		$isAccountOwner = $orm->query('GoogleAccount')
							  ->filterBy('client.user.id', '=', $context->getUser()->getId())
							  ->filterBy('id', '=', $id)
							  ->filterBy('delegatedDNS', '=', '1')
							  ->findOne() != false;
		if (!$isAccountOwner) throw new Exception('No puede establer el Registro TXT de una cuenta que no le pertenece o que no tiene el servicio habilitado');
	}
	return true;
    // Bouml preserved body end 001C8F05
  }

}
?>