<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GoogleTransactionTypeForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001B0805
	parent::__construct($orm, $context);
	
	$this->setClass('GoogleTransactionType')
		 ->setTitle('Tipo de Transacción')
		 ->setMethod('post')
		 ->addComponent(new TextComponent(array('label'=>'Descripción', 'maps'=>'description', 'size'=>50)))
		 ->setFormType(ABMForm::FORM_OK_CANCEL);
	return $this;
    // Bouml preserved body end 001B0805
  }

}
?>