<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Este formulario está diseñado como una alternativa más restrictiva del formulario de edición de transacción.
 * La intención es permitir adelantar o posponer la ejecución de las transacciones por parte del personal técnico de la empresa.
 */
class GoogleTransactionIntervalForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001F3785
	parent::__construct($orm, $context);
	
	$this->setClass('GoogleTransaction')
		 ->setTitle('Tipo de Transacción')
		 ->setMethod('post')
		 ->setFormType(ABMForm::FORM_OK_CANCEL);

	$layout = new GridLayout(3, 1);
	$layout->addComponent(new LabelComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain')), 1, 1)
		   ->addComponent(new LabelComponent(array('label'=>'Último intento', 'name'=>'lastTry', 'maps'=>'lastTry')), 2, 1)
		   ->addComponent(new TextComponent('Intérvalo', 'interval', 'interval'),3,1)
			;
	$this->addComponent($layout);
	return $this;
    // Bouml preserved body end 001F3785
  }

}
?>