<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GoogleTransactionForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001B0885
	parent::__construct($orm, $context);
	
	$this->setClass('GoogleTransaction')
		 ->setTitle('Tipo de Transacción')
		 ->setMethod('post')
		 ->setFormType(ABMForm::FORM_OK_CANCEL);

	$layout = new GridLayout(2, 3);
	$layout->addComponent(new TextComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain','size'=>30)), 1, 1)
		   ->addComponent(new TextComponent('Licencias', 'lics', 'licences'),1,2)
		   ->addComponent(new SelectComponent(array('label'=>'Delegación de DNS', 'name'=>'dns', 'maps'=>'delegatedDNS',
													'options'=>array(
																array('description'=>'Tiene delegación', 'value'=>1),
																array('description'=>'No tiene delegación', 'value'=>0)
																))), 1, 3)
		   ->addComponent(new SelectComponent(array('label'=>'Tipo', 'name'=>'type', 'maps'=>'type',
													'options'=>$orm->query('GoogleTransactionType')
																	->attributes('id as value', 'description')
																	->find())), 2, 1)
		   ->addComponent(new SelectComponent(array('label'=>'Estado', 'name'=>'status', 'maps'=>'status',
													'options'=>$orm->query('GoogleStatus')
																	->attributes('id as value', 'description')
																	->find())), 2, 2)
		   ->addComponent(new TextComponent('Intérvalo', 'int', 'interval'),2,3)
			;
	$this->addComponent($layout);
	return $this;
    // Bouml preserved body end 001B0885
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 001B2705
	$this->addComponent(new HiddenComponent('', 'provider', 'provider', $context->getProvider()->getId()));
	return parent::save($context, $orm);
    // Bouml preserved body end 001B2705
  }

}
?>