<?php
require_once 'iplan/web/Form.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GoogleChangeUserPasswordForm extends Form {
  /**
   * Crea una instancia de Form.
   * 
   * @return Form
   */
  public function __construct()
  {
    // Bouml preserved body begin 001ECE05
	parent::__construct();
	
	$context = Application::getInstance()->getContext();
	$orm = Application::getInstance()->getORM();
	$this->setContext($context);
	
	$layout = new GridLayout(3, 1);
	$layout->addComponent(new LabelComponent('Cuenta '.$context->getParam('username').'@'.$context->getParam('domain')), 1, 1)
		   ->addComponent(new PasswordComponent(array('label'=>'Nueva Clave: ', 'maps'=>'newPass', 'size'=>20)), 2, 1)
		   ->addComponent(new PasswordComponent(array('label'=>'Repita Clave: ', 'maps'=>'newPass2', 'size'=>20)), 3, 1)
		;
	
	$this->addComponent($layout)
		 ->addComponent(new HiddenComponent('', 'username', null, $context->getParam('username')))
		 ->addComponent(new HiddenComponent('', 'domain', null, $context->getParam('domain')))
		 ->setFormType(Form::FORM_OK_CANCEL)
		 ->setMethod('post')
		 ->setTitle('Cambiar clave de la cuenta')
		 ->setAction('GoogleApps.doChangeUserPassword')
		;
	return $this;
    // Bouml preserved body end 001ECE05
  }

}
?>