<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GoogleAccountForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001A9F85
	parent::__construct($orm, $context);
	
	$tieneDNS = new SelectComponent('¿Tiene delegación de DNS?', 'dns', 'delegatedDNS');
	$tieneDNS->setOptions(array(
							array('description'=>'Tiene delegación', 'value'=>1),
							array('description'=>'No tiene delegación', 'value'=>0)
							)
						 );

	$layout = new GridLayout(3, 3);
	$layout->setName('layout')
		   ->addComponent(new TextComponent('Cantidad de Licencias', 'licences', 'licences'), 1, 2)
		   ->addComponent($tieneDNS, 2, 1)
		   //->addComponent(new DateComponent('Fecha de Creación', 'date', 'created', 'd-m-Y', new DateTime()), 2, 2)
		   ->addComponent($textClient = new TextComponent('Nro. Cliente', 'clientNumber', 'client.clientNumber'),3, 1)
		   ->addComponent(new TextComponent(array('label'=>'Razón Social', 'name'=>'razonSocial', 'maps'=>'client.name', 'size'=>50, 'disabled'=>true)),3, 2, 2)
		  ;
	
	$textClient->addEvent(Component::EVENT_BLUR, function ($context, $form, $orm) {
														$nro = $context->getParam('clientNumber');
														$comp = $form->getComponent('razonSocial');
														$client = $orm->query('Client')->filterBy('clientNumber', '=', $nro)->findOne();
														if ($client) $comp->setValue($client->getName());
														else $comp->setValue('Cliente no encontrado');
														$form->updated('razonSocial');
												  }, $orm);
	
	$this->addComponent($layout)
		 ->setClass('GoogleAccount')
		 ->setTitle('Cuenta de Google')
		 ->setMethod('post')
		 ->setFormType(Form::FORM_OK_CANCEL);

	return $this;
    // Bouml preserved body end 001A9F85
  }

  /**
   * Funci�n invocada para crear una instancia del objeto que representa el formulario
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 001B4285
	$this->getComponent('layout')->addComponent(new TextComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain', 'size'=>50)), 1, 1, 2);
	return parent::fresh($context, $orm);
    // Bouml preserved body end 001B4285
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 001B4305
	$this->getComponent('layout')->addComponent(new LabelComponent('Dominio', 'domain', 'domain'), 1, 1, 2)//' <span style="font-weight:bold">{{domain}}</span>'
								 ->addComponent(new LabelComponent('Fecha de Creación', 'created', 'created'), 2, 2)
	;
	return parent::modify($context, $orm);
    // Bouml preserved body end 001B4305
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 001B2685
	$this->addComponent(new HiddenComponent('', 'provider', 'provider', $context->getProvider()->getId()));
	if ($this->getValueOf('id')==null) {
		$this->getComponent('layout')->addComponent(new TextComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain', 'size'=>50)), 1, 1, 2);
	}
	$client = $orm->query('Client')->filterBy('clientNumber', '=', $context->getParam('clientNumber'))->findOne();
	if (is_a($client, 'Client')) {
		$this->addComponent(new HiddenComponent('', 'client', 'client', $client->getId()));
	} else {
		$this->loadValues();
		return array('Cliente'=>'El cliente seleccionado no existe');		
	}
	return parent::save($context, $orm);
    // Bouml preserved body end 001B2685
  }

}
?>