<?php
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Parametriza las distintas operaciones de aprovisionamiento que están contempladas en el sistema de AutoProvisioning de GoogleApps.
 * 
 * @method string getDescription()
 * @method GoogleStatus setDescription()
 */
class GoogleTransactionType extends ORMObject {
  /**
   * @const int Creación de Cuenta
   */
  const CREATE_ACCOUNT = 1;

  /**
   * @const int Alta de Delegación de DNS
   */
  const DELEGATE_DNS = 2;

  /**
   * @const int Agregado de licencias a la cuenta existente
   */
  const UPGRADE_ACCOUNT = 3;

  /**
   * @const int Quita de licencias a la cuenta existente
   */
  const DOWNGRADE_ACCOUNT = 4;

  /**
   * @const int Quita la delegación de DNS
   */
  const DETACH_DNS = 5;

  /**
   * @const int Da de baja la cuenta
   */
  const DELETE_ACCOUNT = 6;

  /**
   * @const int Establece el registro TXT
   */
  const SET_TXT_RECORD = 7;

  /**
   * @const int Valida la vigencia del dominio
   */
  const VALIDATE_DOMAIN = 8;

  /**
   * @var string una descripción del tipo de transacción
   */
  protected $description;

  /**
   * Retorna la definición para el ORM de la clase GoogleAccount
   * 
   * @param ORM $orm el manejador de objetos para el cual se registra la definición
   * @return ORMDefinition La definición de la clase GoogleAccount
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001B0685
	return parent::define($orm)
				->setClass('GoogleTransactionType')
				->setTable('GA_TRANSACTIONTYPE')
				->addField('id', 'TRANSACTIONTYPE_ID', ORMDefinition::INTEGER)
				->setKey('id')
				->addField('description', 'TRANSACTIONTYPE_DESCRIPTION', ORMDefinition::STRING, 50)
				;
    // Bouml preserved body end 001B0685
  }

}
?>