<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/googleapps/GoogleAccount.php';
require_once 'iplan/models/googleapps/GoogleTransactionType.php';
require_once 'iplan/models/googleapps/GoogleStatus.php';
require_once 'iplan/models/provisioning/ServiceOrder.php';
require_once 'iplan/security/User.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * La transacción es la unidad de tarea que maneja el AutoProvisioning de GoogleApps. Se registra el tipo de tarea y la información básica para su realización.
 * Las transacciones pueden crearse como consecuencia de una novedad de 10Fold o como parte de una modificación de una cuenta desde la GUI. La forma de reconocerlo es viendo si tiene o no una ServiceOrder asociada (y por el usuario).
 * 
 * @method DateTime getReaded()
 * @method GoogleTransaction setReaded()
 * @method DateTime getFinished()
 * @method GoogleTransaction setFinished()
 * @method string getDomain()
 * @method GoogleTransaction setDomain()
 * @method int getLicences()
 * @method GoogleTransaction setLicences()
 * @method boolean getDelegatedDNS()
 * @method GoogleTransaction setDelegatedDNS()
 * @method GoogleStatus getStatus()
 * @method GoogleTransaction setStatus()
 * @method GoogleTransactionType getType()
 * @method GoogleTransaction setType()
 * @method User getUser()
 * @method GoogleTransaction setUser()
 * @method ServiceOrder getNotification()
 * @method GoogleTransaction setNotification()
 * @method GoogleTransaction setDescription()
 * @method string getDescription()
 * @method GoogleAccount getAccount()
 * @method GoogleTransaction setAccount()
 * @method GoogleTransaction setNotified()
 * @method boolean getNotified()
 * @method GoogleTransaction setInterval()
 * @method string getInterval()
 * @method DateTime getLastTry()
 * @method GoogleTransaction setLastTry()
 * @method GoogleTransaction setLastStatusChange()
 * @method DateTime getLastStatusChange()
 */
class GoogleTransaction extends ORMObject {
  /**
   * @var GoogleAccount la cuenta sobre la que se realizó la transacción
   */
  protected $account;

  /**
   * @var DateTime la fecha en la cual fue leída la solicitud de la operación
   */
  protected $readed;

  /**
   * @var GoogleTransactionType el tipo de la transacción que se llevó a cabo
   */
  protected $type;

  /**
   * @var DateTime la fecha de finalización de la tarea
   */
  protected $finished;

  /**
   * @var GoogleStatus el estado en el que se encuentra la operación
   */
  protected $status;

  /**
   * @var string el nombre de dominio. Se emplea exclusivamente en la alta de cuenta
   */
  protected $domain;

  /**
   * @var int la cantidad de licencias de la cuenta. Empleado en el upgrade/downgrade
   */
  protected $licences;

  /**
   * @var boolean indica si el dominio tiene o no un dns delegado al momento de registrar la transacción
   */
  protected $delegatedDNS;

  /**
   * @var string la descripción del error o estado final de la transacción
   */
  protected $description;

  /**
   * @var ServiceOrder la notificación de 10Fold que dio origen a la novedad
   */
  protected $notification;

  /**
   * @var User el usuario bajo el cual se generó la transacción
   */
  protected $user;

  /**
   * @var Provider el dueño de la transacción
   */
  protected $provider;

  /**
   * @var boolean un flag que indica si el estado de 10Fold ha sido actualizado o no
   */
  protected $notified = false;

  /**
   * @var DateTime una fecha que indica cuando se hizo el último cambio de estado
   */
  protected $lastStatusChange;

  /**
   * @var string un lapso de tiempo que indica el período de revalidación de la transacción.
   */
  protected $interval;

  /**
   * @var DateTime la fecha del último intento de aprovisionar que se hizo sobre la transacción
   */
  protected $lastTry;

  /**
   * Retorna la definición para el ORM de la clase GoogleAccount
   * 
   * @param ORM $orm el manejador de objetos para el cual se registra la definición
   * @return ORMDefinition La definición de la clase GoogleAccount
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001B0705
	return parent::define($orm)
				->setClass('GoogleTransactionType')
				->setTable('GA_TRANSACTION')
				->addField('id', 'TRANSACTION_ID', ORMDefinition::INTEGER)
				->setKey('id')
				->addField('readed', 'TRANSACTION_READED', ORMDefinition::DATETIME)
				->addField('finished', 'TRANSACTION_FINISHED', ORMDefinition::DATETIME)
				->addField('domain', 'TRANSACTION_DOMAIN', ORMDefinition::STRING, 255)
				->addField('licences', 'TRANSACTION_LICENCES', ORMDefinition::INTEGER, 4, 0)
				->addField('delegatedDNS', 'TRANSACTION_DELEGATEDDNS', ORMDefinition::BOOLEAN)
				->addField('description', 'TRANSACTION_DESCRIPTION', ORMDefinition::STRING, 2000)
				->addInstance('user', 'USER_ID', 'User')
				->addInstance('provider', 'PROVIDER_ID', 'Provider')
				->addInstance('account', 'ACCOUNT_ID', 'GoogleAccount')
				->addInstance('type', 'TRANSACTIONTYPE_ID', 'GoogleTransactionType')
				->addInstance('status', 'STATUS_ID', 'GoogleStatus')
				->addInstance('notification', 'SERVICEORDERTASKID', 'ServiceOrder')
				->addField('notified', 'TRANSACTION_NOTIFIED', ORMDefinition::BOOLEAN)
				->addField('lastStatusChange', 'TRANSACTION_LASTSTATUSCHANGE', ORMDefinition::DATETIME, null, null, false, 'NOW()')
				->addField('interval', 'TRANSACTION_INTERVAL', ORMDefinition::STRING, 20)
				->addField('lastTry', 'TRANSACTION_LAST_TRY', ORMDefinition::DATETIME)
				->addValidation('interval', "regexp /^(P([0-9]+Y)?([0-9]+M)?([0-9]+[DW])?(T([0-9]+H)?([0-9]+M)?([0-9]+S)?)?)?$/ El intérvalo no está bien escrito, ejemplos: P1D (un día) ó PT40M30S (40 minutos, 30 segundos) ó P2DT1H25M (2 días, 1 hora, 25 minutos)")
				;
    // Bouml preserved body end 001B0705
  }

}
?>