<?php
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa un estado de una transacción del sistema de AutoProvisioning de GoogleApps.
 * 
 * @method string getDescription()
 * @method GoogleStatus setDescription()
 */
class GoogleStatus extends ORMObject {
  /**
   * @const int constante que significa que la transacción está pendiente.
   */
  const PENDING = 1;

  /**
   * @const int indica que algo está en progreso
   */
  const IN_PROGRESS = 2;

  /**
   * @const int indica que un proceso está completo y con éxito
   */
  const COMPLETED = 3;

  /**
   * @const int estado que se emplea para indicar que en algun punto el proceso no pudo continuar por problemas técnicos recuperables
   */
  const SUSPENDED = 4;

  /**
   * @const int se emplea para indicar el fallo irreversible de una operación. Ejemplo: no se proveyeron datos completos o algun paso da un error de negocios que debe solventarse antes de otro modo.
   */
  const CANCELED = 5;

  /**
   * @const int se emplea para indicar que la operación se descartó por alguna razón.
   */
  const ABORTED = 6;

  /**
   * @var string el estado de la una transacción
   */
  protected $description;

  /**
   * Retorna la definición para el ORM de la clase GoogleAccount
   * 
   * @param ORM $orm el manejador de objetos para el cual se registra la definición
   * @return ORMDefinition La definición de la clase GoogleAccount
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001B0605
	return parent::define($orm)
				->setClass('GoogleStatus')
				->setTable('GA_STATUS')
				->addField('id', 'STATUS_ID', ORMDefinition::INTEGER)
				->setKey('id')
				->addField('description', 'STATUS_DESCRIPTION', ORMDefinition::STRING, 25)
				;
    // Bouml preserved body end 001B0605
  }

}
?>