<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/models/googleapps/GoogleAccount.php';
require_once 'iplan/models/googleapps/forms/GoogleAccountForm.php';
require_once 'iplan/models/googleapps/forms/GoogleStatusForm.php';
require_once 'iplan/models/googleapps/forms/GoogleTransactionForm.php';
require_once 'iplan/models/googleapps/forms/GoogleTransactionTypeForm.php';
require_once 'iplan/models/googleapps/forms/GoogleTransferTokenForm.php';
require_once 'iplan/models/googleapps/APIGoogleApps.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/googleapps/GoogleTransaction.php';
require_once 'iplan/models/provisioning/ServiceOrder.php';
require_once 'iplan/models/googleapps/forms/GoogleTxtForm.php';
require_once 'iplan/security/User.php';
require_once 'iplan/models/googleapps/forms/GoogleChangeUserPasswordForm.php';
require_once 'iplan/models/googleapps/forms/GoogleTransactionIntervalForm.php';

require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
require_once 'iplan/models/provisioning/LogMessages.php';

/**
* Author: Jorge Alexis Viqueira
* 
*/
class GoogleAppsProvisioningManager extends AbstractManager {
  /**
   * @var SoapClient una instancia para el singleton de DNS
   */
  private $dnsSoapClient;

  /**
   * @var int un código de proceso generado eventualmente por alguna transacción. Sólo debe usarse si la transacción no provino de 10Fold
   */
  private $lastProcessId;

  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 0018F705
	return array();
    // Bouml preserved body end 0018F705
  }

  /**
   * Lista las cuentas creadas efectivamente por el autoprovisioning (aunque posteriormente se hayan dado de baja) y aquellas que responden a una creación manual en esta plataforma.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listGoogleAccounts(&$context, $ajax)
  {
    // Bouml preserved body begin 001AEC85
	$orm = $this->application->getORM();
	
	$isClient = $orm->query('Profile')->filterBy('provider.id', '=', $context->getProvider()->getId())
									   ->filterBy('name', '=', 'Cliente GoogleApps')
									   ->filterBy('users.id', '=', $context->getUser()->getId())
									   ->findOne();

	$webList = new WebList($this);

	if ($isClient) {
		$nroCliente = new Column('Nro. Cliente', 'client.clientNumber', false);
	} else {
		$nroCliente = new Column('Nro. Cliente', 'client.clientNumber', false, null, true, 'AutoProvisioning.listClients');
		$nroCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'client.clientNumber'));
	
		$webList->addColumn(new Column('ID', 'id', true));
	}

	$webList->addColumn($nroCliente)
			->addColumn(new Column('Cliente', 'client.name'))
			->addColumn(new Column('Dominio', 'domain'))
			->addColumn(new Column('Licencias', 'licences'))
			->addColumn(new Column('Delega DNS', array('delegatedDNS', 'txt'), false, '{{(delegatedDNS?("Delegado<br/><span style=\"font-style:italic\">Registro TXT:"~(txt?"<span style=\"color:green\">"~txt:"<span style=\"color:red\">No configurado")~"</span></span>"):"No delegado")|raw}}'))
			->addColumn(new Column('Transfer Token', array('requireTransferToken', 'transferToken'), false, '{{(requireTransferToken?(transferToken?"<span style=\"color:green\">"~transferToken~"</span>":"<span style=\"color:red\">Transfer Token no establecido</span>"):"<span style=\"color:green\">No Requiere Transfer Token</span>")|raw}}'))
			->addColumn(new Column('Creado', 'created'))
			->addColumn(new Column('Baja', 'deleted'))
			->addColumn(new Column('Acciones', array('requireTransferToken', 'delegatedDNS', 'deleted', 'creation_status', 'creation_finished'), false, '', false, null, array(
				new ActionButton($context, 'GoogleApps.listDomainUsers', 'domain', null, null, null,'{{ (not deleted) and (creation_status == 3) and (not creation_finished is none) }}'),
				new ActionButton($context, 'GoogleApps.goToAdminPanel', 'domain', null, null, null, '{{ (not deleted) and (creation_status == 3) and (not creation_finished is none) }}'),
				new ActionButton($context, 'GoogleApps.listTransactions', 'domain'),
				new ActionButton($context, 'GoogleApps.modifyGoogleAccount', 'id', null, null, null, '{{ not deleted }}'),
				new ActionButton($context, 'GoogleApps.deleteGoogleAccount', 'id', null, 'alert inline', null, '{{ not deleted }}'),
				new ActionButton($context, 'GoogleApps.setTransferToken', 'id', null, null, null, '{{(requireTransferToken==1) and (not deleted) and (creation_finished is none)}}'),
				new ActionButton($context, 'GoogleApps.setTxtRecord', 'id', null, null, null, '{{(delegatedDNS==1) and (not deleted) and (requireTransferToken==0)}}')
			)))
			->setListFunction(function (GoogleAppsProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) use ($isClient) {
							$query = $orm->query('GoogleAccount')
										 ->attributes('id', 'domain', 'licences', 'delegatedDNS', 'created', 'deleted', 'client.name', 'client.clientNumber', 'requireTransferToken', 'transferToken', 'txt')
										 ->filterBy('provider.id', '=', $context->getProvider()->getId())
									;
							if ($isClient) {
								$query->filterBy('client.user.id', '=', $context->getUser()->getId());
							}
							$query->dontWorryAbout("client");
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id DESC');
							$res = $query->find();
							
							//Tomar los ids de cuenta
							if ($res) {
								$ids = array_map(function($item) { return $item['id']; }, $res);

								//Buscar las transacciones de creación de dichas cuentas
								$conn = $orm->getDatabase()->getConnection();
								$resource = $conn->query('SELECT A.ACCOUNT_ID, A.ACCOUNT_DOMAIN, T.TRANSACTION_FINISHED, T.STATUS_ID
											   FROM GA_ACCOUNT A
													INNER JOIN GA_TRANSACTION T 
													ON T.ACCOUNT_ID = A.ACCOUNT_ID 
													AND T.TRANSACTION_FINISHED = (SELECT MAX(TT.TRANSACTION_FINISHED) 
																				  FROM GA_TRANSACTION TT 
																				  WHERE TT.ACCOUNT_ID = A.ACCOUNT_ID
																					AND TT.STATUS_ID = 3
																					AND TT.TRANSACTIONTYPE_ID=1
																					AND TT.TRANSACTION_FINISHED IS NOT NULL
																				  )
												WHERE T.TRANSACTIONTYPE_ID = 1  AND T.STATUS_ID = 3
													AND A.ACCOUNT_ID IN ('.  implode(',', $ids).')');
								$res2 = $conn->fetchAll($resource);
								$conn->free($resource);
								//Hacer el merge de los resultados
								Utils::merge($res, array('id'=>'ACCOUNT_ID'), $res2, array('ACCOUNT_ID'=>'creation_id', 'TRANSACTION_FINISHED'=>'creation_finished', 'STATUS_ID'=>'creation_status'));
								/*
								//Buscar las transacciones de validación de dichas cuentas
								$resource = $conn->query('SELECT A.ACCOUNT_ID, A.ACCOUNT_DOMAIN, T.TRANSACTION_FINISHED, T.STATUS_ID
											   FROM GA_ACCOUNT A
													INNER JOIN GA_TRANSACTION T 
													ON T.ACCOUNT_ID = A.ACCOUNT_ID 
													AND T.TRANSACTION_FINISHED = (SELECT MAX(TT.TRANSACTION_FINISHED) 
																				  FROM GA_TRANSACTION TT 
																				  WHERE TT.ACCOUNT_ID = A.ACCOUNT_ID
																					AND TT.STATUS_ID = 3
																					AND TT.TRANSACTIONTYPE_ID=8
																					AND TT.TRANSACTION_FINISHED IS NOT NULL
																				  )
												WHERE T.TRANSACTIONTYPE_ID = 8  AND T.STATUS_ID = 3
													AND A.ACCOUNT_ID IN ('.  implode(',', $ids).')');
								$res3 = $conn->fetchAll($resource);
								$conn->free($resource);

								//Hacer el merge de los resultados
								Utils::merge($res, array('id'=>'ACCOUNT_ID'), $res3, array('ACCOUNT_ID'=>'validation.id', 'TRANSACTION_FINISHED'=>'validation.finished', 'STATUS_ID'=>'validation.status'));
								*/
							}
							return $res;
					  })
			->addAction(new ActionButton($context, 'GoogleApps.addGoogleAccount'))
			;
	
	$layout = new GridLayout(1, 4);
	if (!$isClient) {
		$layout->addComponent(new TextComponent(array("label" => "Nro. Cliente", "name"=>"clientNumber","maps" => "client.clientNumber")), 1, 1)
				->addComponent(new TextComponent(array("label" => "Razón Social","name"=>"clientName", "maps" => "client.name")), 1, 2)
				;
	}
	$layout->addComponent(new TextComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain', 'size'=>25)), 1, 3)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	$form = new Form();
	$form->addComponent($layout)
		 ->addComponent(new HiddenComponent(array("maps" => "client.id", "name" => "cliente_id")))
		 ->setMethod('post')
		 ->setTitle('Listado de cuentas de GoogleApps')
		 ->setAction('GoogleApps.listAccounts');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001AEC85
  }

  /**
   * En el caso de las altas y modificaciones, abre un formulario para editar una cuenta de Google.
   * Este proceso permite registrar la cuenta en la base de datos y encolar una tarea de autoprovisioning que posteriormente intentará crear efectivamente la cuenta en el servicio de Google.
   * Para el caso de la baja, directamente encolará una tarea de autoprovisioning de baja.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmGoogleAccount(&$context, $ajax)
  {
    // Bouml preserved body begin 001A8605
	$orm = $this->application->getORM();
	$form = new GoogleAccountForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001A8605
  }

  /**
   * Muestra un listado de las transacciones registradas en la plataforma de provisioning de GoogleApps. Estas pueden ser efectivamente realizadas o pendientes.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listTransactions(&$context, $ajax)
  {
    // Bouml preserved body begin 001B0905
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id', true))
			->addColumn(new Column('Dominio', array('domain', 'notificationId'), false, '<span style="font-weight:bold;">{{domain}}</span><br/><span style="font-style:italic">Id Tarea: {% set ac = actionInfo("AutoProvisioning.listServiceOrderTasks","system_id=19&id="~notificationId, "desktop_center_content") %}<a href="{{ ac["link"] }}" onclick="{{ ac["AJAH"] }}" onkeypress="{{ ac["AJAH"] }}">{{notificationId}}</a></span>'))
			->addColumn(new Column('Tipo', 'type.description'))
			->addColumn(new Column('Lic.', 'licences'))
			->addColumn(new Column('DNS', 'delegatedDNS', false, '{{delegatedDNS?\'<span class="icon32 server_add32"/>\':\'<span class="icon32 server_delete32"/>\'}}'))
			->addColumn(new Column('Estado', 'statusDesc', false, '<span style="font-face:arial;color:{{(statusDesc=="Completado")?"green":((statusDesc=="Cancelado" or statusDesc=="Abortado")?"red":"blue")}}">{{statusDesc}}</span>'))
			->addColumn(new Column('10Fold', 'notified', false, '{{notified?\'<span class="icon32 accept32"/>\':\'<span class="icon32 delete32"/>\'}}'))// 
			->addColumn(new Column('Información', array('readed','lastStatusChange','lastTry', 'finished'), false, '<span style="white-space:nowrap;"><span style="color:green">Creada: {{readed}}</span><br/><span style="color:blue">Status: {{lastStatusChange}}<br/>Intento: {{lastTry}}</span><br/><span style="color:green;">Finalizado: {{finished}}</span></span>'))
			->addColumn(new Column('Intérvalo', 'interval'))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Usuario', 'user.username'))
			->addColumn(new Column('Acciones', 'statusDesc', false, '', false, null, array(
				new ActionButton($context, 'GoogleApps.changeTransactionInterval', 'id', null, null, null, '{{((statusDesc in ["Pendiente", "Suspendido"]))}}'),
				new ActionButton($context, 'GoogleApps.modifyTransaction', 'id', null, null, null, '{{((statusDesc in ["Pendiente", "Suspendido"]))}}'),
				new ActionButton($context, 'GoogleApps.deleteTransaction', 'id', null, 'alert inline', null, '{{((statusDesc in ["Pendiente", "Suspendido"]))}}'),
				new ActionButton($context, 'GoogleApps.listAccounts', 'domain')
			)))
			->setListFunction(function (GoogleAppsProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('GoogleTransaction')
										 ->attributes('id', 'domain', 'licences', 'delegatedDNS', 'readed', 'finished', 'notified','lastStatusChange', 'user.username',
													  'status.description as statusDesc', 'type.description','account', 'description', 'interval', 'lastTry', 'notification.id as notificationId')
										 ->dontWorryAbout('account', 'notification')
										 ->filterBy('provider.id', '=', $context->getProvider()->getId())
									;
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id DESC');
							$res = $query->find();
							return $res;
					  })
			->addAction(new ActionButton($context, 'GoogleApps.addTransaction'))
			;
	
	$layout = new GridLayout(1, 5);
	$layout->addComponent(new TextComponent(array('label'=>'Dominio', 'name'=>'domain', 'maps'=>'domain', 'size'=>25)), 1, 1)
		   ->addComponent(new TextComponent(array('label'=>'ID de Tarea', 'name'=>'notification', 'maps'=>'notification.id', 'size'=>8)), 1, 2)
		   ->addComponent(new SelectComponent(array('label'=>'Estado', 'name'=>'state', 'maps'=>'status.id',
										  'options'=>$orm->query('GoogleStatus')->attributes('id as value', 'description')->find())), 1, 3)
		   ->addComponent(new SelectComponent(array('label'=>'Tipo', 'name'=>'type', 'maps'=>'type.id',
										  'options'=>$orm->query('GoogleTransactionType')->attributes('id as value', 'description')->find())), 1, 4)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de cuentas de GoogleApps')
		 ->setAction('GoogleApps.listTransactions');
	
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001B0905
  }

  /**
   * Permite agregar transacciones nuevas y quitar o modificar transacciones pendientes (únicamente).
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmTransaction(&$context, $ajax)
  {
    // Bouml preserved body begin 001B0985
	$orm = $this->application->getORM();
	$form = new GoogleTransactionForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001B0985
  }

  /**
   * Lista los distintos estados en los que puede estar una transacción en el sistema de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 001B0A05
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Estado', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'GoogleApps.modifyStatus', 'id'),
				new ActionButton($context, 'GoogleApps.deleteStatus', 'id', null, 'alert inline')
			)))
			->setListFunction(function (GoogleAppsProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('GoogleStatus')
										 ->attributes('id', 'description');
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'GoogleApps.addStatus'))
			;
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Estado', 'status', 'description'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Estados')
		 ->setAction('GoogleApps.listStatus');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001B0A05
  }

  /**
   * Permite hacer el alta, baja o modificación de un estado de transacción de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 001B0A85
	$orm = $this->application->getORM();
	$form = new GoogleStatusForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001B0A85
  }

  /**
   * Lista los tipos de transacciones que admite la plataforma de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listTransactionTypes(&$context, $ajax)
  {
    // Bouml preserved body begin 001B0B05
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Tipo de Transacción', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'GoogleApps.modifyTransactionType', 'id'),
				new ActionButton($context, 'GoogleApps.deleteTransactionType', 'id', null, 'alert inline')
			)))
			->setListFunction(function (GoogleAppsProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('GoogleTransactionType')
										 ->attributes('id', 'description');
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'GoogleApps.addTransactionType'))
			;
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Estado', 'status', 'description'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Estados')
		 ->setAction('GoogleApps.listTransactionTypes');
	
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001B0B05
  }

  /**
   * Permite hacer el alta, baja o modificación de un tipo de transacción de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmTransactionType(&$context, $ajax)
  {
    // Bouml preserved body begin 001B0B85
	$orm = $this->application->getORM();
	$form = new GoogleTransactionTypeForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001B0B85
  }

  /**
   * Permite hacer el alta, baja o modificación de un tipo de transacción de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function setTransferToken(&$context, $ajax)
  {
    // Bouml preserved body begin 001C1B05
	$orm = $this->application->getORM();
	$form = new GoogleTransferTokenForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001C1B05
  }

  /**
   * Permite configurar el registro TXT para aquellos clientes que tengan delegado el dominio.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function setTxtRecord(&$context, $ajax)
  {
    // Bouml preserved body begin 001C8B05
	$orm = $this->application->getORM();
	$form = new GoogleTxtForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001C8B05
  }

  /**
   * Crea un registro en el DNS
   * 
   * @param GoogleTransaction $transaction la transacción para la cual se hace el agregado
   * @param LogMessages $log la clase de logueo actual
   * @param string $domain el dominio al que pertenece el registro, más que nada para identificar la zona
   * @param string $type el tipo de registro, puede ser: A, CNAME, MX o TXT
   * @param string $source el valor a resolver
   * @param string $destination el valor a retornar al resolver el source
   * @param string $mx_prefix la prioridad del registro en caso de ser de tipo MX
   * 
   * @return string Devuelve 'OK' si todo se realizó con éxito o si el registro ya existía. En caso de error retorna el mensaje del Web Service.
   */
  public function createDNSRecord(&$transaction, &$log, $domain, $type, $source, $destination, $mx_prefix = '')
  {
    // Bouml preserved body begin 001BE405
	if ($this->dnsSoapClient == null) {
		$this->dnsSoapClient = new SoapClient(null, 
										array(	'soap_version' => SOAP_1_1, 
												"exceptions" => true ,
												"trace" => true, 
												"compression" => false,
												"location" => 'http://10.10.1.245:80/IPLWSDatosPackTecnicoWeb/sca/IPLWSDatosPackTecnicoExport',
												"uri" => 'http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb',
											));
	}
	$strRequest = '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:RegistroDNS">
				   <soapenv:Header/>
				   <soapenv:Body>
					  <urn:registros soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
						 <registro_datos xsi:type="urn:registro_datos" xmlns:urn="urn:RegistrosDNS">
							<dominio xsi:type="xsd:string">'.$domain.'</dominio>
							<tipo xsi:type="xsd:string">'.$type.'</tipo>
							<origen xsi:type="xsd:string">'.$source.'</origen>
							<destino xsi:type="xsd:string">'.$destination.'</destino>
							<mx_prefix xsi:type="xsd:string">'.$mx_prefix.'</mx_prefix>
							<accion xsi:type="xsd:string">A</accion>
						 </registro_datos>
					  </urn:registros>
				   </soapenv:Body>
				</soapenv:Envelope>';
	$res = $this->dnsSoapClient->__doRequest($strRequest,
									  'http://ws.nociplan.com.ar/dns/registro_dns_dev.php#', 
									  null, SOAP_1_1 );

	$this->saveFileLog($transaction, $log, $strRequest, '1', '21');
	$this->saveFileLog($transaction, $log, $res, '1', '22');

	$dom2 = new DOMDocument();
	$dom2->loadXML($res);
	$xpath2 = new DOMXPath($dom2);
	$xpath2->registerNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
	$xpath2->registerNamespace("urn", "urn:RegistroDNS");

	//Levanto los datos cabecera
	$result = trim($xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/urn:registrosResponse/return/resultado/text())"));
	$message = trim($xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/urn:registrosResponse/return/mensaje/text())"));
	
	if ($result == 'OK') return 'OK';
	else return $message;
    // Bouml preserved body end 001BE405
  }

  /**
   * Borra un registro en el DNS
   * 
   * @param GoogleTransaction $transaction la transacción para la cual se hace el agregado
   * @param LogMessages $log la clase de logueo actual
   * @param string $domain el dominio al que pertenece el registro, más que nada para identificar la zona
   * @param string $type el tipo de registro, puede ser: A, CNAME, MX o TXT
   * @param string $source el resuelto
   * @param string $destination el valor de retorno al resolver el source
   * 
   * @return boolean Devuelve TRUE si todo anduvo bien, FALSE en caso contrario.
   */
  public function deleteDNSRecord(&$transaction, &$log, $domain, $type, $source, $destination)
  {
    // Bouml preserved body begin 001BE485
	if ($this->dnsSoapClient == null) {
		$this->dnsSoapClient = new SoapClient(null, 
										array(	'soap_version' => SOAP_1_1, 
												"exceptions" => true ,
												"trace" => true, 
												"compression" => false,
												"location" => 'http://10.10.1.245:80/IPLWSDatosPackTecnicoWeb/sca/IPLWSDatosPackTecnicoExport',
												"uri" => 'http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb',
											));
	}
	$strRequest = '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:RegistroDNS">
				   <soapenv:Header/>
				   <soapenv:Body>
					  <urn:registros soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
						 <registro_datos xsi:type="urn:registro_datos" xmlns:urn="urn:RegistrosDNS">
							<dominio xsi:type="xsd:string">'.$domain.'</dominio>
							<tipo xsi:type="xsd:string">'.$type.'</tipo>
							<origen xsi:type="xsd:string">'.$source.'</origen>
							<destino xsi:type="xsd:string">'.$destination.'</destino>
							<mx_prefix xsi:type="xsd:string">'.$mx_prefix.'</mx_prefix>
							<accion xsi:type="xsd:string">B</accion>
						 </registro_datos>
					  </urn:registros>
				   </soapenv:Body>
				</soapenv:Envelope>';
	$res = $parentService->__doRequest($strRequest,
									  'http://ws.nociplan.com.ar/dns/registro_dns_dev.php#', 
									  null, SOAP_1_1
									 );

	$this->saveFileLog($transaction, $log, $strRequest, '1', '21');
	$this->saveFileLog($transaction, $log, $res, '1', '22');

	$dom2 = new DOMDocument();
	$dom2->loadXML($res);
	$xpath2 = new DOMXPath($dom2);
	$xpath2->registerNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
	$xpath2->registerNamespace("urn", "urn:RegistroDNS");

	//Levanto los datos cabecera
	$result = trim($xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/urn:registrosResponse/return/resultado/text())"));
	$message = trim($xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/urn:registrosResponse/return/mensaje/text())"));
	
	return $result == 'OK';
    // Bouml preserved body end 001BE485
  }

  /**
   * Recupero la metadata asociada a una transacción.
   * 
   * @param GoogleTransaction $transaction la transacción.
   * 
   * @return string La metadata asociada.
   */
  public function getMetadata($transaction)
  {
    // Bouml preserved body begin 001BE385
	$conn = $this->application->getORM()->getDatabase()->getConnection();
	$params=array(1, $transaction->getNotification()->getId());
	$result=null;
	$result2 = $conn->executeFunction('PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL', $params, $result, Connection::T_CURSOR);
	if (($datos = $conn->fetch($result2))) {
		$metadata=$datos['METADATA']->load();
		$conn->free($result);
		return $metadata;
	} else {
		return false;
	}
    // Bouml preserved body end 001BE385
  }

  /**
   * @var ProvisioningPlataformas una instancia de dicha clase empleada para utilizar el servicio de 10Fold de actualización de suscripciones
   */
  private $provisioningPlataform;

  /**
   * Cambia el estado de una novedad en 10Fold y en la base de datos local
   * 
   * @param GoogleTransaction $transaction la transacción que se relaciona con la novedad
   * @param string $description una descripción para 10Fold
   * 
   * @return boolean Devuelve TRUE si todo está bien o FALSE si no.
   */
  public function change10FoldAndDBStatus(&$transaction, &$log)
  {
    // Bouml preserved body begin 001BC805
	$conn = $this->application->getORM()->getDatabase()->getConnection();
	$serviceOrder = $transaction->getNotification();
	$description = null;
	$user = '';
	$password = '';
	switch($transaction->getType()->getDescription()) {
		case 'Creación de Cuenta GoogleApps':
			if (!$transaction->getAccount()->getRequireTransferToken()) {
				$user = 'admin';
				$password = substr(sha1($transaction->getDomain()), 10, 8);
			}
		default:
			$description = $transaction->getDescription();
	}
	//echo "Llamando a ProvisioningPlataformas->update10FoldStatus(ttt, sss, $description, $user, $password)\n";
	$status = '';
	switch ($transaction->getStatus()->getId()) {
		case GoogleStatus::CANCELED:
		case GoogleStatus::ABORTED:
			$status = 'CN';
			break;
		case GoogleStatus::COMPLETED:
			$status = 'CO';
			break;
		case GoogleStatus::IN_PROGRESS:
		case GoogleStatus::PENDING:
		case GoogleStatus::SUSPENDED:
		default:
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error, se mando a completar en TenFold una suscripción en estado inválido", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
			return false;
	}
	
	$description = $transaction->getDescription();
	if (!$transaction->getNotified()) {
		$res = $this->update10FoldStatus($serviceOrder, $status, $description, $log, $user, $password);
		if ($res === true) {
			$transaction->setNotified(true)
						->save();
		} else {
			return $res;
		}
	}
	
	$res = $this->updateDBStatus($serviceOrder, (($transaction->getStatus()->getDescription() == 'Completado')?7:9), $log);
	if ($res === true) {
		$transaction->setFinished('NOW()')
					->save();
		return (array("codigo" => "ok", "descripcion" => "ok"));
	} else {
		return $res;
	}
    // Bouml preserved body end 001BC805
  }

  /**
   * Cambia el estado de la orden de servicio en 10Fold.
   * 
   * @param ServiceOrder $serviceOrder la orden de servicio
   * @param string $status el nuevo estado: CO, WI o CN
   * @param string $description la descripción del estado
   * @param string $user el usuario si corresponde
   * @param string $password el password si corresponde
   * @return true|array Devuelve true si todo fue bien o un array con claves 'codigo' y 'descripcion' en caso de error
   */
  public function update10FoldStatus($serviceOrder, $status, $description, $log, $user = null, $password = null)
  {
    // Bouml preserved body begin 001E6F85
	$task = $serviceOrder->getId();

	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "ESB SpsTaskUpdate: Tarea [$task] Estado [$status] Descripción [$description] PlatformUser [$user] PlatformPass [**********] SistemaID [".ProvisioningPlataformas::GOOGLE_APPS."]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
	try {
		$client = new SoapClient(ProvisioningPlataformas::ESB_10FOLD_UPDATE_TASKS, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
	} catch(SoapFault $fault) {
		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		trigger_error("Problemas de conexion al web service", E_USER_WARNING);
		return array('codigo'=>'error', 'descripcion'=> "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]");
	}
	try {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_TF, 0, "Intento actualizar el status", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		$userUpdate = ProvisioningPlataformas::ESB_10FOLD_UPDATE_TASKS_USER;
		$passUpdate = ProvisioningPlataformas::ESB_10FOLD_UPDATE_TASKS_PASS;
		$result = $client->__soapCall("SpsApiUpdateTaskStatusOperation", array("parameters" => array("task" => $task, "status" => $status, "description" => $description, "username" => $userUpdate, "password" => $passUpdate, "platformUser" => $user, "platformPass" => $password)));
		$response = $client->__getLastResponse();
		$request = $client->__getLastRequest();
		$this->saveFileLog($serviceOrder, $log, $request, 1, 5);
		$this->saveFileLog($serviceOrder, $log, $response, 1, 6);

		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Actualizado el estado en TenFold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		return true;
	} catch (SoapFault $fault) {	
		$response = $client->__getLastResponse();
		$request = $client->__getLastRequest();

		$this->saveFileLog($serviceOrder, $log, $request, 1, 5);
		$this->saveFileLog($serviceOrder, $log, $response, 1, 6);
		
		$dom = new DOMDocument();
		$dom->loadXML($response);
		$xpath = new DOMXPath($dom);
		$xpath->registerNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
		$moreDetails = $xpath->query('//soapenv:Body/soapenv:Fault/detail');
		if ($moreDetails->length==1) {
			$moreText = $moreDetails->item(0)->nodeValue;
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "SpsApiTasksOperation - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "] $moreText", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
			if (strpos($moreText, 'Se intenta asignar un estado identico al actual')) {
				return true;
			}
		} else {
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "SpsApiTasksOperation - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "] ", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		}
		
		return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
	}
    // Bouml preserved body end 001E6F85
  }

  /**
   * Cambia el estado de la orden de servicio en la base local.
   * 
   * @param ServiceOrder $serviceOrder la orden de servicio
   * @param string $status el nuevo estado: 7 Completado o 9 Cancelado
   * @return true|array Devuelve true si todo fue bien o un array con claves 'codigo' y 'descripcion' en caso de error
   */
  public function updateDBStatus($serviceOrder, $status, $log)
  {
    // Bouml preserved body begin 001E7005
	//Cambio el estado local de la ServiceOrderTask
	$context = $this->application->getContext();
	$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_serviceordertask_id" => (int)$serviceOrder->getId(), "p_estado" => $status, "p_serviceprovider_id" => (int)$serviceOrder->getSystem()->getId());
	$result = null;
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Actualizando el estado en base local", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
	$orm = $this->application->getORM();
	$lala = $orm->getDatabase()->getConnection()->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD", $params, $result, Connection::T_CURSOR);
	$asd = $orm->getDatabase()->getConnection()->fetch($lala);
	$orm->getDatabase()->getConnection()->free($lala);
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD [$desc]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		return (array("codigo" => "error", "descripcion" => $desc));
	} else {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Estado actualizado en base local", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		return true;
	}
    // Bouml preserved body end 001E7005
  }

  /**
   * Guarda un documento como parte del log.
   * 
   * @param GoogleTransaction $transaction la transacción para la cual se está guardando el log
   * @param LogMessages $log el objeto de logs
   * @param string|array $contents un string que representa el contenido del archivo o un arreglo de strings donde cada uno representa un contenido de archivo distinto.
   * @param int $contentType el tipo de mensaje (XML, HTTP, etc...) en el que está dado el/los string/s.
   * @param int $messageType la clasificación interna del mensaje (request/response).
   * 
   * @return boolean Devuelve True si todo anduvo bien, False en caso contrario.
   */
  public function saveFileLog(&$transaction, &$log, $contents, $contentType, $messageType)
  {
    // Bouml preserved body begin 001E0605
	if (is_null($log)) return false;
	if (is_a($transaction, 'GoogleTransaction')) {
		$serviceOrder = $transaction->getNotification();
	} else {
		$serviceOrder = $transaction;
	}
	$context = $this->application->getContext();
	$process = (!is_null($serviceOrder))?$serviceOrder->getProcess()->getId():$this->lastProcessId;
	$sellOrder = (!is_null($serviceOrder))?$serviceOrder->getSellOrder():'';
	$taskId = (!is_null($serviceOrder))?$serviceOrder->getId():'';
	
	$conn = $this->application->getORM()->getDatabase()->getConnection();
	
	if (is_string($contents)) {
		$contents=array($contents);
	}
	foreach($contents as $content) {
		//Agrego el contenido a la tabla de archivos
		$params = array("p_user_id" => $context->getUser()->getId(), "p_clob" => $content, "p_t_xml_id" => $messageType, 'p_t_mensaje_id' => $contentType);
		$result = null;
		$lala = $conn->executeClobPackage("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", $params, "p_clob", $result, Connection::T_CURSOR);
		$asd = $conn->fetch($lala);
		$conn->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 5, "PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS $desc", $sellOrder, $process, $taskId);
			trigger_error("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", E_USER_WARNING);
		} else {
			$content_id = $asd["LASTID"];
		}
		//Agrego la relación con la Orden de Venta
		$params = array("p_user_id" => $context->getUser()->getId(), "p_orden" => $sellOrder, "p_xml_id" => $content_id);
		$result = null;
		$lala = $conn->executeFunction("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", $params, $result, Connection::T_CURSOR);
		$asd = $conn->fetch($lala);
		$conn->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 5, "PKG_CAP_ORDENESXML.FU_ORDENESXML_INS $desc", $sellOrder, $process, $taskId);
			trigger_error("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", E_USER_ERROR);
		}
		//Agrego la relación con la ServiceOrder
		$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_serviceordertaskid" => (int)$taskId, "p_xml_id" => (int)$content_id);
		$result = null;
		$lala = $conn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", $params, $result, Connection::T_CURSOR);
		$asd = $conn->fetch($lala);
		$conn->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS $desc", $sellOrder, $process, $taskId);
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", E_USER_ERROR);
		}
	}
	return true;
    // Bouml preserved body end 001E0605
  }

  /**
   * Aprovisiona las novedades pendientes
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function aprovisionar(&$context, $ajax)
  {
    // Bouml preserved body begin 001A1D05
	$orm = $this->application->getORM();

	//Nota: al final, como el proceso no se va a llamar en forma concurrente, el estado "WORKING" no se utiliza.
	//     en caso que a futuro se disparen múltiples instancias de provisioning, será necesario marcar cada transacción
	//     y cambiar la forma de recorrido.
	
	$transacciones = $orm->query('GoogleTransaction')
						 ->filterBy('status.description', 'IN', array('Pendiente', 'Suspendido'))
						 ->orderBy('id ASC')
						 ->find();
	
	$log = LogMessages::GetInstance($orm->getDatabase()->getConnection(), $context->getUser()->getId(), LogMessages::SYS_CAGA);
	$log->getMensajes();
	if ($transacciones) {
		$api = new APIGoogleApps();
		$api->initLog($context, $orm, $log);
		$loginOK = false;
		try {
			$loginOK = $api->registerInGoogleApps('admin@reseller2.iplan.com.ar', 'ty45v5234');
		} catch(Exception $e) {
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 17, 'Fallo inesperado al autenticar: '.$e->getMessage());
		}

		if ($loginOK) {
			foreach($transacciones as $transaction) {/* @var $transaction GoogleTransaction*/
				try {
					//Valido el intérvalo
					$interval = $transaction->getInterval();
					$lastTry = $transaction->getLastTry();/* @var $lastTry DateTime */
					$now = new DateTime();
					
					if ((!is_null($interval)) && (!is_null($lastTry))) {
						$interval = new DateInterval($interval);
						$startAt = $now->sub($interval);
						if ($lastTry > $startAt)
							continue;
					}
					
					$originalStatus = $transaction->getStatus();
					$api->setTransaction($transaction);
					
					switch($transaction->getType()->getDescription()) {
						case 'Creación de Cuenta GoogleApps':
							$this->createAccount($transaction, $context, $api, $log);
							break;
						case 'Delegación de Dominio para GoogleApp':
							$this->configureDNS($transaction, $context, $api, $log);
							break;
						case 'Upgrade de Licencias para GoogleApps':
						case 'Downgrade de Licencias para GoogleApps':
							$this->changeLicenceLimit($transaction, $context, $api, $log);
							break;
						case 'Baja de Delegación de Dominio para GoogleApps':
							$account = $transaction->getAccount();
							$account->setDelegatedDNS(false);
							if ($account->save()) {
								$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
											->setDescription("Cambiado el flag de la cuenta con éxito");
							} else {
								$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
											->setDescription("No se pudo cambiar el flag de DNS de la cuenta");
							}
							break;
						case 'Baja de Cuenta de GoogleApps':
							$this->deleteAccount($transaction, $context, $api, $log);
							//TODO: Quitar permisos al usuario si es que no tiene más cuentas de google activas
							break;
						case 'Alta de Registro TXT':
							$this->createTXTRecord($transaction, $context, $api, $log);
							break;
						case 'Validación de Dominio':
							$this->validateDomain($transaction, $context, $api, $log);
							break;
						default:
							//LOGUEAR QUE HUBO UNA TRANSACCIÓN NO REGISTRADA!!!
					}
					$now = new DateTime();
					if ($originalStatus->getId() != $transaction->getStatus()->getId()) {
						$transaction->setLastStatusChange('NOW()');
						if ($transaction->getNotification() == null) {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, 'La operación ha cambiado de estado de '.$originalStatus->getDescription().' a '.$transaction->getStatus()->getDescription(), null, $this->lastProcessId, null);
						} else {
							$so = $transaction->getNotification();
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, 'La operación ha cambiado de estado de '.$originalStatus->getDescription().' a '.$transaction->getStatus()->getDescription(), $so->getSellOrder(), $so->getProcess()->getId(), $so->getId());
						}
					}
					$transaction->setLastTry('NOW()')
								->save();
					
					if (  ( ($transaction->getStatus()->getId()== GoogleStatus::COMPLETED) || 
							($transaction->getStatus()->getId()== GoogleStatus::CANCELED)    ) 
						&& (!is_null($transaction->getNotification()))) {
						if ($transaction->getType()->getDescription() == 'Validación de Dominio') {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 25, "Fin", null, $this->lastProcessId, null);
						}
					} else {
						if (($transaction->getStatus()->getId()== GoogleStatus::COMPLETED) || 
							($transaction->getStatus()->getId()== GoogleStatus::CANCELED)) {
							$transaction->setFinished('NOW()')
											->save();
						}
						if ($transaction->getNotification() == null)
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 25, "Fin", null, $this->lastProcessId, null);
						else {
							$so = $transaction->getNotification();
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 25, "Fin", $so->getSellOrder(), $so->getProcess()->getId(), $so->getId());
						}
					}
				} catch (Exception $e) {
					//TODO Ver si se cancela la transacción e informar a 10Fold
					throw new Exception('Problemas en '.$transaction->getType()->getDescription(). ' para el dominio '.$transaction->getDomain(), 0, $e);
				}
			}
		}
	}
	
	//Ahora me fijo si quedaron cosas para 10Fold (de ahora o anteriores)
	$transacciones = $orm->query('GoogleTransaction')
						 ->filterBy('status.description', 'IN', array('Completado', 'Cancelado', 'Abortado'))
						 //->filterBy('notified', '=', '0')
						 ->filterBy('notification.state.id', '=', 3)
						 ->filterBy('type.description', '<>', 'Validación de Dominio')
						 //->filterBy('notification', 'IS NOT NULL')
						 ->orderBy('id ASC')
						 ->find();
	if ($transacciones) {
		foreach($transacciones as $transaction) {/* @var $transaction GoogleTransaction */
			$res = $this->change10FoldAndDBStatus($transaction, $log);
			$serviceOrder = $transaction->getNotification();/* @var $serviceOrder ServiceOrder */
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 25, "Fin", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
		}
	}

	//Parche para que si falló el ESB y dejó tareas sin transacciones se cancelen en 10fold
	$novedadesHuerfanas = $orm->query('ServiceOrder')
						 ->filterBy('system.description', '=', 'Google Apps')
						 ->filterBy('state.id', '=', '3')//Pendiente
						 ->filterBy('googleAppsTransactions', 'IS NULL')
						 ->find()
					;
	if ($novedadesHuerfanas) {
		foreach($novedadesHuerfanas as $novedad) {
			$res = $this->update10FoldStatus($novedad, 'CN', 'Posible error inesperado: Transacción huérfana en AutoProvisioning de Google Apps', $log);
			if ($res === true) {
				$res = $this->updateDBStatus($novedad, 9, $log);
			} else {
				//Cuando encuentre un caso de Estado duplicado lo pongo en update10foldstatus
			}
		}
	}
	//Agregar a ServiceOrder el atributo relación googleAppsTransactions -> 1..N y preguntar cuando googleAppsTransactions IS NULL

	return true;
    // Bouml preserved body end 001A1D05
  }

  /**
   * Intenta crear una cuenta de GoogleApps
   * 
   * @param GoogleTransaction $transaction la transacción a ejecutar
   * @param ApplicationContext $context el contexto de ejecución
   * @param APIGoogleApps $api la instancia de la clase de comunicaciones con GoogleApps
   * @param LogMessages $log la instancia de log
   */
  public function createAccount(&$transaction, &$context, &$api, &$log)
  {
    // Bouml preserved body begin 001C6E85

	$orm = $this->application->getORM();
	$domain = $transaction->getDomain();
	$serviceOrder = $transaction->getNotification();
	$originalStatus = $transaction->getStatus();

	//Verifico que la transacción esté en un estado válido
	if (!(($originalStatus->getId()==GoogleStatus::PENDING) || ($originalStatus->getId()==GoogleStatus::SUSPENDED)))
			throw new Exception('No se puede aprovisionar una transacción en estado distinto de Pendiente o Suspendida [Transacción: '.$transaction->getId().']');

	//Inicializo variables de log
	if ($serviceOrder) {
		$sellOrder = $serviceOrder->getSellOrder();
		$process = $serviceOrder->getProcess()->getId();
		$serviceOrderId = $serviceOrder->getId();
	} else {
		$sellOrder = null;
		$serviceOrderId = null;

		//Robe&Paste de Fede en ProvisioningManager
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Creo el Proceso para las Tareas");
		$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_estado" => 3);
		$result = null;
		$dbconn = $orm->getDatabase()->getConnection();
		$cursor = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
		$processRes = $dbconn->fetch($cursor);
		$dbconn->free($cursor);
		if ( (!is_array($processRes)) || (( isset($processRes["SQLCODE_ERROR"])) && ($processRes["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($processRes) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
			trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
			return false;
		} else {
			$process = $processRes["LASTID"];
			$this->lastProcessId = $process;
			$api->setLastProcessId($process);
		}
	}

	$account = $transaction->getAccount();
	$client = $account->getClient();

	if ($serviceOrder != null) {
		$metadata = $this->getMetadata($transaction);
		$dom = new DOMDocument();
		$dom->loadXML($metadata);
		$xpath = new DOMXPath($dom);
		$address = $xpath->evaluate("string(/Metadata/Contacto/Email/text())");
		$nombre = $xpath->evaluate("string(/Metadata/Contacto/Nombre/text())");
		$apellido = $xpath->evaluate("string(/Metadata/Contacto/Apellido/text())");
	} else {
		if ($client != null) {
			$address = $client->getMail();
			$nombre = $client->getContactName();
			$apellido = $client->getContactLastName();
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED));
			$transaction->setDescription('No se encontró metadata, ni datos del cliente');
			return $transaction->save();
		}
	}

	if ((!$client) || ($client->getUser()==null)) {

		if ($serviceOrder != null) {
			$name = $xpath->evaluate('string(/Metadata/Cliente/text())');
			$mail = $xpath->evaluate('string(/Metadata/Contacto/Email/text())');
			$cgp  = $xpath->evaluate('string(/Metadata/CGP/text())');
		} else {
			if (!$client) {
				$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED))
							->setDescription('Se intenta crear un usuario pero no hay metadata, ni datos del cliente.')
							->save();
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, 'Se intenta crear un usuario pero no hay metadata, ni datos del cliente. Transacción CANCELADA [Transacción '.$transaction->getId().']', $sellOrder, $process, $serviceOrderId);
				return;
			} else {
				$name = $client->getName();
				$mail = $client->getMail();
				$cgp  = $context->getManager('Application')->clientToCGP($client->getClientNumber());
			}
		}
		
		//Chequeo si existe un usuario con el CGP del cliente
		$user = $orm->query('User')
					->filterBy('username', '=', $cgp)
					->filterBy('provider.id', '=', $context->getProvider()->getId())
					->findOne();

		//Si no existe entonces lo creo con los permisos básicos
		if (!$user) {
			$user = new User($orm);
			$user->setLoginUnificado(true)
				 ->setName($name)
				 ->setUsername($cgp)
				 ->setStatus(USER::USER_ACTIVE)
				 ->setProvider($context->getProvider())
				 ->setMail($mail)
				 ->addProfile($orm->query('Profile')
								  ->filterBy('provider.id', '=', $context->getProvider()->getId())
								  ->filterBy('name', '=', 'Usuarios Registrados - iPlan')
								  ->findOne()
							 );
			if ($user->save()) {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Creado con éxito el usuario $cgp para el cliente $name.", $sellOrder, $process, $serviceOrderId);
			} else {
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "No se pudo crear el usuario CGP: ".$serviceOrder->getCgp(), $sellOrder, $process, $serviceOrderId);
				return;
			}
		}
	} else {
		$user = $client->getUser();
	}
	
	//Verifico que la transacción tenga una cuenta con cliente asignado y sino intento crearlo
	if (!$client) {
		//Busco entre los clientes, por las dudas que otro proceso lo haya creado entre aprovisionamientos
		$nroCliente = ltrim(substr($serviceOrder->getCgp(), 0, -1), "0");
		$client = $orm->query('Client')->filterBy('clientNumber', '=', $nroCliente)->findOne();

		//Si no encontré ninguno intento crearlo
		if ($client == false) {

			//Ahora vamos por el cliente
			//Creo el cliente
			$contactName     = $xpath->evaluate('string(/Metadata/Contacto/Nombre/text())');
			$contactLastName = $xpath->evaluate('string(/Metadata/Contacto/Apellido/text())');

			$client = new Client($orm);
			$client->setUser($user)
				   ->setClientNumber($nroCliente)
				   ->setClientType(Client::WEB_CLIENT)
				   ->setContactLastName($contactName)
				   ->setContactName($contactLastName)
				   ->setMail($mail)
				   ->setName($name)
				   ->setPayPlan($orm->query('PayPlan')->filterBy('description', '=', 'Postpago')->findOne())
				   ->setReseller($orm->query('Reseller')->filterBy('provider.id', '=', $context->getProvider()->getId())->findOne())
				   ->setStatus(1) //TODO: En todos está 1, pero revisar bien qué significa. Asumo que cuando se borra un cliente
								  //     se pone en 0, pero no tengo clientes dados de baja en la base.
				;
			if ($client->save()) {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Creado el cliente para $name.", $sellOrder, $process, $serviceOrderId);
			} else {
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al crear el cliente para el cliente $name.", $sellOrder, $process, $serviceOrderId);
				return;
			}
		}
		//Asigno el cliente a la transacción
		if (!$account->setClient($client)->save()) {
			return;
		}
	} else {
		if ($client->getUser() == null)
			if (!$client->setUser($user)->save()) return;
	}
	
	//Verifico que el User tenga el perfil
	if (!$orm->query('Profile')->filterBy('provider.id', '=', $context->getProvider()->getId())
							   ->filterBy('name', '=', 'Cliente GoogleApps')
							   ->filterBy('users.id', '=', $client->getUser()->getId())
							   ->findOne() ) {
		$client->getUser()->addProfile($orm->query('Profile')
										 ->filterBy('provider.id', '=', $context->getProvider()->getId())
										 ->filterBy('name', '=', 'Cliente GoogleApps')
										 ->findOne())
						  ->save();
	}
	
	//Hago los chequeos con Google
	$validated = $api->validateClientDomain($domain);
	//--$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_GA, 23, "Verificado dominio $domain: $validated.", $sellOrder, $process, $serviceOrderId);
	switch($validated) {
		//Si está creada la cuenta, verifico que exista el administrador y finalmente asigno permisos al usuario del cliente y remito mail
		case 'ES_DE_IPLAN':
			$salir = false;
			
			//Chequeo si el dominio está verificado o si existe una transacción de validación de dominio pendiente o en suspendida.
			if (!$api->verifyDomain($transaction->getDomain())) {
				//Busco si ya existe una transacción de validación para este dominio.
				$validationTransaction = $orm->query('GoogleTransaction')
											 ->filterBy('account.id', '=', $transaction->getAccount()->getId())
											 ->filterBy('type.description', '=', 'Validación de Dominio')
											 ->findOne();
				if (!$validationTransaction) {
					//Crear transacción de validación de dominio y mandar mail
					$validationTransaction = new GoogleTransaction($orm);
					$validationTransaction->setReaded('NOW()')
								->setDomain($transaction->getDomain())
								->setLicences($transaction->getLicences())
								->setProvider($transaction->getProvider())
								->setUser($transaction->getUser())
								->setType($orm->query('GoogleTransactionType')->filterBy('description', '=','Validación de Dominio')->findOne())
								->setStatus($orm->load('GoogleStatus', GoogleStatus::PENDING))
								->setAccount($transaction->getAccount())
								->setNotification($transaction->getNotification())
								->setInterval($this->getGlobal('DomainValidationAdvice'))
								->setProvider($transaction->getProvider())
								;

					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Generando transacción de validación del dominio para ".$transaction->getDomain(), $sellOrder, $process, $serviceOrderId);
					if ($orm->save($validationTransaction)) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Transacción[".$validationTransaction->getId()."] de validación del dominio generada con éxito", $sellOrder, $process, $serviceOrderId);
					} else {
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 23, "Fallo al generar la transacción de validación de dominio", $sellOrder, $process, $serviceOrderId);
						continue;
					}
				}
			}
			
			$licences = $api->getMaxNumberOfLicences($domain);
			if ($licences != $transaction->getLicences()) {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se encontró que las licencias del dominio $domain son $licences y deberían ser ".$transaction->getLicences().". Se procede a su corrección...", $sellOrder, $process, $serviceOrderId);
				if ($api->setMaxNumberOfLicences($domain, $transaction->getLicences())) {
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Limitado el nro. de cuentas de $licences a ".$transaction->getLicences()." para $domain.", $sellOrder, $process, $serviceOrderId);
				} else {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
							->setDescription("No se pudo limitar la cuenta a ".$transaction->getLicences()." para $domain. Actualmente tiene $licences.")
							->setInterval($this->getGlobal('SetAccountLimitFail'));
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al limitar las licencias de $domain. Suspendiendo la transacción, se intentará después.", $sellOrder, $process, $serviceOrderId);
					continue;
				}
			}
			
			$admins = $api->listDomainUsers($domain, true);
			if ($admins === false)
				continue;//$salir = true;//Si no puedo consultar los usuarios hago un break;

			if (count($admins) == 0) {
				if ($api->createDomainUser($domain, 'admin', substr(sha1($domain), 10, 8), 'Administrador', 'IPlan', true)) {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
								->setDescription("Creado el usuario administrador con éxito.");
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Creado el usuario administrador con éxito.", $sellOrder, $process, $serviceOrderId);
				} else {
					$transaction->setDescription("Fallo al crear el usuario administrador.")
								->setInterval($this->getGlobal('AdminCreation'));
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al crear el usuario administrador en $domain. Suspendiendo la transacción.", $sellOrder, $process, $serviceOrderId);
					continue;
				}
			} else {
				//Parece estar todo bien, la pongo en completa
				$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
							->setDescription("Detectado que la cuenta $domain estaba creada con éxito.")
							->setFinished('NOW()');
				//$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Creado el usuario administrador con éxito.", $sellOrder, $process, $serviceOrderId);
			}

			if ($transaction->getDelegatedDNS()) {
				$records = array(
								array($domain, 'MX', 'alt1.aspmx.l.google.com', 5),
								array($domain, 'MX', 'alt2.aspmx.l.google.com', 5),
								array($domain, 'MX', 'aspmx2.googlemail.com', 10),
								array($domain, 'MX', 'aspmx3.googlemail.com', 10),
								array($domain, 'MX', 'aspmx4.googlemail.com', 10),
								array($domain, 'MX', 'aspmx5.googlemail.com', 10),
								array("mail.$domain", 'CNAME', 'ghs.google.com', ''),
								array("calendar.$domain", 'CNAME', 'ghs.google.com', ''),
								array("docs.$domain", 'CNAME', 'ghs.google.com', ''),
								array("sites.$domain", 'CNAME', 'ghs.google.com', ''),
						   );
				$allOK = true;
				foreach($records as $record) {
					$res = $this->createDNSRecord($transaction, $log, $domain, $record[1], $record[0], $record[2], $record[3]);
					//echo "DNS = $res\n";
					switch($res) {
						case 'OK':break;
						case 'NO EXISTE LA ZONA':
							$transaction->setDescription('Aguardando creación de zona DNS')
										->setInterval($this->getGlobal('DNSZoneNotExist'));
							$allOK = false;
							break 2;//Directamente sale del foreach
						default:
							$transaction->setDescription("Error al crear registros DNS [$res]")
										->setInterval($this->getGlobal('DNSZoneNotExist'));
							$allOK = false;
							break 2;//Directamente sale del foreach
					}
				}

				if ($allOK) {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
								->setDescription($transaction->getDescription().'. DNS Creados con éxito');
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "DNS para $domain creados con éxito.", $sellOrder, $process, $serviceOrderId);
				} else {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED));
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Fallo al crear los registros DNS de GoogleApps para $domain. $res.", $sellOrder, $process, $serviceOrderId);
				}
				
			}	
			
			break;
		//Si no es de IPlan, asumo que es estándar y aviso al usuario que necesita TransferToken o sino espero a que lo ingrese.
		//Acá NO se crea el admin porque la cuenta ya existe y solo asigno permisos y mando mail
		case 'NO_ES_DE_IPLAN':
			//Chequeo si el transfer token ya fue solicitado. Esto se determina porque la cuenta tiene seteado el "requireTransferToken"
			if ($account->getRequireTransferToken()) {
				if ($account->getTransferToken()) {
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Intentando promover la cuenta $domain con el transfer token ".$account->getTransferToken(), $sellOrder, $process, $serviceOrderId);
					if ($api->upgradeStandardToPremium($domain, $transaction->getLicences(), 'AR', $account->getTransferToken())) {
						$licences = $api->getMaxNumberOfLicences($domain);
						if ($licences != $transaction->getLicences()) {
							if ($api->setMaxNumberOfLicences($domain, $transaction->getLicences())) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Limitado el nro. de cuentas de $licences a ".$transaction->getLicences()." para $domain.", $sellOrder, $process, $serviceOrderId);
							} else {
								$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
										->setDescription("No se pudo limitar la cuenta a ".$transaction->getLicences()." para $domain. Actualmente tiene $licences.")
										->setInterval($this->getGlobal('SetAccountLimitFail'));
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al limitar las licencias de $domain. Suspendiendo la transacción, se intentará después.", $sellOrder, $process, $serviceOrderId);
								continue;
							}
						}
						$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
									->setDescription("Se ha promovido $domain a Premium con éxito");
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se ha promovido la cuenta $domain a Premium con éxito.", $sellOrder, $process, $serviceOrderId);
					} else {
						switch($api->getLastErrorCode()) {
							case '1200': //Cantidad de usuarios excedida
								$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
											->setDescription("La cuenta $domain tiene más usuarios que los contratados.");
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18,"Error al crear el dominio $domain en Google porque el cliente tiene creadas más cuentas gratuitas que las premium contratadas.", $sellOrder, $process, $serviceOrderId);
								$mailBody = '<p>Hemos  detectado que ya dispones de cuentas en Google y la cantidad a transferir es  mayor a la que contrataste en IPLAN. Para resolver esto, puedes contratar m&aacute;s  cuentas en IPLAN o dar de baja las cuentas que no desees en Google.</p>
        Te sugerimos que  corrijas esta situaci&oacute;n. En breve se pondr&aacute; en contacto con vos un representante  para regularizar esta situaci&oacute;n.
    <p>Cordialmente,<br>';
								$mailSend = $this->sendMail($address, $client->getName(), "$apellido $nombre", 'Google Apps - Error en la cantidad de cuentas', $mailBody);
								if ($mailSend) {
									$transaction->setDescription($transaction->getDescription()." Mail enviado a $address");
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Enviado el mail al cliente pidiendo que borre cuentas.", $sellOrder, $process, $serviceOrderId);
									$transaction->setInterval($this->getGlobal('AccountLimitExceeded'));
								} else {
									$transaction->setDescription($transaction->getDescription()." Error al enviar el mail a $address pidiendo el borrado de cuentas")
												->setInterval($this->getGlobal('MailFail'));
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al enviar el mail solicitando el borrado de las cuentas excedentes.", $sellOrder, $process, $serviceOrderId);
								}
								break;
							case '1801'://Token Inválido
								$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
											->setDescription("Error al promocionar el dominio $domain en Google con token \"".$account->getTransferToken()."\".")
											->setInterval($this->getGlobal('TransferTokenFail'));
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18,"Error al crear el dominio $domain en Google con token \"".$account->getTransferToken()."\". Suspendo la transacción.", $sellOrder, $process, $serviceOrderId);
								$mailBody = '<p>Hemos detectado que el código de validación "Transfer Token" que ingresaste no es  correcto. Por  favor, te solicitamos que generes un nuevo código y lo cargues nuevamente en  nuestra plataforma de administración del servicio. 
El  mismo tenés que generarlo en Google como se informa en el siguiente link: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=33321" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>33321</a> <br><br>
Una  vez que dispongas de dicho código, tenés que cargarlo en nuestra plataforma  como se indica <a href="http://iplan.com.ar/wps/wcm/connect/1837f132-2771-45cc-b095-2831d6fec3c3/Google_Apps_-_Instructivo_-_carga_-_Transfer-Token.pdf?MOD=AJPERES" target="_blank">aquí</a>. <br><br>
Dispones  de 5 días para realizar esta gestión. Superado dicho plazo se vencerá el código  obtenido y tendrás que volver a obtener el mismo en Google.</p>
¡Esperamos que completes  estos pasos con éxito para avanzar con el alta del servicio!
<p>Cordialmente,</p><br>';
								$mailSend = $this->sendMail($address, $client->getName(), "$apellido $nombre", 'Google Apps - Error en la validación del Transfer Token', $mailBody);
								if ($mailSend) {
									$transaction->setDescription($transaction->getDescription()." Mail enviado a $address");
									$account->setTransferToken('')->save();//Limpio el transfer token así hasta que no lo re-ingrese no se hace nada
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Enviado el mail con pedido de TransferToken.", $sellOrder, $process, $serviceOrderId);
								} else {
									$transaction->setDescription($transaction->getDescription()." Error al enviar el mail de pedido de rectificación de TransferToken a $address");
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al enviar el mail de rectificación de TransferToken. Se deja la transacción en pendiente.", $sellOrder, $process, $serviceOrderId);
								}
								break;
							default: //Cancelo porque ignoro de que se trata.
								$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED))
											->setDescription("Error al crear el dominio $domain en Google. Error ".$api->getLastErrorCode().": ".$api->getLastError());
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error ".$api->getLastErrorCode().": \"".$api->getLastError()."\" al crear el dominio $domain en Google. Cancelando la transacción.", $sellOrder, $process, $serviceOrderId);
						}
					}
				} else {
					//Por las dudas le reenvio el mail de pedido de transferToken
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "No se ha cargo el TransferToken, preparando el mail de recordatorio al cliente...", $sellOrder, $process, $serviceOrderId);
					$mailBody = '<p>Queremos  recodarte que el servicio de correo <span style="font-weight: bold;">Google Apps</span> para el dominio <span style="color:#ff2352;font-weight:bold">'.$account->getDomain().'</span> aún no ha sido dado de alta dado que  no generaste el código "transfer token", o lo obtuviste y no lo cargaste en  nuestra plataforma.</p>
<p>Google requiere que gestiones un código de validación denominado "Transfer Token" y lo  cargues en nuestra plataforma de administración del servicio cuando el dominio se encuentra creado en sus servidores bajo otro reseller. 
El  mismo tenés que generarlo en Google como se informa en el siguiente link: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=33321" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>33321</a> <br>
<br>
Una  vez que dispongas de dicho código, tenés que cargarlo en nuestra plataforma  como se indica <a href="http://iplan.com.ar/wps/wcm/connect/1837f132-2771-45cc-b095-2831d6fec3c3/Google_Apps_-_Instructivo_-_carga_-_Transfer-Token.pdf?MOD=AJPERES" target="_blank">aquí</a>. <br>
<br>
Dispones  de 5 días para realizar esta gestión. Superado dicho plazo se vencerá el código  obtenido y tendrás que volver a obtener el mismo en Google.</p>
¡Esperamos que completes  estos pasos con éxito para avanzar con el alta del servicio!
<p>Cordialmente,</p><br>';
					$mailSend = $this->sendMail($address, $client->getName(), "$apellido $nombre", 'Google Apps - Recordatorio Creacion de Transfer Token', $mailBody);
					if ($mailSend) {
						$transaction->setDescription('Reenviado mail solicitando al cliente que ingrese el Transfer Token')->setInterval($this->getGlobal('TransferTokenNotSet'));
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Enviado el mail de recordatorio al cliente con pedido de TransferToken.", $sellOrder, $process, $serviceOrderId);
					}
				}
			} else {//Si el usuario no fue notificado, se le remite la notificación
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Detectada la necesidad de un transfer token. Se suspende la transacción hasta su ingreso.", $sellOrder, $process, $serviceOrderId);
				if ($account->setRequireTransferToken(true)->save()) {
					$mailBody = '<p>Queremos  informarte que tu dominio <span style="color:#ff2352;font-weight:bold">'.$account->getDomain().'</span>  ya esta creado en Google y se encuentra bajo la administración de otro  reseller. </p>
<p>Para  dar de alta el servicio de correo <span style="font-weight: bold;">Google  Apps</span> en IPLAN, es necesario que gestiones un código de validaci&oacute;n  denominado "Transfer Token" en Google y lo cargues en nuestra plataforma de  administración del servicio. 
El  mismo tenés que generarlo en Google como se informa en el siguiente link: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=33321" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>33321</a> </p>
<p>Una  vez que dispongas de dicho código, tenés que cargarlo en nuestra plataforma  como se indica <a href="http://iplan.com.ar/wps/wcm/connect/1837f132-2771-45cc-b095-2831d6fec3c3/Google_Apps_-_Instructivo_-_carga_-_Transfer-Token.pdf?MOD=AJPERES" target="_blank">aquí</a>. </p>
<p>Dispones  de 5 días para realizar esta gestión. Superado dicho plazo se vencerá el código  obtenido y tendrás que volver a obtener el mismo en Google.</p>
<p>¡Esperamos  que completes estos pasos con éxito para avanzar con el alta del servicio!</p>
<p>Cordialmente,</p><br>';
					$mailSend = $this->sendMail($address, $client->getName(), "$apellido $nombre", 'Google Apps - Creacion de Transfer Token', $mailBody);
					if ($mailSend) {
						$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
									->setDescription("Detectada la necesidad de un Transfer Token. Mail enviado a $address")
									->setInterval($this->getGlobal('FirstTransferTokenNotification'));
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Enviado el mail al cliente con pedido de TransferToken.", $sellOrder, $process, $serviceOrderId);
					} else {
						$transaction->setDescription("Error al enviar el mail de pedido de TransferToken")
									->setInterval($this->getGlobal('MailFail'));
						$account->setRequireTransferToken(false)->save();
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al enviar el mail de pedido de TransferToken. Se deja la transacción en pendiente.", $sellOrder, $process, $serviceOrderId);
					}
				}
			}
			break;
		//Si no existe, hago el proceso de alta completo (con admin), asigno permisos y mando mail
		case 'NO_EXISTE':
			$domain = $transaction->getDomain();
			if ($api->createCustomerDomain($domain, $transaction->getLicences(), 'AR')) {
				
				//Crear transacción de validación de dominio y mandar mail
				$validationTransaction = new GoogleTransaction($orm);
				$validationTransaction->setReaded('NOW()')
							->setDomain($transaction->getDomain())
							->setLicences($transaction->getLicences())
							->setProvider($transaction->getProvider())
							->setUser($transaction->getUser())
							->setType($orm->query('GoogleTransactionType')->filterBy('description', '=','Validación de Dominio')->findOne())
							->setStatus($orm->query('GoogleStatus')->filterBy('description', '=','Pendiente')->findOne())
							->setAccount($transaction->getAccount())
							->setNotification($transaction->getNotification())
							->setInterval($this->getGlobal('DomainValidationAdvice'))
						    ->setProvider($transaction->getProvider())
							;

				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Generando transacción de validación del dominio para ".$transaction->getDomain(), $sellOrder, $process, $serviceOrderId);
				if ($orm->save($validationTransaction)) {
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Transacción[".$validationTransaction->getId()."] de validación del dominio generada con éxito", $sellOrder, $process, $serviceOrderId);
				} else {
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 23, "Fallo al generar la transacción de validación de dominio", $sellOrder, $process, $serviceOrderId);
					continue;
				}
				//End creación de transacción de validación de dominio
				
				$licences = $api->getMaxNumberOfLicences($domain);
				if ($licences != $transaction->getLicences()) {
					if ($api->setMaxNumberOfLicences($domain, $transaction->getLicences())) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Limitado el nro. de cuentas de $licences a ".$transaction->getLicences()." para $domain.", $sellOrder, $process, $serviceOrderId);
					} else {
						$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
								->setDescription("No se pudo limitar la cuenta a ".$transaction->getLicences()." para $domain. Actualmente tiene $licences.")
								->setInterval($this->getGlobal('SetAccountLimitFail'));
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al limitar las licencias de $domain. Suspendiendo la transacción, se intentará después.", $sellOrder, $process, $serviceOrderId);
						continue;
					}
				}
				
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se creo la cuenta GoogleApps para el dominio $domain con éxito.", $sellOrder, $process, $serviceOrderId);
				if ($api->createDomainUser($domain, 'admin', substr(sha1($domain), 10, 8), 'Administrador', 'IPlan', true)) {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
								->setDescription("Creado el dominio $domain en GoogleApps con su admin")
								->setFinished('NOW()');
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se creo la cuenta admin de $domain con éxito.", $sellOrder, $process, $serviceOrderId);

					if ($transaction->getDelegatedDNS()) {
						$records = array(
										array($domain, 'MX', 'alt1.aspmx.l.google.com', 5),
										array($domain, 'MX', 'alt2.aspmx.l.google.com', 5),
										array($domain, 'MX', 'aspmx2.googlemail.com', 10),
										array($domain, 'MX', 'aspmx3.googlemail.com', 10),
										array($domain, 'MX', 'aspmx4.googlemail.com', 10),
										array($domain, 'MX', 'aspmx5.googlemail.com', 10),
										array("mail.$domain", 'CNAME', 'ghs.google.com', ''),
										array("calendar.$domain", 'CNAME', 'ghs.google.com', ''),
										array("docs.$domain", 'CNAME', 'ghs.google.com', ''),
										array("sites.$domain", 'CNAME', 'ghs.google.com', ''),
								   );
						$allOK = true;
						foreach($records as $record) {
							$res = $this->createDNSRecord($transaction, $log, $domain, $record[1], $record[0], $record[2], $record[3]);
							switch($res) {
								case 'OK':break;
								case 'NO EXISTE LA ZONA':
									$transaction->setDescription('Aguardando creación de zona DNS')
												->setInterval($this->getGlobal('DNSZoneNotExist'));
									$allOK = false;
									break 2;//Directamente sale del foreach
								default:
									$transaction->setDescription("Error al crear registros DNS [$res]")
												->setInterval($this->getGlobal('DNSZoneNotExist'));
									$allOK = false;
									break 2;//Directamente sale del foreach
							}
						}

						if ($allOK) {
							$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
										->setDescription($transaction->getDescription().'. DNS Creados con éxito');
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "DNS para $domain creados con éxito.", $sellOrder, $process, $serviceOrderId);
						} else {
							$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED));
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Fallo al crear los registros DNS para $domain. $res.", $sellOrder, $process, $serviceOrderId);
						}
					}	

				} else {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
								->setDescription("No se pudo crear el admin de $domain en GoogleApps")
								->setInterval($this->getGlobal('AdminCreation'));
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al crear el usuario administrador en $domain. Suspendiendo la transacción, se intentará después.", $sellOrder, $process, $serviceOrderId);
				}
			} else {
				$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED))
							->setDescription("Error al crear el dominio $domain en Google.");
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al crear el dominio $domain en Google. Cancelando la transacción.", $sellOrder, $process, $serviceOrderId);
			}
			break;
		default:
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED))
						->setDescription("Transacción desconocida");
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Resultado de la validación del servicio de GoogleApps desconocido [$validated]. Cancelando la transacción.", $sellOrder, $process, $serviceOrderId);
	}


	return $transaction->save();
    // Bouml preserved body end 001C6E85
  }

  /**
   * Intenta crear una cuenta de GoogleApps
   * 
   * @param GoogleTransaction $transaction la transacción a ejecutar
   * @param ApplicationContext $context el contexto de ejecución
   * @param APIGoogleApps $api la instancia de la clase de comunicaciones con GoogleApps
   * @param LogMessages $log la instancia de log
   */
  public function validateDomain(&$transaction, &$context, &$api, &$log)
  {
    // Bouml preserved body begin 001E5605
	$orm = $this->application->getORM();
	$domain = $transaction->getDomain();
	$serviceOrder = $transaction->getNotification();
	$originalStatus = $transaction->getStatus();

	//Verifico que la transacción esté en un estado válido
	if (!(($originalStatus->getId()==GoogleStatus::PENDING) || ($originalStatus->getId()==GoogleStatus::SUSPENDED)))
			throw new Exception('No se puede aprovisionar una transacción en estado distinto de Pendiente o Suspendida [Transacción: '.$transaction->getId().']');

	//Inicializo variables de log
	if ($serviceOrder) {
		$sellOrder = $serviceOrder->getSellOrder();
		$process = $serviceOrder->getProcess()->getId();
		$serviceOrderId = $serviceOrder->getId();
	} else {
		$sellOrder = null;
		$serviceOrderId = null;

		//Robe&Paste de Fede en ProvisioningManager
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Creo el Proceso para las Tareas");
		$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_estado" => 3);
		$result = null;
		$dbconn = $orm->getDatabase()->getConnection();
		$cursor = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
		$processRes = $dbconn->fetch($cursor);
		$dbconn->free($cursor);
		if ( (!is_array($processRes)) || (( isset($processRes["SQLCODE_ERROR"])) && ($processRes["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($processRes) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
			trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
			return false;
		} else {
			$process = $processRes["LASTID"];
			$this->lastProcessId = $process;
			$api->setLastProcessId($process);
		}
	}
	
	if ($api->verifyDomain($transaction->getDomain())) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se ha detectado que se completó la verificación del dominio ".$transaction->getDomain(), $sellOrder, $process, $serviceOrderId);
		$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
					->setDescription("Google informa que el dominio ha sido verificado")
					->setFinished('NOW()');
	} else {
		if ($transaction->getStatus()->getId() == GoogleStatus::PENDING) {
			$days = 21;
		} else {
			$interval = $transaction->getReaded()->diff($transaction->getLastTry());
			$days = 21 - $interval->format('%a');
		}
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "El dominio ".$transaction->getDomain()." aún no ha sido verificado. Restan $days días para la baja de la cuenta.", $sellOrder, $process, $serviceOrderId);		
		
		if ($days <= 0) {
			//Veo si el dominio todavía existe
			if ($api->validateClientDomain($transaction->getDomain()) == 'NO_EXISTE') {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se verifica que el dominio ".$transaction->getDomain()." se ha dado de baja en Google. Preparando la transacción de alta para asegurar la continuidad del servicio", $sellOrder, $process, $serviceOrderId);
				
				//Creo la nueva transacción de alta
				$account = $transaction->getAccount();
				$accountTransaction = new GoogleTransaction($orm);
				$accountTransaction->setAccount($account)
								   ->setDelegatedDNS($account->getDelegatedDNS())
								   ->setDescription('Transacción creada automáticamente')
								   ->setDomain($account->getDomain())
								   ->setLicences($account->getLicences())
								   ->setNotification($transaction->getNotification())
								   ->setReaded('NOW()')
								   ->setStatus($orm->load('GoogleStatus', GoogleStatus::PENDING))
								   ->setType($orm->query('GoogleTransactionType')->filterBy('description', '=','Creación de Cuenta GoogleApps')->findOne())
								   ->setUser($transaction->getUser())
								   ->setProvider($transaction->getProvider())
								   ;
				if ($orm->save($accountTransaction)) {
					//Mandar mail de aviso de baja x google
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED));
					$mailBody = '<p>Te  confirmamos que Google ha eliminado el dominio <span style="color:#ff2352;font-weight:bold">'.$transaction->getDomain().'</span>  de sus servidores, dado que no has creado los registros necesarios para validar  que la solicitud de alta sea legítima del dueño del dominio. </p>
					<p>IPLAN  cargó nuevamente el dominio en la plataforma de <strong>Google Apps</strong>, por lo cual de no hacerlo dentro de los próximos <span style="color:#ff2352;font-weight:bold">'.$days.'</span> días, Google dará de baja todas las  configuraciones del dominio en sus servidores, sin excepción. 
					  Te  brindamos un link donde podrás encontrar mayor información sobre este proceso: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=60216&amp;topic=29597&amp;ctx=topic" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>60216&amp;topic=29597&amp;ctx=topic</a> </p>
					<p>En  caso que necesites soporte para crear el registro "txt" (verificación de  dominio), a continuación te brindamos un link donde encontrarás la explicación  sobre cómo realizarlo: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=2716802" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>2716802</a> </p>
					<p>Una  vez que dispongas de dicho registro tenés que cargar el mismo en tu DNS. Si  IPLAN es quien administra el DNS del dominio, tendrás que cargar el mismo en  nuestra plataforma como se indica <a href="http://iplan.com.ar/wps/wcm/connect/24e73ee1-b0ff-4294-bf6a-724f84a23ce8/Google_Apps_-_Instructivo_-_Carga_-_txt.pdf?MOD=AJPERES" target="_blank">aquí</a>. </p>
					<p>Luego  de configurar éste registro, Google puede demorar hasta 48 horas en finalizar  la validación. </p>
					<p>Una  vez que configures dicho registro te sugerimos que tengas a tu disposición el  mail de activación, el cual te enviamos con anterioridad, dado que es necesario  que continúes con los pasos informados en el mismo.</p>
					<p>Cordialmente,<br>';
					$client = $transaction->getAccount()->getClient();
					$mailSend = $this->sendMail($client->getMail(), $client->getName(), $client->getContactLastName().' '.$client->getContactName(), 'Google Apps - Eliminacion de Dominio por falta de validacion', $mailBody);
					if ($mailSend) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Enviado el mail a ".$client->getMail()." informando de la baja de su cuenta.", $sellOrder, $process, $serviceOrderId);
									$transaction->setDescription('Fin de la verificación, el dominio ha sido dado de baja, se envió mail a '.$client->getMail().' y se procede a recrear la cuenta');
					} else {
						$transaction->setDescription($transaction->getDescription()." Error al enviar el mail a ".$client->getMail()." avisando de la baja del dominio ".$transaction->getDomain()." por falta de validación")
									->setInterval($this->getGlobal('MailFail'));
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al enviar el mail de aviso sobre baja del dominio ".$transaction->getDomain()." por falta de validación.", $sellOrder, $process, $serviceOrderId);
					}
				} else {
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
								->setDescription('Falló la creación de de la transacción de alta');
				}
			} else {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "El dominio ".$transaction->getDomain()." aún está vigente en Google.", $sellOrder, $process, $serviceOrderId);
				$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
						->setDescription("El dominio aún no ha sido verificado. El plazo vence en $days. Última verificación: ".date('d-m-y H:i:s'));
			}
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
						->setDescription("El dominio aún no ha sido verificado. Última verificación: ".date('d-m-y H:i:s'));
			$mailBody = '<p>Te recordamos que hemos finalizado el proceso de activación del servicio de correo<strong> Google Apps</strong> para el dominio <span style="color:#ff2352;font-weight:bold">'.$transaction->getDomain().'</span> en IPLAN. </p>
						<p>Aún  no has creado el registro "txt" que Google requiere para validar que la  solicitud de alta en sus servidores sea legítima del dueño del dominio. En caso  de no hacerlo dentro de los próximos <span style="color:#ff2352;font-weight:bold">'.$days.'</span> días,  Google dará de baja todas las configuraciones del dominio en sus servidores,  sin excepción. 
						  Te  brindamos un link donde podrás encontrar mayor información sobre este proceso: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=60216&amp;topic=29597&amp;ctx=topic" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>60216&amp;topic=29597&amp;ctx=topic</a> </p>
						<p>En  caso que necesites soporte para crear el registro "txt" (verificación de  dominio), a continuación te brindamos un link donde encontrarás la explicación  sobre cómo realizarlo: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=2716802" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>2716802</a> </p>
						<p>Una  vez que dispongas de dicho registro tenés que cargar el mismo en tu DNS. Si  IPLAN es quien administra el DNS del dominio, tendrás que cargarlo en nuestra  plataforma como se indica <a href="http://iplan.com.ar/wps/wcm/connect/24e73ee1-b0ff-4294-bf6a-724f84a23ce8/Google_Apps_-_Instructivo_-_Carga_-_txt.pdf?MOD=AJPERES" target="_blank">aquí</a>. </p>
						<p>Luego  de configurar éste registro, Google puede demorar hasta 48 horas en finalizar  la validación.</p>
						Una vez que configures  dicho registro te sugerimos que tengas a tu disposición el mail de activación (el cual te enviamos con anterioridad), dado que es necesario que continúes con  los pasos informados en el mismo.
						<p>Cordialmente,<br>';
			$client = $transaction->getAccount()->getClient();
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Preparando recordatorio con destino ".$client->getMail(), $sellOrder, $process, $serviceOrderId);
			$mailSend = $this->sendMail($client->getMail(), $client->getName(), $client->getContactLastName().' '.$client->getContactName(), 'Google Apps - Creacion de registro txt', $mailBody);
			if ($mailSend) {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Mail de recordatorio enviado a ".$client->getMail(), $sellOrder, $process, $serviceOrderId);
			} else {
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al enviar el mail de recordatorio a ".$client->getMail(), $sellOrder, $process, $serviceOrderId);
			}
		}

	}
	
	return $transaction->save();
    // Bouml preserved body end 001E5605
  }

  /**
   * Intenta crear una cuenta de GoogleApps
   * 
   * @param GoogleTransaction $transaction la transacción a ejecutar
   * @param ApplicationContext $context el contexto de ejecución
   * @param APIGoogleApps $api la instancia de la clase de comunicaciones con GoogleApps
   * @param LogMessages $log la instancia de log
   */
  public function createTXTRecord(&$transaction, &$context, &$api, &$log)
  {
    // Bouml preserved body begin 001E0805
	$orm = $this->application->getORM();
	$domain = $transaction->getDomain();
	$serviceOrder = $transaction->getNotification();
	$originalStatus = $transaction->getStatus();

	//Verifico que la transacción esté en un estado válido
	if (!(($originalStatus->getId()==GoogleStatus::PENDING) || ($originalStatus->getId()==GoogleStatus::SUSPENDED)))
			throw new Exception('No se puede aprovisionar una transacción en estado distinto de Pendiente o Suspendida [Transacción: '.$transaction->getId().']');

	//Inicializo variables de log
	$sellOrder = null;
	$serviceOrderId = null;

	//Robe&Paste de Fede en ProvisioningManager
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Creo el Proceso para las Tareas");
	$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_estado" => 3);
	$result = null;
	$dbconn = $orm->getDatabase()->getConnection();
	$cursor = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
	$processRes = $dbconn->fetch($cursor);
	$dbconn->free($cursor);
	if ( (!is_array($processRes)) || (( isset($processRes["SQLCODE_ERROR"])) && ($processRes["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($processRes) . " P: " . LogMessages::erroresArray($params);
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
		trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
		return false;
	} else {
		$process = $processRes["LASTID"];
		$this->lastProcessId = $process;
		$api->setLastProcessId($process);
	}
	

	$account = $transaction->getAccount();
	$client = $account->getClient();

	//Datos para mandar mail
	$address = $client->getMail();
	$nombre = $client->getContactName();
	$apellido = $client->getContactLastName();

	if ($transaction->getDelegatedDNS()) {
		$res = $this->createDNSRecord($transaction, $log, $domain, 'TXT', $domain, $transaction->getAccount()->getTxt(), '');
		$allOK = true;
		switch($res) {
			case 'OK':break;
			case 'NO EXISTE LA ZONA':
				$transaction->setDescription('Aguardando creación de zona DNS')
							->setInterval($this->getGlobal('DNSZoneNotExist'));
				$allOK = false;
				break 2;//Directamente sale del foreach
			default:
				$transaction->setDescription("Error al crear registros DNS [$res]")
							->setInterval($this->getGlobal('DNSZoneNotExist'));
				$allOK = false;
				break 2;//Directamente sale del foreach
		}

		if ($allOK) {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
						->setDescription('TXT configurado con éxito');
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "DNS para $domain creados con éxito.", $sellOrder, $process, $serviceOrderId);
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED));
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Fallo al crear el registro TXT de GoogleApps para $domain.", $sellOrder, $process, $serviceOrderId);
		}

	}
	return $transaction->save();

    // Bouml preserved body end 001E0805
  }

  /**
   * Cambia el número máximo de usuarios que puede crear una cuenta de GoogleApps
   * 
   * @param GoogleTransaction $transaction la transacción a ejecutar
   * @param ApplicationContext $context el contexto de ejecución
   * @param APIGoogleApps $api la instancia de la clase de comunicaciones con GoogleApps
   * @param LogMessages $log la instancia de log
   */
  public function changeLicenceLimit(&$transaction, &$context, &$api, &$log)
  {
    // Bouml preserved body begin 001CAB85
	$orm = $this->application->getORM();
	$domain = $transaction->getDomain();
	$serviceOrder = $transaction->getNotification();
	$originalStatus = $transaction->getStatus();

	//Verifico que la transacción esté en un estado válido
	if (!(($originalStatus->getId()==GoogleStatus::PENDING) || ($originalStatus->getId()==GoogleStatus::SUSPENDED)))
			throw new Exception('No se puede aprovisionar una transacción en estado distinto de Pendiente o Suspendida [Transacción: '.$transaction->getId().']');

	//Inicializo variables de log
	if ($serviceOrder) {
		$sellOrder = $serviceOrder->getSellOrder();
		$process = $serviceOrder->getProcess()->getId();
		$serviceOrderId = $serviceOrder->getId();
	} else {
		$sellOrder = null;
		$serviceOrderId = null;

		//Robe&Paste de Fede en ProvisioningManager
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Creo el Proceso para las Tareas");
		$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_estado" => 3);
		$result = null;
		$dbconn = $orm->getDatabase()->getConnection();
		$cursor = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
		$processRes = $dbconn->fetch($cursor);
		$dbconn->free($cursor);
		if ( (!is_array($processRes)) || (( isset($processRes["SQLCODE_ERROR"])) && ($processRes["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($processRes) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
			trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
			return false;
		} else {
			$process = $processRes["LASTID"];
			$this->lastProcessId = $process;
			$api->setLastProcessId($process);
		}
	}

	$account = $transaction->getAccount();
	$client = $account->getClient();

	if ($serviceOrder != null) {
		$metadata = $this->getMetadata($transaction);
		$dom = new DOMDocument();
		$dom->loadXML($metadata);
		$xpath = new DOMXPath($dom);
		$address = $xpath->evaluate("string(/Metadata/Contacto/Email/text())");
		$nombre = $xpath->evaluate("string(/Metadata/Contacto/Nombre/text())");
		$apellido = $xpath->evaluate("string(/Metadata/Contacto/Apellido/text())");
	} else {
		if ($client != null) {
			$address = $client->getMail();
			$nombre = $client->getContactName();
			$apellido = $client->getContactLastName();
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED));
			$transaction->setDescription('No se encontró metadata, ni datos del cliente');
			return $transaction->save();
		}
	}

	$licences = $api->getMaxNumberOfLicences($domain);
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Recuperado el nro. de cuentas de $domain desde Google: $licences", $sellOrder, $process, $serviceOrderId);
	if ($transaction->getType()->getId() == GoogleTransactionType::UPGRADE_ACCOUNT) {
		$newLicences = $licences + $transaction->getLicences();
	} elseif($transaction->getType()->getId() == GoogleTransactionType::DOWNGRADE_ACCOUNT) {
		$newLicences = $licences - $transaction->getLicences();
	}

/*	if ($licences != $transaction->getLicences()) {*/
		if ($api->setMaxNumberOfLicences($domain, $newLicences)) {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
					->setDescription("Cambiado el nro. de cuentas de $licences a $newLicences para $domain.");
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cambiado el nro. de cuentas de $licences a $newLicences para $domain.", $sellOrder, $process, $serviceOrderId);
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED))
					->setDescription("No se pudo cambiar el limite de licencias a $newLicences para $domain. Actualmente tiene $licences.")
					->setInterval($this->getGlobal('SetAccountLimitFail'));
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error al limitar las licencias de $domain. Suspendiendo la transacción, se intentará después.", $sellOrder, $process, $serviceOrderId);
			
			switch($api->getLastErrorCode()) {
				case '1200': //Cantidad de usuarios excedida
					$mailBody = '<p>Hemos  detectado que ya dispones de cuentas en Google y la cantidad a transferir es  mayor a la que contrataste en IPLAN. Para resolver esto, puedes contratar m&aacute;s  cuentas en IPLAN o dar de baja las cuentas que no desees en Google.</p>
        Te sugerimos que  corrijas esta situaci&oacute;n. En breve se pondr&aacute; en contacto con vos un representante  para regularizar esta situaci&oacute;n.
    <p>Cordialmente,<br>';
					$mailSend = $this->sendMail($address, $client->getName(), "$apellido $nombre", 'Google Apps - Error en la cantidad de cuentas', $mailBody);
					if ($mailSend) {
						$transaction->setDescription($transaction->getDescription()." Mail enviado a $address");
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Enviado el mail al cliente pidiendo que borre cuentas.", $sellOrder, $process, $serviceOrderId);
						$transaction->setInterval($this->getGlobal('AccountLimitExceeded'))
									->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED));
					} else {
						$transaction->setDescription($transaction->getDescription()." Error al enviar el mail a $address pidiendo el borrado de cuentas")
									->setInterval($this->getGlobal('MailFail'));
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Error al enviar el mail solicitando el borrado de las cuentas excedentes.", $sellOrder, $process, $serviceOrderId);
					}
					break;
				default: //Cancelo porque ignoro de que se trata.
					$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED))
								->setDescription("Error al cambiar el número de cuentas para el dominio $domain. Error ".$api->getLastErrorCode().": ".$api->getLastError());
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Error ".$api->getLastErrorCode().": \"".$api->getLastError()."\" al cambiar el nro. de cuentas en el dominio $domain. Cancelando la transacción.", $sellOrder, $process, $serviceOrderId);
			}
		}
/*	} else {
		//Parece estar todo bien, la pongo en completa
		$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
					->setDescription("Detectado que la cuenta $domain ya tiene $licences. Se pasa a completa.");
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "La cuenta $domain ya tiene $licences.", $sellOrder, $process, $serviceOrderId);
	}*/

	return $transaction->save();
    // Bouml preserved body end 001CAB85
  }

  /**
   * Cambia el número máximo de usuarios que puede crear una cuenta de GoogleApps
   * 
   * @param GoogleTransaction $transaction la transacción a ejecutar
   * @param ApplicationContext $context el contexto de ejecución
   * @param APIGoogleApps $api la instancia de la clase de comunicaciones con GoogleApps
   * @param LogMessages $log la instancia de log
   */
  public function deleteAccount(&$transaction, &$context, &$api, &$log)
  {
    // Bouml preserved body begin 001CAC05
	$orm = $this->application->getORM();
	$domain = $transaction->getDomain();
	$serviceOrder = $transaction->getNotification();
	$originalStatus = $transaction->getStatus();

	//Verifico que la transacción esté en un estado válido
	if (!(($originalStatus->getId()==GoogleStatus::PENDING) || ($originalStatus->getId()==GoogleStatus::SUSPENDED)))
			throw new Exception('No se puede aprovisionar una transacción en estado distinto de Pendiente o Suspendida [Transacción: '.$transaction->getId().']');

	//Inicializo variables de log
	if ($serviceOrder) {
		$sellOrder = $serviceOrder->getSellOrder();
		$process = $serviceOrder->getProcess()->getId();
		$serviceOrderId = $serviceOrder->getId();
	} else {
		$sellOrder = null;
		$serviceOrderId = null;

		//Robe&Paste de Fede en ProvisioningManager
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Creo el Proceso para las Tareas");
		$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_estado" => 3);
		$result = null;
		$dbconn = $orm->getDatabase()->getConnection();
		$cursor = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
		$processRes = $dbconn->fetch($cursor);
		$dbconn->free($cursor);
		if ( (!is_array($processRes)) || (( isset($processRes["SQLCODE_ERROR"])) && ($processRes["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($processRes) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
			trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
			return false;
		} else {
			$process = $processRes["LASTID"];
			$this->lastProcessId = $process;
			$api->setLastProcessId($process);
		}
	}

	$account = $transaction->getAccount();
	$client = $account->getClient();

	if ($serviceOrder != null) {
		$metadata = $this->getMetadata($transaction);
		$dom = new DOMDocument();
		$dom->loadXML($metadata);
		$xpath = new DOMXPath($dom);
		$address = $xpath->evaluate("string(/Metadata/Contacto/Email/text())");
		$nombre = $xpath->evaluate("string(/Metadata/Contacto/Nombre/text())");
		$apellido = $xpath->evaluate("string(/Metadata/Contacto/Apellido/text())");
	} else {
		if ($client != null) {
			$address = $client->getMail();
			$nombre = $client->getContactName();
			$apellido = $client->getContactLastName();
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED));
			$transaction->setDescription('No se encontró metadata, ni datos del cliente');
			return $transaction->save();
		}
	}


	//si hay transacciones pendientes o suspendidas => abortarlas
	$pendingWork = $orm->query('GoogleTransaction')
					   ->filterBy('domain', '=', $domain)
					   ->filterBy('status', 'IN', array(GoogleStatus::PENDING, GoogleStatus::SUSPENDED))
					   ->filterBy('type', '<>', GoogleTransactionType::DELETE_ACCOUNT)
					   ->find()
			;
	if ($pendingWork) {
		foreach($pendingWork as $pendingTransaction) {
			/* @var $pendingTransaction GoogleTransaction */
			$pendingTransactionDescription = $pendingTransaction->getType()->getDescription();
			$pendingTransactionStatus = $pendingTransaction->getStatus()->getDescription();
			$pendingTransaction->setStatus($orm->load('GoogleStatus', GoogleStatus::ABORTED))
							   ->setDescription('Abortada por la baja '.$transaction->getId())
							   ->setFinished('NOW()')
							   ->save();
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Se abortó la transacción ".$pendingTransaction->getId()." => ($pendingTransactionDescription,$pendingTransactionStatus)", $sellOrder, $process, $serviceOrderId);
		}
	}
	
	//si la cuenta existe => borrarla
	switch ($api->validateClientDomain($domain)) {
		case 'ES_DE_IPLAN':
			if ($api->downgradeAccount($domain)) {
				$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
						->setDescription("El dominio $domain se ha dado de baja con éxito.");
				$transaction->getAccount()->setDeleted('NOW()')->save();
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "El dominio $domain se ha dado de baja con éxito.", $sellOrder, $process, $serviceOrderId);
			} else {
				$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED))
						->setDescription("No se pudo dar de baja el dominio $domain.")
						;
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "No se pudo dar de baja el dominio $domain.", $sellOrder, $process, $serviceOrderId);
			}
			break;
		default:
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
					->setDescription("Se asume completada debido a que $domain no está en la distribución o no existe.")
					;
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Se asume realizada la tarea de baja dado que el dominio $domain no está en la distribución o directamente no existe.", $sellOrder, $process, $serviceOrderId);
	}

	return $transaction->save();
    // Bouml preserved body end 001CAC05
  }

  /**
   * Intenta crear una cuenta de GoogleApps
   * 
   * @param GoogleTransaction $transaction la transacción a ejecutar
   * @param ApplicationContext $context el contexto de ejecución
   * @param APIGoogleApps $api la instancia de la clase de comunicaciones con GoogleApps
   * @param LogMessages $log la instancia de log
   */
  public function configureDNS(&$transaction, &$context, &$api, &$log)
  {
    // Bouml preserved body begin 001C5305

	$orm = $this->application->getORM();
	$domain = $transaction->getDomain();
	$serviceOrder = $transaction->getNotification();
	$originalStatus = $transaction->getStatus();

	//Verifico que la transacción esté en un estado válido
	if (!(($originalStatus->getId()==GoogleStatus::PENDING) || ($originalStatus->getId()==GoogleStatus::SUSPENDED)))
			throw new Exception('No se puede aprovisionar una transacción en estado distinto de Pendiente o Suspendida [Transacción: '.$transaction->getId().']');

	//Inicializo variables de log
	if ($serviceOrder) {
		$sellOrder = $serviceOrder->getSellOrder();
		$process = $serviceOrder->getProcess()->getId();
		$serviceOrderId = $serviceOrder->getId();
	} else {
		$sellOrder = null;
		$serviceOrderId = null;

		//Robe&Paste de Fede en ProvisioningManager
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 0, "Creo el Proceso para las Tareas");
		$params = array("p_user_id" => (int)$context->getUser()->getId(), "p_estado" => 3);
		$result = null;
		$dbconn = $orm->getDatabase()->getConnection();
		$cursor = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
		$processRes = $dbconn->fetch($cursor);
		$dbconn->free($cursor);
		if ( (!is_array($processRes)) || (( isset($processRes["SQLCODE_ERROR"])) && ($processRes["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($processRes) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
			trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
			return false;
		} else {
			$process = $processRes["LASTID"];
			$this->lastProcessId = $process;
			$api->setLastProcessId($process);
		}
	}

	$account = $transaction->getAccount();
	$client = $account->getClient();

	if ($serviceOrder != null) {
		$metadata = $this->getMetadata($transaction);
		$dom = new DOMDocument();
		$dom->loadXML($metadata);
		$xpath = new DOMXPath($dom);
		$address = $xpath->evaluate("string(/Metadata/Contacto/Email/text())");
		$nombre = $xpath->evaluate("string(/Metadata/Contacto/Nombre/text())");
		$apellido = $xpath->evaluate("string(/Metadata/Contacto/Apellido/text())");
	} else {
		if ($client != null) {
			$address = $client->getMail();
			$nombre = $client->getContactName();
			$apellido = $client->getContactLastName();
		} else {
			$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::CANCELED));
			$transaction->setDescription('No se encontró metadata, ni datos del cliente');
			return $transaction->save();
		}
	}
	
	$records = array(
					array($domain, 'MX', 'alt1.aspmx.l.google.com', 5),
					array($domain, 'MX', 'alt2.aspmx.l.google.com', 5),
					array($domain, 'MX', 'aspmx2.googlemail.com', 10),
					array($domain, 'MX', 'aspmx3.googlemail.com', 10),
					array($domain, 'MX', 'aspmx4.googlemail.com', 10),
					array($domain, 'MX', 'aspmx5.googlemail.com', 10),
					array("mail.$domain", 'CNAME', 'ghs.google.com', ''),
					array("calendar.$domain", 'CNAME', 'ghs.google.com', ''),
					array("docs.$domain", 'CNAME', 'ghs.google.com', ''),
					array("sites.$domain", 'CNAME', 'ghs.google.com', ''),
			   );
	$allOK = true;
	foreach($records as $record) {
		$res = $this->createDNSRecord($transaction, $log, $domain, $record[1], $record[0], $record[2], $record[3]);
		switch($res) {
			case 'OK':break;
			case 'NO EXISTE LA ZONA':
				$transaction->setDescription('Aguardando creación de zona DNS')
							->setInterval($this->getGlobal('DNSZoneNotExist'));
				$allOK = false;
				break 2;//Directamente sale del foreach
			default:
				$transaction->setDescription("Error al crear registros DNS [$res]")
							->setInterval($this->getGlobal('DNSZoneNotExist'));
				$allOK = false;
				break 2;//Directamente sale del foreach
		}
	}

	if ($allOK) {
		$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::COMPLETED))
					->setDescription($transaction->getDescription().'. DNS Creados con éxito');
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "DNS para $domain creados con éxito.", $sellOrder, $process, $serviceOrderId);
	} else {
		$transaction->setStatus($orm->load('GoogleStatus', GoogleStatus::SUSPENDED));
		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_GA, 18, "Fallo al crear los registros DNS para $domain. $res.", $sellOrder, $process, $serviceOrderId);
	}
			
	return $allOK;
    // Bouml preserved body end 001C5305
  }

  /**
   * Método empleado para hacer pruebas de la API de GoogleApps
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function testMethod(&$context, $ajax)
  {
    // Bouml preserved body begin 001C3685
	  
	$orm = $this->application->getORM();
	  
	$api = new APIGoogleApps();
/*	$log = LogMessages::GetInstance($orm->getDatabase()->getConnection(), $context->getUser()->getId(), LogMessages::SYS_CAGA);
	$log->getMensajes();
	$api->setLog($log);*/
	$loginOK = false;
	try {
		$loginOK = $api->registerInGoogleApps('admin@reseller2.iplan.com.ar', 'ty45v5234');
//		$loginOK = $api->registerInGoogleApps('info@reseller.iplan.com.ar', '123456asdfg');
	} catch(Exception $e) {
		echo 'Fallo inesperado al autenticar: '.$e->getMessage();
		return;
	}
	echo "\n";
	//$dominio = 'iplan.com.ar';
	//$dominio = 'test-342.reseller2.iplan.com.ar';
	//$dominio = 'taquini.com.ar';
	//$dominio = 'aromatravel.com.ar';
	//$dominio = 'martinpercara.com.ar';
	//$dominio = 'instrulabs.com.ar';
	//$dominio = 'viqs.com.ar';
	//$dominio = 'qmarket.com.ar';
	//$dominio = '123seguro.com.ar';
/*	$dominio = 'iplantech.com.ar';
	
	$estado = $api->validateClientDomain($dominio);
	$verificado = $api->verifyDomain($dominio);
	$cantidadDeUsuariosActivos = $api->countDomainUsers($dominio);
	$cantidadMaximaDeUsuarios  = $api->getMaxNumberOfLicences($dominio);
	$userList = $api->listDomainUsers($dominio);

	echo "Estado del dominio: $estado [Resultado de verificación: ".($verificado?'Verificado':'No Verificado')."]\n";
	echo "Cantidad de usuarios del dominio $dominio:\t$cantidadDeUsuariosActivos de $cantidadMaximaDeUsuarios\n";
	echo "Listado de usuarios del dominio:\n";
	if (is_array($userList)) {
		foreach($userList as $user) {
			echo "\t".$user['username']."\t\t".($user['admin']?'Admin':'User')."\t".$user['surname'].",".$user['name']."\t".($user['suspended']?'Suspendida':'Activa')."\t". $user['quota'] ."\n";
		}
	} else {
		var_dump($userList);
	}
*/
	
/*	$dominio = 'pegsagroup.com.ar';
	$dominio = 'arlog.org';
	$dominio = '123seguro.com.ar';
	$dominio = 'argentina.travel';
	$dominio = 'bdpinternational.com.ar';
	$dominio = 'test-221.reseller2.iplan.com.ar';
	$dominio = 'endemol.com.ar';
	$dominio = 'savagliostudio.com';
	$dominio = 'rttv.ru';
	$dominio = 'test-228.reseller2.iplan.com.ar';
	$dominio = 'bdpinternational.com.ar';
	$dominio = 'laharrague.com';
	$dominio = 'segasa.com.ar';
	$dominio = 'humanagency.com.ar';
	$dominio = 'laharrague.com';
	$dominio = 'estudiocorach.com';
	$dominio = 'segasa.com.ar';
	$dominio = 'asimex.com.ar';
	$dominio = 'arlog.org';
	$dominio = 'savagliostudio.com';
	$dominio = 'laharrague.com';
	$dominio = 'chaloupka.com.ar';
	$dominio = 'lezamapc.com.ar';
	$dominio = 'epcm.com.ar';
	$dominio = 'geo.org.ar';
	$dominio = 'finvesa.com.ar';
	$dominio = 'chaloupka.com.ar';
	$dominio = 'lezamapc.com.ar';
	$dominio = 'nelljoy.com.ar';
	$dominio = 'welcomeabroad.com.ar';
	$dominio = 'liasacomex.com.ar';
	$dominio = 'lezamapc.com.ar';
	$dominio = 'chaloupka.com.ar';
	$dominio = 'escribaniaperagallo.com.ar';
	$dominio = 'vksur.com';
	$dominio = 'dglogistics.com.ar';
	$dominio = 'stoplossbureau.com.ar';//SUSPENDIDO
	$dominio = 'epcm.com.ar';
	$dominio = 'lezamapc.com.ar';
	$dominio = 'chaloupka.com.ar';
	$dominio = 'test-221.reseller2.iplan.com.ar';
	$dominio = 'gycsis.com.ar';
	$dominio = 'construccionessm.com.ar';
	$dominio = 'test-100.reseller2.iplan.com.ar';
	$dominio = 'test-110.reseller2.iplan.com.ar';
	$dominio = 'welcomeabroad.com.ar';
	$dominio = 'cdegraf.com';
	$dominio = 'pabloluna.com.ar';
	$dominio = 'cmartin.com';
	$dominio = 'mlaiseca.com.ar';
	$dominio = 'pluna.net.ar';
	$dominio = 'iplano.com.ar';
	$dominio = 'hekrilafs.com.ar';
	$dominio = 'mcabrera.com.ar';
	$dominio = 'lekons.com.ar';
	$dominio = 'cobsin.com.ar';
	$dominio = 'test-111.reseller2.iplan.com.ar';
	$dominio = 'q-group.com.ar';
	$dominio = 'sramascopadilla.com.ar';
	$dominio = 'lekons.com.ar';
	$dominio = 'senatgroup.com';
	$dominio = 'lekons.com.ar';
	$dominio = 'counsellors-ar.com.ar';
	$dominio = 'monticonsultores.com.ar';
	$dominio = 'tabar.com.ar';
	$dominio = 'fbmcomex.com.ar';
	$dominio = 'counsellors-ar.com.ar';
	$dominio = 'monticonsultores.com.ar';
	$dominio = 'tabar.com.ar';
	$dominio = 'fbmcomex.com.ar';
	$dominio = 'agresbaluk.com.ar';
	$dominio = 'reunionre.com.ar';
	$dominio = 'coordinar.com.ar';
	$dominio = 'holanbar.com.ar';
	$dominio = 'adisfarm.com.ar';
	$dominio = 'estudiohourcade.com.ar';
	$dominio = 'pailebote.com.ar';
	$dominio = 'renalife.com';
	$dominio = 'creativevisual.com.ar';
	$dominio = 'acuarioeventos.com';
	$dominio = 'iorfida-jodor.com.ar';
	$dominio = 'adisfarm.com.ar';
	$dominio = 'dencar.com.ar';
	$dominio = '18dejunio.com.ar';
	$dominio = 'pailebote.com.ar';
	$dominio = 'dominiozassnet.com';
	$dominio = 'fullcarga.com.ar';
	$dominio = 'a-cuadrado.com.ar';
	$dominio = 'zassnet.com';
	$dominio = 'fullcarga.com.ar';
	$dominio = 'finvesa.com.ar';
	$dominio = 'liasacomex.com.ar';
	$dominio = 'estudiomartincastro.com.ar';
	$dominio = 'estudiocorach.com';
	$dominio = 'welcomeabroad.com.ar';
	$dominio = 'estudiomartincastro.com.ar';
	$dominio = 'estudiogmyasoc.com.ar';
	$dominio = 'lorentrade.com.ar';
	$dominio = 'zassnet.com';
	$dominio = 'a-cuadrado.com.ar';
	$dominio = 'laharrague.com';
	$dominio = 'nexoaduana.com.ar';
	$dominio = 'liasacomex.com.ar';
	
	//Pruebas de portal que mandaron sin aviso a producción
	$dominio = 'googleappsparatesteo.com.ar';
	$dominio = 'testeodegapps.com.ar';
	$dominio = 'googleappstesteo2.com.ar';
	$dominio = 'googleappsparatesteo1.com.ar';
	$dominio = 'gappstesteo.com.ar';
	$dominio = 'testcloud1122.com.ar';
	//Fin pruebas
	
	$dominio = 'abogado.org.ar';
	$dominio = 'institutodelcarmen.edu.ar';
	$dominio = 'ppvsatelital.com.ar';
	
	//Verificación de dominios de prueba que Pablo Luna no borró
	$dominio = 'test16.iplan.com.ar';
	$dominio = 'test4.iplan.com.ar';
	$dominio = 'test8.iplan.com.ar';
	$dominio = 'bristolpark.com.ar';
	$dominio = 'aecrosario.org.ar';
	
	$dominio = 'milicic.com.ar';
	$dominio = 'fibrafil.com';
	$dominio = 'consularsa.com.ar';
	$dominio = 'acopiadores.com';
	$dominio = 'freiberg.com.ar';
	$dominio = 'hplion.com.ar';
	$dominio = 'ppvsatelital.com.ar';
	$dominio = 'uoma.org.ar';
	$dominio = 'exportar.org.ar';
	$dominio = 'acopiadores.com';
	$dominio = 'promielsrl.com.ar';
	$dominio = 'consularsa.com.ar';
	
	//Modificaciones a cuentas StandardPlus SS#112622
	$dominio = 'admifarmgroup.com';
	$dominio = 'fnb.com.ar';
	//Fin Modificaciones SS#112622
	
	$dominio = 'estudiomaschwitz.com.ar';
	
	
	// Conflicto de alias
	$dominio = 'puentehnos.com.ar';
	$dominio = 'puentenet.com';
	$dominio = 'phnos.com.ar';
	
	$dominio = 'lubrisider.com.ar';
	$dominio = 'puentehnos.com.ar';
	$dominio = 'fnb.com.ar';
	$dominio = 'gama-sa.com';
	$dominio = 'delfos.tur.ar';
*/
	
	$dominio = 'test-110.reseller2.iplan.com.ar';
//	$dominio = 'acopiadores.com';
	$dominio = 'testjpc00001.com.ar';
	$dominio = 'iplan.com.ar';
	$dominio = 'ergorenova.com.ar';
//	$api->setDebug(true);
	$estado = $api->validateClientDomain($dominio);
	$verificado = $api->verifyDomain($dominio);
	$cantidadDeUsuariosActivos = $api->countDomainUsers($dominio);
	$cantidadMaximaDeUsuarios  = $api->getMaxNumberOfLicences($dominio);
	echo "Estado del dominio: $estado [Resultado de verificación: ".($verificado?'Verificado':'No Verificado')."]\n";
	echo "Cantidad de usuarios del dominio $dominio:\t$cantidadDeUsuariosActivos de $cantidadMaximaDeUsuarios\n";
	$api->setDebug(true);
//	$api->downgradeAccount($dominio);
//	$api->createCustomerDomain($dominio, 10, 'AR');
//	$api->setDebug(true);
//	$api->setMaxNumberOfLicences($dominio, 615);

	//$api->setMaxNumberOfLicences($dominio, 350);
	
	/*$api->setDebug(true);
	$api->createCustomerDomain($dominio, 5, 'AR');
	$api->createDomainUser($dominio, 'admin', '123456asdfg', 'Administrador', 'Sitio', true);*/
	//$api->setMaxNumberOfLicences($dominio, 10);//nexoaduana.com.ar
	//$api->setMaxNumberOfLicences($dominio, 10);//18dejunio.com.ar
	//$api->setMaxNumberOfLicences($dominio, 20);//pailebote.com.ar
	//$api->setMaxNumberOfLicences($dominio, 60);//zassnet.com
	//$api->setMaxNumberOfLicences($dominio, 70);//zassnet.com
	//$api->setMaxNumberOfLicences($dominio, 20);//a-cuadrado.com.ar
//	echo "\nPassword admin: ".substr(sha1($dominio), 10, 8)."\n";
	//$api->setDebug(true);
	//$api->upgradeStandardToPremium($dominio, 50, 'AR', '36B172C9B88807CD');//lekons.com.ar
	//$api->upgradeStandardToPremium($dominio, 50, 'AR', 'BBD1FD8C6482F24B');//lekons.com.ar

	//Mails
	//Caso que haya mas cuentas free en un dominio existente, que las premium contratadas
/*	
	
	$mailBody = '<p>Hemos  detectado que ya dispones de cuentas en Google y la cantidad a transferir es  mayor a la que contrataste en IPLAN. Para resolver esto, puedes contratar m&aacute;s  cuentas en IPLAN o dar de baja las cuentas que no desees en Google.</p>
Te sugerimos que  corrijas esta situaci&oacute;n. En breve se pondr&aacute; en contacto con vos un representante  para regularizar esta situaci&oacute;n.
<p>Cordialmente,<br>';
	$mailBody = '<p>Queremos  informarte que tu dominio <span style="color:#ff2352;font-weight:bold">'.$dominio.'</span>  ya esta creado en Google y se encuentra bajo la administración de otro  reseller. </p>
<p>Para  dar de alta el servicio de correo <span style="font-weight: bold;">Google  Apps</span> en IPLAN, es necesario que gestiones un código de validaci&oacute;n  denominado "Transfer Token" en Google y lo cargues en nuestra plataforma de  administración del servicio. 
El  mismo tenés que generarlo en Google como se informa en el siguiente link: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=33321" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>33321</a> </p>
<p>Una  vez que dispongas de dicho código, tenés que cargarlo en nuestra plataforma  como se indica <a href="http://iplan.com.ar/wps/wcm/connect/1837f132-2771-45cc-b095-2831d6fec3c3/Google_Apps_-_Instructivo_-_carga_-_Transfer-Token.pdf?MOD=AJPERES" target="_blank">aquí</a>. </p>
<p>Dispones  de 5 días para realizar esta gestión. Superado dicho plazo se vencerá el código  obtenido y tendrás que volver a obtener el mismo en Google.</p>
<p>¡Esperamos  que completes estos pasos con éxito para avanzar con el alta del servicio!</p>
<p>Cordialmente,</p><br>';
	$mailBody = '<p>Queremos  recodarte que el servicio de correo <span style="font-weight: bold;">Google Apps</span> para el dominio <span style="color:#ff2352;font-weight:bold">'.$dominio.'</span> aún no ha sido dado de alta dado que  no generaste el código "transfer token", o lo obtuviste y no lo cargaste en  nuestra plataforma.</p>
<p>Google requiere que gestiones un código de validación denominado "Transfer Token" y lo  cargues en nuestra plataforma de administración del servicio cuando el dominio se encuentra creado en sus servidores bajo otro reseller. 
El  mismo tenés que generarlo en Google como se informa en el siguiente link: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=33321" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>33321</a> <br>
<br>
Una  vez que dispongas de dicho código, tenés que cargarlo en nuestra plataforma  como se indica <a href="http://iplan.com.ar/wps/wcm/connect/1837f132-2771-45cc-b095-2831d6fec3c3/Google_Apps_-_Instructivo_-_carga_-_Transfer-Token.pdf?MOD=AJPERES" target="_blank">aquí</a>. <br>
<br>
Dispones  de 5 días para realizar esta gestión. Superado dicho plazo se vencerá el código  obtenido y tendrás que volver a obtener el mismo en Google.</p>
¡Esperamos que completes  estos pasos con éxito para avanzar con el alta del servicio!
<p>Cordialmente,</p><br>';
	$mailBody = '<p>Hemos detectado que el código de validación "Transfer Token" que ingresaste no es  correcto. Por  favor, te solicitamos que generes un nuevo código y lo cargues nuevamente en  nuestra plataforma de administración del servicio. 
El  mismo tenés que generarlo en Google como se informa en el siguiente link: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=33321" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>33321</a> <br><br>
Una  vez que dispongas de dicho código, tenés que cargarlo en nuestra plataforma  como se indica <a href="http://iplan.com.ar/wps/wcm/connect/1837f132-2771-45cc-b095-2831d6fec3c3/Google_Apps_-_Instructivo_-_carga_-_Transfer-Token.pdf?MOD=AJPERES" target="_blank">aquí</a>. <br><br>
Dispones  de 5 días para realizar esta gestión. Superado dicho plazo se vencerá el código  obtenido y tendrás que volver a obtener el mismo en Google.</p>
¡Esperamos que completes  estos pasos con éxito para avanzar con el alta del servicio!
<p>Cordialmente,</p><br>';
	$mailBody = '<p>Te  recordamos que hemos finalizado el proceso de activación del servicio de correo<strong> Google Apps</strong> para el dominio <span style="color:#ff2352;font-weight:bold">'.$dominio.'</span> en IPLAN. </p>
<p>Aún  no has creado el registro "txt" que Google requiere para validar que la  solicitud de alta en sus servidores sea legítima del dueño del dominio. En caso  de no hacerlo dentro de los próximos <span style="color:#ff2352;font-weight:bold">'.($dias=21).'</span> días,  Google dará de baja todas las configuraciones del dominio en sus servidores,  sin excepción. 
  Te  brindamos un link donde podrás encontrar mayor información sobre este proceso: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=60216&amp;topic=29597&amp;ctx=topic" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>60216&amp;topic=29597&amp;ctx=topic</a> </p>
<p>En  caso que necesites soporte para crear el registro "txt" (verificación de  dominio), a continuación te brindamos un link donde encontrarás la explicación  sobre cómo realizarlo: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=2716802" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>2716802</a> </p>
<p>Una  vez que dispongas de dicho registro tenés que cargar el mismo en tu DNS. Si  IPLAN es quien administra el DNS del dominio, tendrás que cargarlo en nuestra  plataforma como se indica <a href="http://iplan.com.ar/wps/wcm/connect/24e73ee1-b0ff-4294-bf6a-724f84a23ce8/Google_Apps_-_Instructivo_-_Carga_-_txt.pdf?MOD=AJPERES" target="_blank">aquí</a>. </p>
<p>Luego  de configurar éste registro, Google puede demorar hasta 48 horas en finalizar  la validación. </p>
Una vez que configures  dicho registro te sugerimos que tengas a tu disposición el mail de activación (el cual te enviamos con anterioridad), dado que es necesario que continúes con  los pasos informados en el mismo.
<p>Cordialmente,<br>';
	$mailBody = '<p>Te  confirmamos que Google ha eliminado el dominio <span style="color:#ff2352;font-weight:bold">'.$dominio.'</span>  de sus servidores, dado que no has creado los registros necesarios para validar  que la solicitud de alta sea legítima del dueño del dominio. </p>
<p>IPLAN  cargó nuevamente el dominio en la plataforma de <strong>Google Apps</strong>, por lo cual de no hacerlo dentro de los próximos <span style="color:#ff2352;font-weight:bold">21</span> días, Google dará de baja todas las  configuraciones del dominio en sus servidores, sin excepción. 
  Te  brindamos un link donde podrás encontrar mayor información sobre este proceso: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=60216&amp;topic=29597&amp;ctx=topic" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>60216&amp;topic=29597&amp;ctx=topic</a> </p>
<p>En  caso que necesites soporte para crear el registro "txt" (verificación de  dominio), a continuación te brindamos un link donde encontrarás la explicación  sobre cómo realizarlo: <a href="http://support.google.com/a/bin/answer.py?hl=es&amp;answer=2716802" target="_blank">http://support.google.com/a/<WBR>bin/answer.py?hl=es&amp;answer=<WBR>2716802</a> </p>
<p>Una  vez que dispongas de dicho registro tenés que cargar el mismo en tu DNS. Si  IPLAN es quien administra el DNS del dominio, tendrás que cargar el mismo en  nuestra plataforma como se indica <a href="http://iplan.com.ar/wps/wcm/connect/24e73ee1-b0ff-4294-bf6a-724f84a23ce8/Google_Apps_-_Instructivo_-_Carga_-_txt.pdf?MOD=AJPERES" target="_blank">aquí</a>. </p>
<p>Luego  de configurar éste registro, Google puede demorar hasta 48 horas en finalizar  la validación. </p>
<p>Una  vez que configures dicho registro te sugerimos que tengas a tu disposición el  mail de activación, el cual te enviamos con anterioridad, dado que es necesario  que continúes con los pasos informados en el mismo.</p>
<p>Cordialmente,<br>';
	//echo $this->sendMail('chabon_loco@yahoo.com.ar', 'JAV', 'Jorge', 'Google Apps - Eliminacion de Dominio por falta de validacion', $mailBody);
*/	
//  $api->downgradeAccount($dominio);
//	$api->setMaxNumberOfLicences($dominio, 15);
	
//	$api->upgradeStandardToPremium($dominio, 10, 'AR', '95004911D29717F0');
//	$api->upgradeStandardToPremium($dominio, 10, 'AR', '4C1C3187E78EC81E');
//	$api->upgradeStandardToPremium($dominio, 10, 'AR', 'CEF515F42592A7A7');
//	$api->upgradeStandardToPremium($dominio, 5, 'AR', '1865877D737A5BA9');//gycsis.com.ar
//	$api->upgradeStandardToPremium($dominio, 50, 'AR', '2BFA020D96B4D08C');//lekons.com.ar
//	$api->upgradeStandardToPremium($dominio, 50, 'AR', '6EE2C1B9FA458AD4');//lekons.com.ar
//	$api->upgradeStandardToPremium($dominio, 50, 'AR', 'ABFD1A237DA7E878');//lekons.com.ar
//	$api->upgradeStandardToPremium($dominio, 50, 'US', '457CFDE68E8BE143');//lekons.com.ar
//	$api->upgradeStandardToPremium($dominio, 15, 'AR', '8482E441F6F0B0E4');//test-111.reseller2.iplan.com.ar
//	$api->downgradeAccount($dominio);//test-111.reseller2.iplan.com.ar
	
	
	
	/*$api->downgradeAccount('test-220.reseller2.iplan.com.ar');
	echo "Borrado 'test-220.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-221.reseller2.iplan.com.ar');
	echo "Borrado 'test-221.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-222.reseller2.iplan.com.ar');
	echo "Borrado 'test-222.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-223.reseller2.iplan.com.ar');
	echo "Borrado 'test-223.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-224.reseller2.iplan.com.ar');
	echo "Borrado 'test-224.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-225.reseller2.iplan.com.ar');
	echo "Borrado 'test-225.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-226.reseller2.iplan.com.ar');
	echo "Borrado 'test-226.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-227.reseller2.iplan.com.ar');
	echo "Borrado 'test-227.reseller2.iplan.com.ar'\n";
	$api->downgradeAccount('test-228.reseller2.iplan.com.ar');
	echo "Borrado 'test-228.reseller2.iplan.com.ar'\n";*/

/*	
	echo "\n\nListando dominios\n=================\n";
	$domains = $api->listDomains();
	for($i=0;$i<count($domains);$i++) {
		$info = $api->getDomainInfo($domains[$i]);
		echo $domains[$i]."\t".$info['edition']."\t".$info['country']."\t".$info['created']."\t".$info['licences']."\t".$info['used']."\n";

	}
*/

/*
	$userList=$api->listDomainUsers($dominio);
	if (is_array($userList)) {
		foreach($userList as $user) {
			echo $dominio."\t".$user['username']."\t".($user['admin']?'Admin':'User')."\t".$user['surname']."\t".$user['name']."\t".($user['suspended']?'Suspendida':'Activa')."\t". $user['quota'] ."\n";
		}
	}
*/	
/*	$domains = $api->listDomains();
	for($i=0;$i<count($domains);$i++) {
		$userList=$api->listDomainUsers($domains[$i]);
		if (is_array($userList)) {
			foreach($userList as $user) {
				echo $domains[$i]."\t".$user['username']."\t".($user['admin']?'Admin':'User')."\t".$user['surname']."\t".$user['name']."\t".($user['suspended']?'Suspendida':'Activa')."\t". $user['quota'] ."\n";
			}
		}
	}
*/
	//$api->setDebug(true);
	//$api->listDomainUsers('acsyslatam.com');
	
	
	
/*	$log = LogMessages::GetInstance($orm->getDatabase()->getConnection(), $context->getUser()->getId(), LogMessages::SYS_CAGA);
	$log->getMensajes();
	
	$serviceOrder = $orm->load('ServiceOrder', 	3585319);
	$lastCall = $api->getLastCall();
	$contents = $lastCall['request'];
	$this->saveFileLog($log, $serviceOrder, $contents, 2, 27);*/
	
  /*
	$api->setMaxNumberOfLicences($dominio, 90);
	
	$cantidadDeUsuariosActivos = $api->countDomainUsers($dominio);
	$cantidadMaximaDeUsuarios  = $api->getMaxNumberOfLicences($dominio);
	echo "Estado del dominio: $estado [Resultado de verificación: ".($verificado?'Verificado':'No Verificado')."]\n";
	echo "Cantidad de usuarios del dominio $dominio:\t$cantidadDeUsuariosActivos de $cantidadMaximaDeUsuarios\n";
	*/

	//$ok = $api->setMaxNumberOfLicences($dominio, 11);
	//echo ($ok ? "Downgrade exitoso\n":"Downgrade Fallido - Error ".$api->getLastErrorCode().": ".$api->getLastError()."\n");
	//$api->downgradeAccount($dominio);

	//$ok = $api->downgradeAccount($dominio);

/*
    $domains = $api->listDomains();
	for($i=0;$i<count($domains);$i++) {
		echo $domains[$i]."\n";
	}
*/
	return true;
    // Bouml preserved body end 001C3685
  }

  /**
   * @return PHPMailer
   */
  public function prepareMail($name, $surname, $clientName, $body)
  {
    // Bouml preserved body begin 001C1A85
	
    // Bouml preserved body end 001C1A85
  }

  /**
   * @return PHPMailer
   */
  public function sendMail($to, $client, $contact, $title, $body)
  {
    // Bouml preserved body begin 001B9385
	$meses = array(1=>'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
	$date = getdate();
	$mail = new PHPMailer();
	$mail->IsSMTP();
	$mail->IsHTML();
	$mail->Host = 'smtpinterno.iplan.com.ar';
	$mail->From = 'noreply@iplan.com.ar';
	$mail->FromName = 'Servicios IPLAN';
//	$mail->AddAddress('pruebasprovisioning@iplan.com.ar');//TODO pasar a $to para producción
	$mail->AddAddress($to);//TODO $to para producción
//	$mail->AddBCC('pruebasprovisioning@iplan.com.ar');
	$mail->Subject = $title;
	$mail->AddEmbeddedImage('templates/default/images/news-logo-iplan.jpg', 'logo-iplan');	
	$mail->Body = str_replace(array('á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'í', 'Ó', 'Ú', 'ñ', 'Ñ', '¡'), 
							  array('&aacute;', '&eacute;', '&iacute;', '&oacute;', '&uacute;', '&Aacute;', '&Eacute;', '&Iacute;', '&Oacute;', '&Uacute;', '&ntilde;', '&Ntilde;', '&iexcl;'), 
'<div  style="color: #333333;font-family: Arial,Helvetica,sans-serif;font-size: 1em;border: #000 .1em solid;padding:.5em;">
	<div style="">
		<div style="float:left;"><img src="cid:logo-iplan"/></div>
		<div style="float:right;"><a href="http:://iplan.com.ar" style="color:#ff2352;font-size:12px;font-weight:bold" target="_blank">Acerca de IPLAN</a></div>
		<div style="height:2.5em;">&nbsp;</div>
	</div>
	<div>
		<div style="border-top-style: solid; border-top-width: .1em;border-top-color: #c1c1c1; text-align: right;padding-top: 1em;"><strong>Buenos Aires, '.$meses[$date['mon']].' de '.$date['year'].'</strong></div>
		
		<p>'.$client.':</p>'.
			$body.
'		<p style="font-size: .85em;">
			<span style="font-weight: bold;">ATENCI&Oacute;N AL CLIENTE</span><br/>
		<span style="color:#ff2352;font-weight:bold">IPLAN</span> | <a href="http://iplan.com.ar">iplan.com.ar</a><br/>
        <p style="font-size:12px;color:#666666">Este es un mensaje generado autom&aacute;ticamente, por lo tanto no debe ser  respondido.</p>
		</p>
		<div style="border-top-style: solid; border-top-width: .1em;border-top-color: #c1c1c1; text-align: center;padding-top: 1em;font-size: .75em;">
			PARA REALIZAR RECLAMOS T&Eacute;CNICOS O ADMINISTRATIVOS, POR FAVOR INGRESE EN <a href="http://iplan.com.ar">iplan.com.ar</a> CON SU USUARIO
			(C&Oacute;DIGO DE GESTI&Oacute;N PERSONAL) Y CONTRASE&Ntilde;A
		</div>
	</div>
</div>');

	return $mail->Send();	
    // Bouml preserved body end 001B9385
  }

  /**
   * Notifica al facade que se ha logeado un usuario NUEVO mediante "Login Unificado".
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * @param User $user el usuario nuevo que se logueó
   * @param mixed $extra por el momento se pasa la respuesta del llamado a CLL_Authenticate.
   * 
   * @return boolean un booleando que es TRUE si se desea conservar el usuario o FALSE si el mismo es irrelevante o no debe tener permisos para el Facade.
   */
  public function newLoginUnificado(&$context, &$user, $extra = null)
  {
    // Bouml preserved body begin 001E3C05
	$orm = $this->application->getORM();
	$cgp = $user->getUsername();
	$clientNumber = $context->getManager('Application')->cgpToClient($cgp);
	$existClient = $orm->query('Client')
					   ->filterBy('clientNumber', '=', $clientNumber)
					   ->findOne();
	if ($existClient) {
		$hasAccounts = $orm->query('GoogleAccount')
						   ->filterBy('client.id', '=', $existClient->getId())
						   ->findOne();
		if ($hasAccounts) {
			$user->addProfile($orm->query('Profile')
								  ->filterBy('name', '=', 'Cliente GoogleApps')
								  ->filterBy('provider.id', '=', $context->getProvider()->getId())
								  ->findOne()
							 );
			return true;
		} else return false;
	} else return false;
    // Bouml preserved body end 001E3C05
  }

  /**
   * Lista las cuentas de mail asociadas a un dominio.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listDomainUsers(&$context, $ajax)
  {
    // Bouml preserved body begin 001ECB85
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Cuenta', 'username'))
			->addColumn(new Column('Tipo', 'admin', false, '{{ admin ? "Administrador" : "Usuario" }}'))
			->addColumn(new Column('Nombre', 'name'))
			->addColumn(new Column('Apellido', 'surname'))
			->addColumn(new Column('Estado', 'suspended', false, '{{ suspended ? "Suspendida" : "Activa"}}'))
			->addColumn(new Column('Espacio', 'quota'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'GoogleApps.changeUserPassword', array('domain', 'username'))
			)))
			->setPageRows(50)
			->setListFunction(function (GoogleAppsProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$isClient = $orm->query('Profile')->filterBy('provider.id', '=', $context->getProvider()->getId())
									   ->filterBy('name', '=', 'Cliente GoogleApps')
									   ->filterBy('users.id', '=', $context->getUser()->getId())
									   ->findOne();
							$domain = $context->getParam('domain');
							$show = true;
							if ($isClient) {
								$show =  $orm->query('GoogleAccount')
											 ->filterBy('domain', '=', $domain)
											 ->filterBy('provider.id', '=', $context->getProvider()->getId())
											 ->filterBy('client.user.id', '=', $context->getUser()->getId())
											 ->findOne();
							}
							
							if ($show) {
								$api = new APIGoogleApps();
								try {
									$loginOK = $api->registerInGoogleApps('admin@reseller2.iplan.com.ar', 'ty45v5234');
								} catch(Exception $e) {
									echo 'Fallo inesperado al autenticar: espere unos minutos e inténtelo de nuevo';
									return false;
								}

								$userList=$api->listDomainUsers($domain);
								$oWebList->setRowCount(count($userList));
								if (is_array($userList)) {
									$userList = array_slice($userList, $from_row-1, ($to_row-$from_row)+1);
									for($i=0;$i<count($userList);$i++)
										$userList[$i]['domain']=$domain;
								} else $userList = false;
							} else {
								$webList->setEmptyMessage("Usted no tiene permisos para ver esta información");
								$userList = false;
							}
							return $userList;
					  })
			;
	$layout = new GridLayout(1, 4);
	$layout->addComponent(new TextComponent(array('label'=>'Dominio','name'=> 'domain','maps'=> 'domain', 'size'=>30)), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setAction('GoogleApps.listDomainUsers');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001ECB85
  }

  /**
   * Permite hacer el alta, baja o modificación de un estado de transacción de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmUserPassword(&$context, $ajax)
  {
    // Bouml preserved body begin 001ECC05
	$orm = $this->application->getORM();
	$form = new GoogleChangeUserPasswordForm();
	return $form->deploy($context);
    // Bouml preserved body end 001ECC05
  }

  /**
   * Redirige al sitio de administración de Google del dominio indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function goToDomainAdminPanel(&$context, $ajax)
  {
    // Bouml preserved body begin 001EE785
	$orm = $this->application->getORM();
	$domain = $context->getParam('domain');
	if ($domain) {
		header("Location: http://google.com/a/$domain/");
		exit(0);
	} else {
		$renderable = new Renderable('lib/success.xhtml');
		$errors['title']='No se ha especificado el dominio';
        $errors['messages']['descriptions']='No se ha pasado el dominio de referencia.';
        $context->set('errors', $errors);		
	}
	return $renderable;
    // Bouml preserved body end 001EE785
  }

  /**
   * Redirige al sitio de administración de Google del dominio indicado
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function changeUserPassword(&$context, $ajax)
  {
    // Bouml preserved body begin 001EE805
   $orm = $this->application->getORM();
   $renderable = new Renderable('lib/success.xhtml');
   $username = $context->getParam('username');
   $domain   = $context->getParam('domain');
   $pass1    = $context->getParam('newPass');
   $pass2    = $context->getParam('newPass2');

   $isClient = $orm->query('Profile')
                ->filterBy('provider.id', '=', $context->getProvider()->getId())
                ->filterBy('name', '=', 'Cliente GoogleApps')
                ->filterBy('users.id', '=', $context->getUser()->getId())
                ->findOne();
   $show = true;
   if ($isClient) {
      $show =  $orm->query('GoogleAccount')
                ->filterBy('domain', '=', $domain)
                ->filterBy('provider.id', '=', $context->getProvider()->getId())
                ->filterBy('client.user.id', '=', $context->getUser()->getId())
                ->findOne();
   }
   if ($show) {
      $api = new APIGoogleApps();
      try {
         $loginOK = $api->registerInGoogleApps('admin@reseller2.iplan.com.ar', 'ty45v5234');
         $api->changeUserPassword($domain, $username, sha1($password));
      } catch(Exception $e) {
         $errors['title']='Problemas al acceder a la plataforma de Google Apps';
         $errors['messages']['descriptions']='No se puede realizar la operación en este momento, inténtelo de nuevo más tarde y si reincide comuníquese con el proveedor del servicio';
         $context->set('errors', $errors);
      }
   } else {
      $errors['title']='No se puede procesar la petición';
      $errors['messages']['descriptions']='El dominio que intenta modificar no está registrado como propio';
      $context->set('errors', $errors);
   }
   return $renderable;
    // Bouml preserved body end 001EE805
  }

  /**
   * Lista los tipos de transacciones que admite la plataforma de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listResellerReports(&$context, $ajax)
  {
    // Bouml preserved body begin 001F1C85
	
    // Bouml preserved body end 001F1C85
  }

  /**
   * Lista los tipos de transacciones que admite la plataforma de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function generateResellerReport(&$context, $ajax)
  {
    // Bouml preserved body begin 001F1D05
	
    // Bouml preserved body end 001F1D05
  }

  /**
   * Lista los tipos de transacciones que admite la plataforma de autoprovisioning de GoogleApps
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function changeTransactionInterval(&$context, $ajax)
  {
    // Bouml preserved body begin 001F3705
	$orm = $this->application->getORM();
	$form = new GoogleTransactionIntervalForm($orm, $context);
	return $form->deploy($context, $orm);
    // Bouml preserved body end 001F3705
  }

}
?>