<?php
function ValidaDominio($dominio,$error)
{
$expr   = '/^(([a-z0-9]([-a-z0-9]*[a-z0-9]+)?){1,63}\.)+[a-z]{2,6}/i';
$ISO_3166_1 = array( "AF", "ZA", "AX", "AL", "DZ", "DE", "AD", "AO", "AI", "AQ", "AG", "SA", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", 
                     "BZ", "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "BN", "BG", "BF", "BI", "KY", "KH", "CM", "CA", "CV", "CF", "CL", "CN", "CX", "CY", 
                     "CC", "CO", "KM", "CG", "CD", "CK", "KR", "KP", "CR", "CI", "HR", "CU", "CW", "DK", "DJ", "DO", "DM", "EG", "SV", "AE", "EC", "ER", "ES", "EE", 
                     "US", "ET", "FK", "FO", "FJ", "FI", "FR", "GA", "GM", "GE", "GS", "GH", "GI", "GR", "GD", "GL", "GP", "GU", "GT", "GG", "GN", "GW", "GQ", "GY", 
		     "GF", "HT", "HM", "HN", "HK", "HU", "IM", "UM", "VG", "VI", "IN", "ID", "IR", "IQ", "IE", "IS", "IL", "IT", "JM", "JP", "JE", "JO", "KZ", "KE",
                     "KG", "KI", "KW", "LA", "LS", "LV", "LB", "LR", "LY", "LI", "LT", "LU", "LU", "MO", "MK", "MG", "MY", "MW", "MV", "ML", "MT", "MP", "MA", "MH", 
                     "MQ", "MU", "MR", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MZ", "MM", "NA", "NR", "NP", "NI", "NE", "NG", "NU", "NF", "NO", "NC", "NZ",
                     "IO", "OM", "UG", "UZ", "PK", "PW", "PS", "PA", "PG", "PY", "NL", "PE", "PH", "PN", "PL", "PF", "PR", "PT", "QA", "RE", "RO", "GB", "RU", "RW",
                     "EH", "BL", "SH", "LC", "KN", "SM", "MF", "SX", "PM", "VA", "VC", "SB", "WS", "AS", "ST", "SN", "RS", "SC", "SL", "SG", "SK", "SI", "SO", "SD",
                     "LK", "SE", "CH", "SR", "SJ", "SZ", "SY", "TJ", "TW", "TZ", "TD", "CZ", "TF", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TM", "TC", "TR", "TV",
                     "UA", "UY", "VU", "VE", "VN", "WF", "YE", "ZM", "ZW");

	list($dom,$gtld,$cctld) = explode(".",$dominio);

 

	if(!preg_match($expr,strtolower($dominio))) {$error = "El dominio '$dominio' contiene caracteres invados"; return false;}

	if(strlen($dom) > 63) return false ; //Superaa el numero max de caracteres para el dominio

	if(
		strcasecmp($gtld,"GOV") != 0 &&
		strcasecmp($gtld,"EDU") != 0 &&
		strcasecmp($gtld,"COM") != 0 &&
		strcasecmp($gtld,"MIL") != 0 &&
		strcasecmp($gtld,"ORG") != 0 &&
		strcasecmp($gtld,"NET") != 0 &&
		strcasecmp($gtld,"INT") != 0
	  )	{ $error = "El dominio '$dominio' tiene un tld [$gtld] invalido "; return false;}

	if(!is_null($cctld) && !array_search(strtoupper($cctld),$ISO_3166_1)) {$error = "El dominio '$dom.$gtld.$cctld' tiene un cctld [$cctld] que no esta contemplado en la ISO 3166-1"; return false;}

	return true;
}




?>
