<?php
include_once("/www/ws.iplantech.com.ar/webservice/interfaceElServer/IntElServer.php");
include_once("../validaciones/ValidaDominio.php");

function consultarDominio($dominio)
{
	$obj = new stdClass();

	if(ValidaDominio($dominio,&$error))
	{
		$elserver = new IntElServer();
		if ($elserver->IniciarSesion())
		{
			if($xml = $elserver->ConsultaWhoIs($dominio))
			{
				if($xml->{"data"}->{"available"} == 1)
				{
					$obj->Salida = 0;
					$obj->Descripcion = $dominio." disponible";
				}
				else
				{
					$obj->Salida = 2;
					$obj->Descripcion = $dominio." en uso";
	
				}
			}
			else
			{
				$error = $elserver->getError();
				$obj->Salida = 3;
				$obj->Descripcion = $error["tipo"].": ".$error["mensaje"];
			}
		
		}
		else
		{
			$error = $elserver->getError();
			$obj->Salida = 3;
			$obj->Descripcion = $error["tipo"].": ".$error["mensaje"];
		}
	}
	else
	{
		$obj->Salida = 3;
		$obj->Descripcion = $error;

	}

	return $obj;

}




$server = new SoapServer('IPLWSConsultaDominio.wsdl', array('soap_version' => SOAP_1_1));
$server->addFunction(array('consultarDominio'));
$server->handle(); 



?>
