<?php



/**
* Author: Miguel Angel Ponce
* 
*/
include_once("constantes.php");
class IntElServer {
  /**
   * @var string Despus de iniciar sesin, se obtiene el access token que sirve para realizar el resto de las operaciones contra El Server
   */
  private $access_token;

  /**
   * @var string Si al realizar alguna operacin se produce un error, se setea este atributo con una descripcin del error.
   */
  private $error;

  private $rawRequest;

  private $rawResponse;

  /**
   * @var string Aca se arma la url que se le pasa a curl para hacer la consulta al api de El Server.
   */
  private $url;

  /**
   * Hace la consulta de disponibilidad de un dominio
   * 
   * @param string $dominio un nombre de dominio vlido
   * 
   * @return stdClass - O "false" en el caso que la consulta al api de algn error
   */
  public function TonsultaWhoIs($dominio)
  {
    // Bouml preserved body begin 00020D82
        $this->url = "GET /domain/whois/?access_token=".$this->access_token."&domain=".$dominio." HTTP/1.1 \r\n";
        $rta = json_decode($this->EjecutarConsulta());

        if(isset($rta->{'data'}))
        {
            $this->error = array("tipo" =>  "Info","mensaje" => "Consulta WhoIS realisada con exito");
            return $rta;
        }
        elseif(isset($rta->{'error'}))
        {
            $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
            return false;
        }
        else
        {
            $this->error = array("tipo" => "Inesperado", "mensaje" => "No se pudo acceder al api de El Server");
            return false;
        }
    // Bouml preserved body end 00020D82
  }

  public function ConsultaWhoIs($domcons)
  {
       $respuesta;
    $url = "www.nic.ar/consdom.html";
    $nombre = substr($domcons,0,strpos($domcons,"."));
    $dominio = substr($domcons,strpos($domcons,"."));
    //echo "nombre:$nombre\n";
    //echo "dominio:$dominio\n";


    if($dominio != ".com.ar"){
        $rta = shell_exec("whois ".$nombre.$dominio);
        $cadena = "No match for \"".$nombre.$dominio."\"";
        $disponible = "Domain Name: ".$nombre.$dominio;
        if(stristr($rta,$cadena) != false){
        //    echo $nombre.$dominio." esta diponible\n";
            $respuesta = json_decode(json_encode(array("data" => array ("tld" => $dominio,"domain" => $nombre, "available" => 1))));
        }
        elseif(stristr($rta,$disponible)){
            //echo $nombre.$dominio." se encuentra registrado\n";
            $respuesta = json_decode(json_encode(array("data" => array ("tld" => $dominio,"domain" => $nombre, "available" => 2))));
        }
        else
         {
            $this->error = array("tipo" => "Inesperado!!!!", "mensaje" => "QUE PASA!!Error en el comando whois para el dominio  $nombre.$dominio .");
            return false;
         //   var_dump($rta); //Error!!!!
         }

    }
    else{

        // Crea un nuevo recurso cURL
        $ch = curl_init();

        // Establece la URL y otras opciones apropiadas
        curl_setopt($ch, CURLOPT_URL, $url);
    //    curl_setopt($ch, CURLOPT_HEADER, 0);

        curl_setopt($ch, CURLOPT_REFERER, "http://$url");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "nombre=$nombre&dominio=$dominio");

        // Captura la URL y la enva al navegador
        $str = curl_exec($ch);

        // Cierrar el recurso cURLy libera recursos del sistema
        curl_close($ch);
        if(stripos($str,"registrado")){
        //    echo "Esta registrado\n";
            $respuesta = json_decode(json_encode(array("data" => array ("tld" => $dominio,"domain" => $nombre, "available" => 2))));
        }
        elseif(stripos($str,"disponible")) {
            //echo "Esta DISPONIBLE\n";
            $respuesta = json_decode(json_encode(array("data" => array ("tld" => $dominio,"domain" => $nombre, "available" => 1))));
        }
        else
         {
            $this->error = array("tipo" => "Inesperado", "mensaje" => "No responde la pagina de NIC.AR");
            return false;

 //echo "No repondio la pagina\n"; //ERROR!!!
         }


    }
//var_dump($respuesta);

    return $respuesta;

  }

  /**
   * Consulta el progreso de la registracin de un dominio.
   * 
   * @param string dominio a consultar.
   * 
   * @return string Retorna: El estado que figura en 'El Server'
   *                         null si no se encuentra el dominio
   *  			false si hubo algn problema en la consulta a 'El Server', usar getError().
   */
  public function ConsultarEstado($dominio)
  {
    // Bouml preserved body begin 00025E02
    $rta = false;

    if($this->IniciarSesion()){
        $consulta = array(  "pagina" =>  "",
    		                   "limit"  =>  "",
    		                   "dominio" => $dominio,
    		                   "exact" =>   1,
    		                   "sorted" =>  "",
    		                   "by" =>      "" );

        if($listado = $this->ListarDominios($consulta)){
            $rta = $listado->{"data"}[0]->{"status"};
        }

    }

    return $rta;
    // Bouml preserved body end 00025E02
  }

  /**
   * @return string Devuelve el ltimo error que se produjo.
   * 
   */
  public function getError()
  {
    // Bouml preserved body begin 00020E82
        return $this->error;
    // Bouml preserved body end 00020E82
  }

  /**
   * Borra los datos con que fue dado de alta el Dominio.
   * NOTA: El api del "El Server" no soporta la opcin de borrar el domino
   * @param array $datosDominio Es un array asociativo con las sig keys:
   * 	array(	dominio =>
   * 		usoLibre =>     'campo de texto de uso libre hasta 255 caracteres'
   * 		renovar =>
   * 		ns1_name =>
   * 		ns1_ip =>
   * 		ns2_name =>
   * 		ns2_ip =>
   * 		ns3_name =>
   * 		ns3_ip =>
   * 		ns4_name =>
   * 		ns4_ip =>
   * 		ns5_name => 
   * 		ns5_ip => )
   * 
   * @return bool - true si pudo borrar los datos o false si hubo algn error.
   */
  public function BorrarDominio($datosDominio)
  {
    // Bouml preserved body begin 00022A82
    $this->error = array("tipo" => "Info" ,"mensaje" => "En el api de 'El Server' no esta soportada la opcion de borrar un dominio." );
    return false;
    // Bouml preserved body end 00022A82
  }

  /**
   * Loguea un usuario SSO al sistema y obtiene un access_token con el que hace el resto de las operaciones.
   * Si se pudo loguear returna true, caso contrario retorna false y setea el atributo error.
   * 
   * @return bool
   */
  public function IniciarSesion()
  {
    // Bouml preserved body begin 00020F02
        $this->url = "GET /sso/login/?sso=".urlencode(USUARIO)."&password=".urlencode(CLAVE)."&ctx=".urlencode(CONTEXTO)." HTTP/1.1 \r\n";
        $rta = $this->EjecutarConsulta();
        $rta = json_decode($rta);

        if(isset($rta->{'access_token'}))
        {
            $this->access_token = $rta->{'access_token'};
            $this->error = array("tipo" =>  "Info" ,"mensaje" => "Se inicio sesion contra el server token: ".$rta->{'access_token'});
            return true;
        }
        elseif(isset($rta->{'error'}))
        {
            $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'}.". Controlar constantes.php");
            return false;
        }
        else
        {
            $this->error = array("tipo" => "Inesperado", "mensaje" => "No se pudo acceder al api de El Server. Controlar constantes.php");
            return false;
        }
    // Bouml preserved body end 00020F02
  }

  /**
   * Lista los dominios que fueron dados de alta por Iplan
   * @param array $datosDominio Es un array asociativo con las sig keys:
   * 	array(
   * 		"pagina" =>  nro de pagina del listado 0 a N
   * 		"limit"  =>  cantidad de registros por pagina
   * 		"dominio" => puede ser vacio o el nombre del dominio que se quiere consultar
   * 		"exact" =>   0 devuelve dominios que se parezcan - 1 devuelve el dominio exacto
   * 		"sorted" =>  1 para que se ordene
   * 		"by" =>      campo por el que se ordena
   * 	)
   * 
   * 
   * 
   * 
   * @return false u object(stdClass) con le listado de dominios 
   */
  public function ListarDominios($Datos)
  {
    // Bouml preserved body begin 00020F82
        //$this->url = "GET /domain/?access_token=".$this->access_token."&account=".CUENTA."&offset=&limit=&q=&sortorder=&by="." HTTP/1.1 \r\n";
        $this->url = "GET /domain/?access_token=".$this->access_token."&account=".CUENTA;
	     $this->url .= "&offset=" 	. $Datos["pagina"] ;
	     $this->url .= "&limit=" 	. $Datos["limit"] ;
	     $this->url .= "&q=" 		. $Datos["dominio"] ;
	     $this->url .= "&exact=" 	. $Datos["exact"] ;
	     $this->url .= "&sortorder=" 	. $Datos["sorted"] ;
	     $this->url .= "&by=" 		. $Datos["by"] ;
	     $this->url .= " HTTP/1.1 \r\n";	
        $rta = json_decode($this->EjecutarConsulta());
        if(isset($rta->{'error'}))
        {
            $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
            return false;
        }
        else
        {
            $this->error = array("tipo" =>  "Info" ,"mensaje" => "Se consulto el listado de dominios con exito.");
            return $rta;
        }
    // Bouml preserved body end 00020F82
  }

  /**
   * Modifica los datos con que fue dado de alta el Dominio   .
   * @param array $datosDominio Es un array asociativo con las sig keys:
   * 	array(	dominio =>
   * 		usoLibre =>     'campo de texto de uso libre hasta 255 caracteres'
   * 		renovar =>
   * //Agregado en la modificacion del API
   * //Datos de la Entidad Registrante
   * 		regisNombre =>
   * 		regisMail =>
   * 		regisTelefono =>
   * 		regisTipoIdent =>    //DNI - CUIT - CUIL
   * 		regisNroIdent =>
   * 		regisDireccion =>    //Calle y nmero
   * 		regisCodPostal =>
   * 		regisProvincia =>
   * 		regisCiudad =>       // Localidad / Ciudad
   * // Datos de la Persona Responsable  Pueden ir vacios, en tal caso se toma los datos del Registrante
   * 		admNombre =>
   * 		admMail
   * 		admTelefono =>
   * 		admDireccion =>   //Calle y numero
   * 		admCodPostal =>
   * 		admProvincia =>
   * 		admCiudad =>      // Localidad / Ciudad
   * // Datos tecnicos
   * 		conTecnico =>     // Contacto Tecnico
   * 		entAdministrativa => // Entidad Administrativa
   * // FIN Agregado en la modificacion del API		
   * 
   * 		ns1_name =>
   * 		ns1_ip =>
   * 		ns2_name =>
   * 		ns2_ip =>
   * 		ns3_name =>
   * 		ns3_ip =>
   * 		ns4_name =>
   * 		ns4_ip =>
   * 		ns5_name => 
   * 		ns5_ip => )
   * 
   * @return bool - true si pudo modificar los datos o false si hubo algn error.
   */
  public function ModificarDatosDominio($datosDominio)
  {
    // Bouml preserved body begin 00021002

        $this->url = "PUT /account/domain/ HTTP/1.1 \r\n";
        $data =     "access_token="    . $this->access_token     ."&".
            "account="    . CUENTA                       ."&".
            "domain="     . $datosDominio["dominio"]     ."&".
            "custom="     . $datosDominio["usoLibre"]    ."&".
            "autorenew="  . $datosDominio["renovar"]     ."&".

    //Agregado en la modificacion del API
    //Datos de la Entidad Registrante
    		   "registrant_name="  . $datosDominio["regisNombre"]      ."&" .
    		   "registrant_mail="  . $datosDominio["regisMail"]        ."&" .
    		   "registrant_phone=" . $datosDominio["regisTelefono"]    ."&" .
    		   "registrant_idtype=". $datosDominio["regisTipoIdent"]   ."&" .
    		   "registrant_id="    . $datosDominio["regisNroIdent"]    ."&" .
    		   "registrant_address=". $datosDominio["regisDireccion"]  ."&" .    //Calle y nmero
    		   "registrant_zipcode=". $datosDominio["regisCodPostal"]  ."&" .
    		   "registrant_state=" . $datosDominio["regisProvincia"]   ."&" .
    		   "registrant_city="  . $datosDominio["regisCiudad"]      ."&" .       // Localidad / Ciudad
    // Datos de la Persona Responsable  Pueden ir vacios, en tal caso se toma los datos del Registrante
    		   "admin_name="   . $datosDominio["admNombre"]    . "&" .
    		   "admin_mail="   . $datosDominio["admMail"]      . "&" .
    		   "admin_phone="  . $datosDominio["admTelefono"]  . "&" .
    		   "admin_address=". $datosDominio["admDireccion"] . "&" .   //Calle y numero
    		   "admin_zipcode=". $datosDominio["admCodPostal"] . "&" .
    		   "admin_state="  . $datosDominio["admProvincia"] . "&" .
    		   "admin_city="   . $datosDominio["admCiudad"]    . "&" .      // Localidad / Ciudad
    // Datos tecnicos
    		   "tech_name="    . $datosDominio["conTecnico"]           ."&" .  // Contacto Tecnico
    		   "manager_name=" . $datosDominio["entAdministrativa"]    ."&" . // Entidad Administrativa
    // FIN Agregado en la modificacion del API		
    
            "ns1_name="   . $datosDominio["ns1_name"]    ."&".
            "ns1_ip="     . $datosDominio["ns1_ip"]      ."&".
            "ns2_name="   . $datosDominio["ns2_name"]    ."&".
            "ns2_ip="     . $datosDominio["ns2_ip"]      ."&".
            "ns3_name="   . $datosDominio["ns3_name"]    ."&".
            "ns3_ip="     . $datosDominio["ns3_ip"]      ."&".
            "ns4_name="   . $datosDominio["ns4_name"]    ."&".
            "ns4_ip="     . $datosDominio["ns4_ip"]      ."&".
            "ns5_name="   . $datosDominio["ns5_name"]    ."&".
            "ns5_ip="     . $datosDominio["ns5_ip"];
        $rta = json_decode($this->EjecutarConsulta($data));

        if(isset($rta->{'data'}))
        {
            $this->error = array("tipo" =>  "Info" ,"mensaje" => "Se modifico el dominio ".$datosDominio["dominio"]." con exito.");
            return true;
        }
        elseif(isset($rta->{'error'}))
        {
            $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
            return false;
        }
        else
        {
            $this->error = array("tipo" =>  "Inesperado", "mensaje" => "El Api de El Server no respondio");
            return false;
        }

    // Bouml preserved body end 00021002
  }

  /**
   * Realiza la registracin del dominio en "El Server"    .
   * 
   * @param array $datosDominio Es un array asociativo con las sig keys:
   * 	array(	dominio =>
   * 		periodo =>
   * 		usoLibre =>     'campo de texto de uso libre hasta 255 caracteres'
   * 		renovar =>
   * //Agregado en la modificacion del API
   * //Datos de la Entidad Registrante
   * 		regisNombre =>
   * 		regisMail =>
   * 		regisTelefono =>
   * 		regisTipoIdent =>    //DNI - CUIT - CUIL
   * 		regisNroIdent =>
   * 		regisDireccion =>    //Calle y nmero
   * 		regisCodPostal =>
   * 		regisProvincia =>
   * 		regisCiudad =>       // Localidad / Ciudad
   * // Datos de la Persona Responsable  Pueden ir vacios, en tal caso se toma los datos del Registrante
   * 		admNombre =>
   * 		admMail
   * 		admTelefono =>
   * 		admDireccion =>   //Calle y numero
   * 		admCodPostal =>
   * 		admProvincia =>
   * 		admCiudad =>      // Localidad / Ciudad
   * // Datos tecnicos
   * 		conTecnico =>     // Contacto Tecnico
   * 		entAdministrativa => // Entidad Administrativa
   * // FIN Agregado en la modificacion del API		
   * 
   * 		ns1_name =>
   * 		ns1_ip =>
   * 		ns2_name =>
   * 		ns2_ip =>
   * 		ns3_name =>
   * 		ns3_ip =>
   * 		ns4_name =>
   * 		ns4_ip =>
   * 		ns5_name => 
   * 		ns5_ip => )
   * 
   * 
   * 
   * @return bool - Retorna true si se registro o false si hubo un error y setea la variable $error
   */
  public function RegistrarDominio($datosDominio)
  {
    // Bouml preserved body begin 00021082
        //Se puede pasar el array completo desde la funcion que lo llama
        //$this->url = URL."/domain/";
        $this->url = "POST /domain/ HTTP/1.1 \r\n";

        $data =     "access_token="    . $this->access_token     ."&".
            "account="    . CUENTA                                ."&".
            "domain="    . $datosDominio["dominio"]        ."&".
            "period="    . $datosDominio["periodo"]        ."&".
            "custom="    . $datosDominio["usoLibre"]     ."&".
            "autorenew=". $datosDominio["renovar"]     ."&".

    //Agregado en la modificacion del API
    //Datos de la Entidad Registrante
    		   "registrant_name="  . $datosDominio["regisNombre"]      ."&" .
    		   "registrant_mail="  . $datosDominio["regisMail"]        ."&" .
    		   "registrant_phone=" . $datosDominio["regisTelefono"]    ."&" .
    		   "registrant_idtype=". $datosDominio["regisTipoIdent"]   ."&" .
    		   "registrant_id="    . $datosDominio["regisNroIdent"]    ."&" .
    		   "registrant_address=". $datosDominio["regisDireccion"]  ."&" .    //Calle y nmero
    		   "registrant_zipcode=". $datosDominio["regisCodPostal"]  ."&" .
    		   "registrant_state=" . $datosDominio["regisProvincia"]   ."&" .
    		   "registrant_city="  . $datosDominio["regisCiudad"]      ."&" .       // Localidad / Ciudad
    // Datos de la Persona Responsable  Pueden ir vacios, en tal caso se toma los datos del Registrante
    		   "admin_name="   . $datosDominio["admNombre"]    . "&" .
    		   "admin_mail="   . $datosDominio["admMail"]      . "&" .
    		   "admin_phone="  . $datosDominio["admTelefono"]  . "&" .
    		   "admin_address=". $datosDominio["admDireccion"] . "&" .   //Calle y numero
    		   "admin_zipcode=". $datosDominio["admCodPostal"] . "&" .
    		   "admin_state="  . $datosDominio["admProvincia"] . "&" .
    		   "admin_city="   . $datosDominio["admCiudad"]    . "&" .      // Localidad / Ciudad
    // Datos tecnicos
    		   "tech_name="    . $datosDominio["conTecnico"]           ."&" .  // Contacto Tecnico
    		   "manager_name=" . $datosDominio["entAdministrativa"]    ."&" . // Entidad Administrativa
    // FIN Agregado en la modificacion del API		
    
            "ns1_name="    . $datosDominio["ns1_name"]     ."&".
            "ns1_ip="    . $datosDominio["ns1_ip"]         ."&".
            "ns2_name="    . $datosDominio["ns2_name"]     ."&".
            "ns2_ip="    . $datosDominio["ns2_ip"]         ."&".
            "ns3_name="    . $datosDominio["ns3_name"]     ."&".
            "ns3_ip="    . $datosDominio["ns3_ip"]         ."&".
            "ns4_name="    . $datosDominio["ns4_name"]     ."&".
            "ns4_ip="    . $datosDominio["ns4_ip"]         ."&".
            "ns5_name="    . $datosDominio["ns5_name"]     ."&".
            "ns5_ip="     . $datosDominio["ns5_ip"];


        $rta = json_decode($this->EjecutarConsulta($data));

        if(isset($rta->{'data'}))
        {
            $this->error = array("tipo" =>  "Info" ,"mensaje" => "Se registro el dominio ".$datosDominio["dominio"]." con exito.");
            return true;
        }
        elseif(isset($rta->{'error'}))
        {
            $this->error = array("tipo" => $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'}." Dominio:".$datosDominio["dominio"]);
            return false;
        }
        else
        {
            $this->error = array("tipo" =>  "Inesperado", "mensaje" => "El Api de El Server no respondio ".$datosDominio["dominio"]);
            return false;
            //return $rta;
        }

    // Bouml preserved body end 00021082
  }

  /**
   * Envia variables por GET o POST
   * @param data - Contine las variables que se envian por POST al api de "El Server"
   * @param post - si es 1 envia las variables por post
   * 
   * @return string - Retorna el response del api.
   */
  private function EjecutarConsulta($data = "")
  {
    // Bouml preserved body begin 00021102
        //Tratar de hacer que reintente!!!!
        $this->rawResponse = "";
        $this->rawRequest = "";

        $msg = $this->url.
            "Host: ".URL."\r\n".
            "Accept: */*\r\n";

        if(strpos($this->url,"GET ") === false) {

            $msg.=    "Content-Length: ".strlen($data)."\r\n".
                "Content-Type: application/x-www-form-urlencoded\r\n\r\n".$data;
        }

        $len = strlen($msg);
        $ret ="";

        if( $sock = socket_create(AF_INET,SOCK_STREAM,SOL_TCP)) {
            if(socket_connect($sock,URL,80)){
                $this->rawRequest = $msg;
                $sen = 0;
                while($sen < $len && $sen !== false) {
                    $sen += socket_write($sock,$msg,strlen($msg));
                    $msg = substr($msg,$sen);
                }

                do{
                    $msg = socket_read($sock,2048);
                    $ret .=    $msg;
                }while(strlen($msg) > 0 && $msg !== false);
                $this->rawResponse = $ret;
                $ret = substr($ret,strpos($ret,"\r\n\r\n")); // Se le saca el encabezado TCP
            }
            else {

                $ret = json_encode(array("error" => "CRITICO", "type" => "No se pudo conectar a ".URL." - ".socket_strerror (socket_last_error())));
            }
        }
        else {
            $ret = json_encode(array("error" => "CRITICO", "type" => "No se pudo crear el socket - ".socket_strerror (socket_last_error())));
        }

        return $ret;
    // Bouml preserved body end 00021102
  }

  /**
   * String de la ltima conexin de request
   */
  public function getRawRequest()
  {
    // Bouml preserved body begin 00024402
    return $this->rawRequest;
    // Bouml preserved body end 00024402
  }

  /**
   * String con la conexin de la ltima respuesta
   */
  public function getRawResponse()
  {
    // Bouml preserved body begin 00024482
    return $this->rawResponse;
    // Bouml preserved body end 00024482
  }

}
?>
