<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class DominioForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001A6B05
	parent::__construct($orm, $context);
	$this->setClass('Dominio')
		 ->addComponent(new TextComponent('Nombre de dominio', 'dominio', 'nombre'))
		 ->setTitle('Datos del Dominio')
		 ->setMethod('post')
		 ->setFormType(ABMForm::FORM_OK_CANCEL)
		  ;
    // Bouml preserved body end 001A6B05
  }

}
?>