<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ServiceOrder.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Miguel Angel Ponce
* 
*/
/**
 * Simboliza el estado de un pedido de aprovisionamiento de un nombre de dominio.
 */
class Dominio extends ORMObject {
  /**
   * @var int Un flag que me dice el estado del trámite en Nic.ar
   */
  protected $elServerStatus;

  /**
   * @var string El nombre del dominio
   */
  protected $nombre;

  /**
   * @var int Estado de la transacción (provisioning+10Fold)
   */
  protected $provisioninigStatus;

  /**
   * @var ServiceOrder la tarea que dio origen a la solucitud de Alta/Baja de dominio
   */
  protected $serviceOrderTask;

  /**
   * Retorna un objeto de definición predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param ORM $orm el manejador de objetos para el cual se registra la definición
   * @return ORMDefinition la definición default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001A5105
	$definition = parent::define($orm);/* @var $definition ORMDefinition */
	
	$definition->setClass('Dominio')
				->setTable('REGISTRO_DOMINIO')
				->addField('elServerStatus', 'ELSERVERSTATUS', ORMDefinition::SMALLINT)
				->addField('nombre', 'NOMBRE', ORMDefinition::STRING, 100)
				->addField('provisioninigStatus', 'PROVISIONING_STATUS', ORMDefinition::SMALLINT)
				->addInstance('serviceOrderTask', 'SERVICEORDERTASKID', 'ServiceOrder')
				;

	return $definition;
    // Bouml preserved body end 001A5105
  }

}
?>