<?php
require_once 'iplan/models/dns/interfaceElServer/IntElServer.php';
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/dns/Dominio.php';
require_once 'iplan/models/dns/forms/DominioForm.php';
require_once 'iplan/models/dns/DNS.php';



/**
* Author: Miguel Angel Ponce
* 
*/
class DNSManager extends AbstractManager {
  /**
   * @var IntElServer - prueba
   */
  private $interface;

  /**
   * Mi metodo hace xxxx
   * 
   * @param ApplicationContext $context el contexto de la aplicación.
   * @param boolean $ajax un flag que indica si el llamado fue hecho via AJAX
   * 
   * @return Renderable blablablablabla
   */
  public function listDNS(&$context, $ajax)
  {
    // Bouml preserved body begin 001A3785
	$orm = $this->application->getORM();

	//Creo el filtro:
	
	$aOpcionesEstados = array(array("value" => "1", "description" => "Completo"), array("value" => "0", "description" => "Pendiente"));
	
	$compStatus = new SelectComponent('Estado Provisioning', 'statusProvisioning', 'statusProvisioning');
	$compStatus->setOptions($aOpcionesEstados);
	
	$compStatusServ = new SelectComponent('Estado Elserver', 'statusElServer', 'statusElServer');
	$compStatusServ->setOptions($aOpcionesEstados);
	
	$domain = new TextComponent("Dominio", "domain", "domain");
	$cliente = new TextComponent("Nro Cliente", "client.clientNumber", "client.clientNumber");
	$razonSocial = new TextComponent("Razón Social", "client.name", "client.name");
	
	
	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent($cliente, 1, 1)
			 ->addComponent($razonSocial, 1, 2)
			 ->addComponent(new TextComponent('Subscripción', 'flt_subscription', 'suscription'), 1, 3)
			 ->addComponent($domain, 2, 1)
			 ->addComponent($compStatus, 2, 2)
			 ->addComponent($compStatusServ, 2, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4, 1, 2, 'center');
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(array("maps" => "client.id", "name" => "cliente_id")))
			->setAction("DNS.listDNS")
            ->setTarget("div_list_items")
            ->setTitle("Filtros")
		    ->setMethod("post")
		    ->setId("id_form_filtros")
			->setContext($context)
			->loadValues();

	$nroCliente = new Column('Nro. Cliente', 'client.clientNumber', false, null, true, 'AutoProvisioning.listClients');
	$nroCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'client.clientNumber'));
	
	//Columnas del Listado
	$suscripcion_id = new Column('Subscripción', 'suscription', true, null, true, 'AutoProvisioning.listServiceOrderTasks');
	$suscripcion_id->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams(array('url' => 'listServiceOrderTasks', 'subscriptionId' => 'suscription'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn($suscripcion_id)
			->addColumn($nroCliente)
			->addColumn(new Column('Cliente', 'client.name'))
			->addColumn(new Column('Dominio', 'domain'))
			->addColumn(new Column('Estado Elserver', 'statusElServer', false, "<span style=\"color:{{ (statusElServer == 1) ? 'green' : 'grey' }}\">{{ statusElServer == 1 ? 'Completo' : 'Pendiente' }}</span>"))
			->addColumn(new Column('Estado Provisioning', 'statusProvisioning', false, "<span style=\"color:{{ (statusProvisioning == 1) ? 'green' : 'grey' }}\">{{ statusProvisioning == 1 ? 'Completo' : 'Pendiente' }}</span>"))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
						)))
			/*->addAction($addLine)*/
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (DNSManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Resellers
			$query = $orm->query('DNS')
						 ->attributes('id', 'suscription','client.name', 'client.clientNumber', 'statusElServer', 'domain', 'statusProvisioning');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001A3785
  }

  public function saveDominio(&$context, $ajax)
  {
    // Bouml preserved body begin 001A6A85
	$orm = $this->application->getORM();
	$dominioForm = new DominioForm($orm, $context);
	return $dominioForm->deploy($context, $orm);
    // Bouml preserved body end 001A6A85
  }

  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 001A6B85
    // Bouml preserved body end 001A6B85
  }

}
?>