<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Client.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Miguel Angel Ponce
* 
*/
/**
 * Simboliza el estado de un pedido de aprovisionamiento de un nombre de dominio.
 */
class DNS extends ORMObject {
  /**
   * @var int El número de Suscripción
   */
  protected $suscription;

  /**
   * @var string El estado del Provisioning
   */
  protected $statusProvisioning;
  
  /**
   *
   * @var int El estado en El Server
   */
  protected $statusElServer;
  
  /**
   *
   * @var string el Dominio 
   */
  protected $domain;
  
  /**
   *
   * @var int El tipo de Servicio 
   */
  protected $serviceType;
  
  /**
   * @var Client El cliente q tiene el dns
   */
  protected $client;

  /**
   * Retorna un objeto de definición predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param ORM $orm el manejador de objetos para el cual se registra la definición
   * @return ORMDefinition la definición default
   */
  public static function define(&$orm = null)
  {
	return parent::define($orm)
				->setClass('DNS')
				->setTable('CAP_DNS')
				->addField('id', 'ID_CAP_DNS', ORMDefinition::INTEGER, 38, 0)
				->setKey("id")
				->addField('suscription', 'SUSCRIPTION_ID', ORMDefinition::INTEGER, 38, 0)
				->addField('statusProvisioning', 'STATUS_PROVISIONING', ORMDefinition::INTEGER, 38, 0)
				->addField('statusElServer', 'STATUS_ELSERVER', ORMDefinition::INTEGER, 38, 0)
				->addField('domain', 'DOMINIO', ORMDefinition::STRING, 100)
				->addField('serviceType', 'SERVICETYPESPSID', ORMDefinition::INTEGER, 3, 0)
				->addInstance("client", "CLIENTE_ID", "Client")
				;

  }

}
?>