<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/models/backup/BackupStatus.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class BackupStatusForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001CC905
	parent::__construct($orm, $context);
	
	$this->setClass('BackupStatus')
		 ->setTitle('Estado del Backup')
		 ->setMethod('post')
		 ->addComponent(new TextComponent(array('label'=>'Descripción', 'maps'=>'description', 'size'=>25)))
		 ->setFormType(ABMForm::FORM_OK_CANCEL);
	
	return $this;
    // Bouml preserved body end 001CC905
  }

}
?>