<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/models/backup/BackupPolicy.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class BackupPolicyForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001CCA05
	parent::__construct($orm, $context);
	
	$this->setClass('BackupPolicy')
		 ->setTitle('Política de Backup')
		 ->setMethod('post')
		 ->addComponent(new TextComponent(array('label'=>'Descripción', 'maps'=>'description', 'size'=>30)))
		 ->addComponent(new TextComponent(array('label'=>'Código', 'maps'=>'code', 'size'=>20)))
		 ->addComponent(new SelectComponent(array('label'=>'Categoría', 'maps'=>'category',
												  'options'=>$orm->query('BackupCategory')
																 ->attributes('id as value', 'description')
																 ->find()
												  )))
		 ->setFormType(ABMForm::FORM_OK_CANCEL);
	
	return $this;
    // Bouml preserved body end 001CCA05
  }

}
?>