<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/backup/BackupAvamar.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class BackupAvamarForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 001CCB85
	parent::__construct($orm, $context);

	$grid = new GridLayout(6, 2);
	$grid->setName('layout')
		 ->addComponent(new TextComponent(array('label'=>'Nro. Cliente', 'maps'=>'clientNumber', 'size'=>8)), 1, 1)
		 ->addComponent(new TextComponent(array('label'=>'Suscripción', 'maps'=>'suscription', 'size'=>8)), 1, 2)
		 ->addComponent(new TextComponent(array('label'=>'IP', 'maps'=>'ip', 'size'=>15)), 2, 1)
		 ->addComponent(new TextComponent(array('label'=>'Mail', 'maps'=>'mail', 'size'=>30)), 2, 2)
		 ->addComponent(new SelectComponent(array('label'=>'Política Diaria', 'maps'=>'daily',
												  'options'=>$orm->query('BackupPolicy')
																 ->attributes('id as value', 'description')
																 ->filterBy('category.description', '=', 'Diaria')
																 ->find()
												  )), 3, 1)
		 ->addComponent(new SelectComponent(array('label'=>'Política Semanal', 'maps'=>'weekly',
												  'options'=>$orm->query('BackupPolicy')
																 ->attributes('id as value', 'description')
																 ->filterBy('category.description', '=', 'Semanal')
																 ->find()
												  )), 4, 1)
		 ->addComponent(new SelectComponent(array('label'=>'Política Mensual', 'maps'=>'monthly',
												  'options'=>$orm->query('BackupPolicy')
																 ->attributes('id as value', 'description')
																 ->filterBy('category.description', '=', 'Mensual')
																 ->find()
												  )), 5, 1)
		 ->addComponent(new CheckboxComponent('¿Ejecuta backup sobre demanda?', 'enableOnDemand', 'enableOnDemand', 1, false), 4, 2)
			;
	if ($context->getUser()->hasProfile('Administrador Avamar')) {
		 $grid->addComponent(new SelectComponent(array('label'=>'Estado', 'maps'=>'status',
												  'options'=>$orm->query('BackupStatus')
																 ->attributes('id as value', 'description')
																 ->find()
												  )), 3, 2);
	}
	$this->setClass('BackupAvamar')
		 ->setTitle('Servicio de Backup')
		 ->setMethod('post')
		 ->addComponent($grid)
		 ->setFormType(ABMForm::FORM_OK_CANCEL);
	
	return $this;
    // Bouml preserved body end 001CCB85
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 001D1F85
	if (!$context->getUser()->hasProfile('Administrador Avamar')) {
		$pendiente = $orm->query('BackupStatus')->filterBy('description', '=', 'Pendiente')->findOne();
		$this->addComponent(new HiddenComponent('', 'status', 'status', $pendiente->getId()));
	}
	
	$id = $this->getValueOf('id');
	if ($id === null) {
		$this->addComponent(new HiddenComponent('', 'pass', 'password', substr(sha1(date('YmdHisu')),0,8)));
		$this->addComponent(new HiddenComponent('', 'user', 'user', $context->getUser()->getId()));
	}
	
	$res = parent::save($context, $orm);
	if (is_object($res)) {/*@var $res BackupAvamar*/
		$backupManager = $context->getManager('Backup');/*@var $backupManager BackupManager */
		if ($id === null) {
			$body = 
'<p>Se ha dado de alta el siguiente Servicio Avamar:</p>
<ol>
<dt>Suscripci&oacute;n:</dt>
<dd>'.$res->getSuscription().'</dd>
<dt>IP:</dt>
<dd>'.$res->getIp().'</dd>
<dt>Password:</dt>
<dd>'.$res->getPassword().'</dd>
<dt>Pol&iacute;ticas:</dt>
<dd><ul>
	  <li><span>Diaria: </span>'.$res->getDaily()->getDescription().'. C&oacute;digo Tenfold: '.$res->getDaily()->getCode().'</li>
	  <li><span>Semanal: </span>'.$res->getWeekly()->getDescription().'. C&oacute;digo Tenfold: '.$res->getWeekly()->getCode().'</li>
	  <li><span>Mensual: </span>'.$res->getMonthly()->getDescription().'. C&oacute;digo Tenfold: '.$res->getMonthly()->getCode().'</li>
	</ul>
</dd>
<dt>&iquest;Puede ejecutar backup por demanda?</dt>
<dd>'.(($res->getEnableOnDemand()?'S&iacute;':'No')).'</dd>
</ol>
<p>Una vez completada la operaci&oacute;n, favor de registrar la misma en el <a href="autoprovisioning.iplantech.com.ar/?action=listAvamars&id='.$res->getId().'" alt="Sistema Autoprovisioning">Sistema de Autoprovisioning</a>.</p>
<p>Muchas gracias</p>';
			$backupManager->sendMail(array('jviola@iplan.com.ar', 'dfazio@iplan.com.ar', 'fcordone@iplan.com.ar', 'dcabral@iplan.com.ar'), 'Ingenier&Iacute;a', 'Diego, Federico y Dami&aacute;n', 'Alta de Backup Avamar', $body);
		} else {
			if ($res->getStatus()->getDescription() == 'Completo') {
				$body = 
'<p>Se ha completado la configuración del Servicio Avamar:</p>
<ol>
<dt>Suscripci&oacute;n:</dt>
<dd>'.$res->getSuscription().'</dd>
<dt>IP:</dt>
<dd>'.$res->getIp().'</dd>
<dt>Password:</dt>
<dd>'.$res->getPassword().'</dd>
<dt>Pol&iacute;tica:</dt>
<dd><ul>
	  <li><span>Diaria: </span>'.$res->getDaily()->getDescription().'. C&oacute;digo Tenfold: '.$res->getDaily()->getCode().'</li>
	  <li><span>Semanal: </span>'.$res->getWeekly()->getDescription().'. C&oacute;digo Tenfold: '.$res->getWeekly()->getCode().'</li>
	  <li><span>Mensual: </span>'.$res->getMonthly()->getDescription().'. C&oacute;digo Tenfold: '.$res->getMonthly()->getCode().'</li>
	</ul>
</dd>
<dt>&iquest;Puede ejecutar backup por demanda?</dt>
<dd>'.(($res->getEnableOnDemand()?'S&iacute;':'No')).'</dd>
</ol>
<p>Recuerde que puede consultar estos datos desde el <a href="autoprovisioning.iplantech.com.ar/?action=listAvamars&id='.$res->getId().'" alt="Sistema Autoprovisioning">Sistema de Autoprovisioning</a>.</p>
<p>Muchas gracias</p>';
				$user = $res->getUser();
				$backupManager->sendMail($user->getMail(), 'Implementaciones', $user->getName().' '.$user->getSurname(), 'Backup Avamar Completado', $body);			
			}
		}
		return $res;
	} else return $res;
    // Bouml preserved body end 001D1F85
  }

}
?>