<?php
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method BackupStatus setDescription()
 * @method string getDescription()
 */
class BackupStatus extends ORMObject {
  /**
   * @var string la descripción del estado
   */
  protected $description;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001CC885
	return parent::define($orm)
			  ->setClass('BackupStatus')
			  ->setTable('BKP_STATUS')
			  ->addField('id', 'STATUS_ID', ORMDefinition::INTEGER)
				->setKey('id')
			  ->addField('description', 'STATUS_DESCRIPTION', ORMDefinition::STRING, 25, null, false)
			;
    // Bouml preserved body end 001CC885
  }

}
?>