<?php
require_once 'iplan/models/backup/BackupCategory.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method BackupPolicy setDescription()
 * @method string getDescription()
 * @method BackupPolicy setCode()
 * @method string getCode()
 */
class BackupPolicy extends ORMObject {
  /**
   * @var string la descripción de la política
   */
  protected $description;

  /**
   * @var string la codificación de 10Fold de la policy
   */
  protected $code;

  /**
   * @var BackupCategory la categoría de la política
   */
  protected $category;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001CC805
	return parent::define($orm)
			  ->setClass('BackupPolicy')
			  ->setTable('BKP_POLICY')
			  ->addField('id', 'POLICY_ID', ORMDefinition::INTEGER)
				->setKey('id')
			  ->addField('description', 'POLICY_DESCRIPTION', ORMDefinition::STRING, 100, null, false)
			  ->addField('code', 'POLICY_CODE', ORMDefinition::STRING, 20, null, false)
			  ->addInstance('category', 'CATEGORY_ID', 'BackupCategory', false)
			;
    // Bouml preserved body end 001CC805
  }

}
?>