<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/models/backup/BackupAvamar.php';
require_once 'iplan/models/backup/BackupPolicy.php';
require_once 'iplan/models/backup/BackupStatus.php';
require_once 'iplan/models/backup/forms/BackupStatusForm.php';
require_once 'iplan/models/backup/forms/BackupPolicyForm.php';
require_once 'iplan/models/backup/forms/BackupAvamarForm.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/backup/forms/BackupCategoryForm.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class BackupManager extends AbstractManager {
  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 001CC585
    // Bouml preserved body end 001CC585
  }

  /**
   * Lista los estados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 001CC605
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Estado', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'Backup.modifyStatus', 'id'),
				new ActionButton($context, 'Backup.deleteStatus', 'id', null, 'alert inline')
			)))
			->setListFunction(function (BackupManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('BackupStatus')
										 ->attributes('id', 'description');
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'Backup.addStatus'))
			;
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Estado', 'status', 'description'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Estados')
		 ->setAction('Backup.listStatus');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001CC605
  }

  /**
   * Lista las políticas
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listPolicies(&$context, $ajax)
  {
    // Bouml preserved body begin 001CC685
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Description', 'description', true))
			->addColumn(new Column('Código', 'code'))
			->addColumn(new Column('Categoría', 'categoryDesc'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'Backup.modifyPolicy', 'id'),
				new ActionButton($context, 'Backup.deletePolicy', 'id', null, 'alert inline')
			)))
			->setListFunction(function (BackupManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('BackupPolicy')
										 ->attributes('id', 'description', 'code', 'category.description as categoryDesc');
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'Backup.addPolicy'))
			;
	$layout = new GridLayout(1, 3);
	$layout->addComponent(new TextComponent('Descripción', 'description', 'description'), 1, 1)
		   ->addComponent(new TextComponent('Código', 'code', 'code'), 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Políticas de Backup')
		 ->setAction('Backup.listPolicies');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001CC685
  }

  /**
   * Lista los servicios contratados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listAvamars(&$context, $ajax)
  {
    // Bouml preserved body begin 001CC705
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('IP', 'ip'))
			->addColumn(new Column('Nro. Cliente', 'clientNumber'))
			->addColumn(new Column('Suscripción', 'suscription'))
			->addColumn(new Column('Mail', 'mail'))
			->addColumn(new Column('Política Diaria', array('dailyDesc', 'dailyCode'), false, '[{{dailyCode}}] {{dailyDesc}}'))
			->addColumn(new Column('Política Semanal', array('weeklyDesc', 'weeklyCode'), false, '[{{weeklyCode}}] {{weeklyDesc}}'))
			->addColumn(new Column('Política Mensual', array('monthlyDesc', 'monthlyCode'), false, '[{{monthlyCode}}] {{monthlyDesc}}'))
			->addColumn(new Column('Password', 'password'))
			->addColumn(new Column('Estado', 'statusDesc'))
			->addColumn(new Column('Responsable', array('name', 'surname'), false, '{{name}}, {{surname}}'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'Backup.modifyAvamar', 'id'),
				new ActionButton($context, 'Backup.deleteAvamar', 'id', null, 'alert inline'),
				new ActionButton($context, 'Backup.changePassword', 'id', null, 'alert inline')
			)))
			->setListFunction(function (BackupManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('BackupAvamar')
										 ->attributes('id', 'clientNumber', 'ip', 'mail', 'suscription', 'password', 
													  'user.name as name', 'user.surname as surname',
													  'status.description as statusDesc', 
													  'daily.description as dailyDesc', 'daily.code as dailyCode',
													  'weekly.description as weeklyDesc', 'weekly.code as weeklyCode', 
													  'monthly.description as monthlyDesc','monthly.code as monthlyCode'
													  );
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'Backup.addAvamar'))
			;
	$layout = new GridLayout(1, 5);
	$layout->addComponent(new HiddenComponent('', 'id', 'id'), 1, 1)
		   ->addComponent(new TextComponent('IP', 'ip', 'ip'), 1, 2)
		   ->addComponent(new TextComponent('Suscripción', 'suscription', 'suscription'), 1, 3)
		   ->addComponent(new TextComponent('Nro. Cliente', 'clientNumber', 'clientNumber'), 1, 4)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Servicios Contratados')
		 ->setAction('Backup.listAvamars');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001CC705
  }

  /**
   * Lista los servicios contratados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listCategories(&$context, $ajax)
  {
    // Bouml preserved body begin 001DB805
$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Categoría', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'Backup.modifyCategory', 'id'),
				new ActionButton($context, 'Backup.deleteCategory', 'id', null, 'alert inline')
			)))
			->setListFunction(function (BackupManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('BackupCategory')
										 ->attributes('id', 'description');
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'Backup.addCategory'))
			;
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Categoría', 'description', 'description'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Categorias')
		 ->setAction('Backup.listCategories');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001DB805
  }

  /**
   * Lista los servicios contratados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 001CC985
	$orm = $this->application->getORM();
	$oForm = new BackupStatusForm($orm, $context);	
	return $oForm->deploy($context, $orm);
    // Bouml preserved body end 001CC985
  }

  /**
   * Lista los servicios contratados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmPolicy(&$context, $ajax)
  {
    // Bouml preserved body begin 001CCA85
	$orm = $this->application->getORM();
	$oForm = new BackupPolicyForm($orm, $context);	
	return $oForm->deploy($context, $orm);
    // Bouml preserved body end 001CCA85
  }

  /**
   * Lista los servicios contratados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmAvamar(&$context, $ajax)
  {
    // Bouml preserved body begin 001CCB05
	$orm = $this->application->getORM();
	$oForm = new BackupAvamarForm($orm, $context);	
	return $oForm->deploy($context, $orm);
    // Bouml preserved body end 001CCB05
  }

  /**
   * Lista los servicios contratados
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function abmCategory(&$context, $ajax)
  {
    // Bouml preserved body begin 001DB885
	$orm = $this->application->getORM();
	$oForm = new BackupCategoryForm($orm, $context);	
	return $oForm->deploy($context, $orm);
    // Bouml preserved body end 001DB885
  }

  /**
   * @return PHPMailer
   */
  public function sendMail($to, $client, $contact, $title, $body)
  {
    // Bouml preserved body begin 001D1E85
	$meses = array(1=>'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
	$date = getdate();
	$mail = new PHPMailer();
	$mail->IsSMTP();
	$mail->IsHTML();
	$mail->Host = 'smtpinterno.iplan.com.ar';
	$mail->From = 'servicios@iplan.com.ar';
	$mail->FromName = 'Servicios IPlan';
	if (is_string($to)) {
		$mail->AddAddress($to);//TODO poner $to
	} else {
		if (is_array($to) && (count($to)>0)) {
			foreach($to as $to2)
				$mail->AddAddress($to2);
		} else {
			throw new Exception('No se especificó un destinatario');
		}
	}
	$mail->Subject = $title;
	$mail->AddEmbeddedImage('templates/default/images/news-logo-iplan.jpg', 'logo-iplan');	
	$mail->Body =
'<div  style="color: #333333;font-family: Arial,Helvetica,sans-serif;font-size: 1em;border: #000 .1em solid;padding:.5em;">
	<div style="">
		<div style="float:left;"><img src="cid:logo-iplan"/></div>
		<div style="float:right;"><a href="http:://iplan.com.ar">Acerca de IPLAN</a></div>
		<div style="height:2.5em;">&nbsp;</div>
	</div>
	<div>
		<div style="border-top-style: solid; border-top-width: .1em;border-top-color: #c1c1c1; text-align: right;padding-top: 1em;"><strong>Buenos Aires, '.$meses[$date['mon']].' de '.$date['year'].'</strong></div>
		<p style="padding-top: 2em;font-weight: bold;">'.$client.'</p>
		<p>Estimada/o '.$contact.':</p>'.
			$body.
'		<p style="font-size: .85em;">
			<span style="font-weight: bold;">IPlan</span><br/>
		Sistema de Provisioning<br/>
		RECONQUISTA 865 | C1003ABQ<br/>
		IPLAN | <a href="http://iplan.com.ar">iplan.com.ar</a><br/>
		</p>
	</div>
</div>';

	return $mail->Send();	
    // Bouml preserved body end 001D1E85
  }

  /**
   * Cambia el password de un servicio
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function changePassword(&$context, $ajax)
  {
    // Bouml preserved body begin 001D2105
	$orm = $this->application->getORM();
	
	$id = $context->getParam('id');
	$backup = $orm->load('BackupAvamar', $id);/*@var $backup BackupAvamar */
	$backup->setPassword(substr(sha1(date('YmdHisu')),0,8));
	$backup->save();
	
	$context->set('UWS_BACK_ACTION', $context->getParam('UWS_BACK_ACTION'));
	$context->set('UWS_LIST_FILTER', urldecode(urldecode($context->getParam('UWS_LIST_FILTER'))));
	return new Renderable('lib/success.xhtml');
    // Bouml preserved body end 001D2105
  }

  /**
   * Retorna el mail de un cliente determinado
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La dirección de mail.
   */
  public function wsGetEmailBySuscription($context, $ajax)
  {
    // Bouml preserved body begin 001DEC85
	$orm = $this->application->getORM();
	$context = $this->application->getContext();
	$suscription = $context->getParam('suscription');
	$mails = $orm->query('BackupAvamar')
				 ->filterBy('suscription', '=', $suscription)
				 ->attributes('mail', 'status.description')
				 ->find();

	if ($mails === false)
		throw new Exception("La suscripción $suscription no existe en el sistema", 2001);
	if (count($mails) != 1)
		throw new Exception("La suscripción $suscription tiene más de un servicio configurado", 2002);
	if ($mails[0]['status.description'] != 'Completo')
		throw new Exception("La suscripción $suscription no está en Completo. Estado actual: ".$mails[0]['status.description'], 2003);

	$renderable = new Renderable(null, true);
	$renderable->setContent($mails[0]['mail']);
	return $renderable;
    // Bouml preserved body end 001DEC85
  }

}
?>