<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class BackupCategory extends ORMObject {
  /**
   * @var string description la descripción de la categoría
   */
  protected $description;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001DB705
	return parent::define($orm)
				  ->setClass('BackupCategory')
				  ->setTable('BKP_CATEGORY')
				  ->addField('id', 'CATEGORY_ID', ORMDefinition::INTEGER)
					->setKey('id')
				  ->addField('description', 'CATEGORY_DESCRIPTION', ORMDefinition::STRING, 50);
			;
// Bouml preserved body end 001DB705
  }

}
?>