<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/backup/BackupStatus.php';
require_once 'iplan/models/backup/BackupPolicy.php';
require_once 'iplan/security/User.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method BackupAvamar setIp()
 * @method string getIp()
 * @method BackupAvamar setClientNumber()
 * @method string getClientNumber()
 * @method BackupAvamar setSuscription()
 * @method string getSuscription()
 * @method BackupAvamar setMail()
 * @method string getMail()
 * @method BackupAvamar setPassword()
 * @method string getPassword()
 * @method BackupAvamar setDaily()
 * @method BackupPolicy getDaily()
 * @method BackupAvamar setWeekly()
 * @method BackupPolicy getWeekly()
 * @method BackupAvamar setMonthly()
 * @method BackupPolicy getMonthly()
 * @method BackupAvamar setEnableOnDemand()
 * @method boolean getEnableOnDemand()
 * @method BackupAvamar setStatus()
 * @method BackupStatus getStatus()
 * @method BackupÁvamar setUser()
 * @method User getUser()
 * 
 */
class BackupAvamar extends ORMObject {
  /**
   * @var string la dirección IP del servidor virtual del cliente
   */
  protected $ip;

  /**
   * @var string el nro. de cliente de 10Fold
   */
  protected $clientNumber;

  /**
   * @var string el código de suscripción del servicio contratado
   */
  protected $suscription;

  /**
   * @var string la dirección de mail del cliente
   */
  protected $mail;

  /**
   * @var string el password del servicio
   */
  protected $password;

  /**
   * @var Status el estado del servicio
   */
  protected $status;

  /**
   * @var Policy la política empleada para el backup diario en el servicio de Avamar del cliente
   */
  protected $daily;

  /**
   * @var BackupPolicy la política semanal del servicio Avamar
   */
  protected $weekly;

  /**
   * @var BackupPolicy la política mensual del servicio Avamar
   */
  protected $monthly;

  /**
   * @var User el usuario que dio de alta el servicio
   */
  protected $user;

  /**
   * @var boolean un flag que indica si el cliente puede ejecutar un backup por demanda o no
   */
  protected $enableOnDemand;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001CC785
	return parent::define($orm)
			  ->setClass('BackupAvamar')
			  ->setTable('BKP_AVAMAR')
			  ->addField('id', 'AVAMAR_ID', ORMDefinition::INTEGER)
				->setKey('id')
			  ->addField('ip', 'AVAMAR_IP', ORMDefinition::STRING, 15, null, false)
			  ->addField('clientNumber', 'AVAMAR_CLIENT_NUMBER', ORMDefinition::STRING, 8, null, false)
			  ->addField('suscription', 'AVAMAR_SUSCRIPTION', ORMDefinition::STRING, 8, null, false)
			  ->addField('mail', 'AVAMAR_MAIL', ORMDefinition::STRING, 255, null, false)
			  ->addField('password', 'AVAMAR_PASSWORD', ORMDefinition::STRING, 8, null)
			  ->addField('enableOnDemand', 'AVAMAR_ONDEMAND', ORMDefinition::BOOLEAN)
			  ->addInstance('user', 'USER_ID', 'User')
			  ->addInstance('status', 'STATUS_ID', 'BackupStatus', false)
			  ->addInstance('daily', 'DAILY_POLICY_ID', 'BackupPolicy', false)
			  ->addInstance('weekly', 'WEEKLY_POLICY_ID', 'BackupPolicy', false)
			  ->addInstance('monthly', 'MONTHLY_POLICY_ID', 'BackupPolicy', false)
			  ->addValidation('mail', 'mail')
			  ->addValidation('ip', 'ip')
			  ->addValidation('ip', "regexp /^172\.21\..*/ La IP %1 no está dentro del rango de IPs de Backup (172.21.xxx.xxx)")
			;
    // Bouml preserved body end 001CC785
  }

}
?>