<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Una conexion es un objeto orientado a base de datos que conserva un estado y a la vez sabe como "hablar" con su base de datos, proveyendo una interfaz comn a tal fin.
 * Inicialmente se pens un esquema de Driver y Connection como conceptos separados pero eso generaba la necesidad de una clase intermedia que supiera de ambas o que la clase Connection tuviera un Driver y proveyera una interfaz muy similar a la que ahora existe (doble trabajo de escritura de interfaz).
 * Se opt por este esquema que simplifica el mantenimiento y es menos complicado de entender.
 */
abstract class Connection {
  const M_NOT_ASSOCIATIVE = 1;

  const M_ASSOCIATIVE = 2;

  const T_ARRAY = 1;

  const T_BLOB = 10;

  const T_BINARY = 15;

  const T_BINARY_FILE = 20;

  const T_CBLOB = 30;

  const T_CHAR = 40;

  const T_CHARACTER_FILE = 50;

  const T_CURSOR = 60;

  const T_CUSTOM = 70;

  const T_LONG = 80;

  const T_INT = 90;

  const T_VARCHAR = 100;

  const TR_DEFAULT = -1;

  const TR_AUTO_COMMIT = 1;

  const TR_NO_AUTO_COMMIT = 2;

  /**
   * El nombre o la IP del host al cual se desea conectar
   */
  private $host;

  private $port;

  /**
   * El nombre del esquema de base de datos al que queremos acceder
   */
  private $schema;

  /**
   * El nombre de usuario con el cual se establece la conexin
   */
  private $user;

  /**
   * La clave del usuario con el que se establece la conexin
   */
  private $password;

  /**
   * El protocolo o tipo de conexin a establecer
   */
  private $protocol;

  /**
   * Recupera la cantidad de filas afectadas (modificadas) por la ltima operacin
   */
  public abstract function affectedRows($query)
  ;
  /**
   * Inicia una transaccin
   */
  public abstract function beginTransaction()
  ;
  /**
   * Asocia el valor de $value a la variable $name del prepared statement. Para ello se debe indicar adems el tamao (-1 para que tome el sizeof() de $value) y el tipo de datos.
   * En el caso que el type sea ARRAY se debe especificar el tipo de los elementos
   */
  public abstract function bind($preparedStatement, $name, &$value, $size = -1, $type = Connection::T_VARCHAR, $element_type = Connection::T_VARCHAR);
  /**
   * Cierra la conexin si est abierta
   */
  public abstract function close()
  ;
  /**
   * Hace un commit de los cambios hasta el momento
   */
  public abstract function commit()
  ;
  /**
   * Establece la conexin con los parmetros que posee registrados en la clase
   */
  public abstract function connect()
  ;
  /**
   * Crea un cursor sobre la conexin especificada
   */
  public abstract function createCursor()
  ;
  /**
   * Ejecuta el sql indicado y retorna lo que devuelva
   */
  public abstract function execute($statement, $mode = Connection::TR_DEFAULT)
  ;
  /**
   * Ejecuta una funcin en la base de datos y retorna el valor.
   * Es posible, indicar la variable en la cual queremos bindear el resultado, su tipo y tamao en caso de ser necesario. Si la misma no se especifica se utiliza un valor interno y se retorna una copia del valor del resultado.-
   */
  public abstract function executeFunction($name, &$params, &$result = null, $type = Connection::T_VARCHAR, $size = -1)
  ;
  /**
   * Ejecuta el procedimiento bindeando los valores de los parmetros en el orden en que se encuentren
   */
  public abstract function executeProcedure($name, &$params)
  ;
  /**
   * Restorna una fila del conjunto de resultados en un arreglo indexado como se indique en $mode y avanza una posicin el cursor del $resource
   */
  public abstract function fetch($resource, $mode = Connection::M_ASSOCIATIVE)
  ;
  /**
   * Retorna un arreglo con los registros recuperados de la consulta. Se provee la facilidad de indicar que se saltee tantos registros como se indiquen en $offest y que se recuperen slo una cierta cantidad de ellos; se una -1 en caso de querer recuperar todas las filas disponibles desde $offset.
   * En forma predeterminada retorna un arreglo asociativo, lo cual puede cambiarse con el parmetro $mode.
   */
  public abstract function fetchAll($resource, $mode = Connection::M_ASSOCIATIVE, $offset = 0, $count = -1)
  ;
  /**
   * Libera un recurso previamente asignado.
   */
  public abstract function free(&$resource)
  ;
  /**
   * Retorna true si la conexin est activa o false en caso contrario
   */
  public abstract function isConnected()
  ;
  /**
   * Retorna un texto que describe el ltimo error que sucedi en la conexin. Si se desea se puede acompaar del handler que retorno la funcin que fall o de lo contrario se retorna el ltimo error que se dio en la conexin.
   */
  public abstract function lastError($over = -1)
  ;
  /**
   * Retorna el cdigo del ltimo error que se present en la conexin o en el handler del parmetro
   */
  public abstract function lastErrorCode($over = -1)
  ;
  /**
   * Salta al siguiente conjunto de resultados
   */
  public abstract function nextResultset($handler)
  ;
  /**
   * Retorna el nmero de columnas del handler del query especificado
   */
  public abstract function numColumns($query)
  ;
  /**
   * Retorna el nmero de filas que devolvi el query especificado
   */
  public abstract function numRows($query)
  ;
  /**
   * Retorna un handler a un prepared statement
   */
  public abstract function prepareStatement($sql)
  ;
  /**
   * Ejecuta la instruccin SQL y retorna el resultado.
   */
  public abstract function query($sql)
  ;
  /**
   * Si el motor de la base de datos lo soporta, hace un rollback de la ltima transaccin
   */
  public abstract function rollback()
  ;
  /**
   * Retorna la informacin de status del motor
   */
  public abstract function status()
  ;
  /**
   * Cierra la conexin antes de destruir el objeto
   */
  public function __destruct()
  {
if ($this->isConnected()) {
    $this->close();
}
  }

}
?>