<?php

ini_set("session.use_cookies", "0");
ini_set("soap.wsdl_cache_enabled", "0");

session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";
require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
require_once "iplan/models/provisioning/passwords/PasswordsFunctions.php";

$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
$_SESSION['uws_domain_id']  = 1;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
//$_SESSION['uws_user_id']    = 1;//141=Admin Wholesale ; 101=Admin Localhostero

chdir("iplan/models/provisioning/");
require_once 'LogMessages.php';
chdir("../../../");


$application = Application::getInstance();
$orm = $application->getORM();
	
//Traigo la Conexion
$dbconn = $orm->getDatabase()->getConnection();
//Traigo el usuario q ejecuta los packages
$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
//Traigo la instancia de LOG
$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_WSP);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();


$proceso_id = null;
$params = array("p_user_id" => (int)$userEjecutaPackages, "p_estado" => 3);
$result = null;
$lala = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
$asd = $dbconn->fetch($lala);
$dbconn->free($lala);
if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
	$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
	//return new SoapFault("Server", "Hubo un error al procesar el pedido", "Server", "El servicio no puede generar un registro de proceso para la operación");
} else {
	$proceso_id = $asd["LASTID"];
}

//Obtengo el ID que hizo el GET
$verif_id = $_GET["id"];

$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Remote Address: " . getIp(), null, $proceso_id);
$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "ServerName: " . $_SERVER["SERVER_NAME"], null, $proceso_id);
$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Operación ConfirmReset id: [$verif_id]", null, $proceso_id);

/* Obtengo los datos del confirm file */
$aDatos = verificarConfirmFile($verif_id);

$aParams = array();
if (!$aDatos) {
	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 7, "No existe la operación id: [$verif_id]", null, $proceso_id);
	$aParams["error_reset"] = true;
} else {
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Operación verificada.", null, $proceso_id);
	$completo = false;
	try {
		switch ($_SERVER["SERVER_NAME"]) {
			case "ws.centralvirtual.iplantech.com.ar":
				$res_ResetPassword = resetPassword($aDatos["linea"], $aDatos["email"], $aDatos["tipo_reset"]);
				break;
			case "gadget.centralvirtual.iplantech.com.ar":
				$res_ResetPassword = resetPassword_iplan($aDatos["linea"], $aDatos["email"], $aDatos["tipo_reset"]);
				break;
		}
		if (is_a($res_ResetPassword, "Exception"))
			throw $res_ResetPassword;
		$completo = true;
	} catch (SoapFault $sf) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 6, "Fault: " . $sf->faultcode . " - " . $sf->faultstring, null, $proceso_id);
		$aParams["error_fatal"] = true;
		$aParams["error_desc"] = $sf->faultstring;
	} catch (Exception $e) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 6, "Exception: " . $e->getCode() . " - " . $e->getMessage(), null, $proceso_id);
		$aParams["error_fatal"] = true;
		$aParams["error_desc"] = $e->getMessage();
	}
	if ($completo) {
		$aParams["error_reset"] = false;
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Password reseteado correctamente", null, $proceso_id);
		deleteConfirmFile($verif_id);
		$aParams["email"] = $aDatos["email"];
		$aParams["usuario_text"] = $aDatos["usuario_text"];
	}
}

$template = $application->parse("lib/password_confirmation.xhtml", $aParams);

echo $template;

?>