<?php

/*
 * Creado el 07/02/2013
 * @author Federico Bernoldi
 * 
 * Applicación cliente para autoaprovisionar los servicios
 */

session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";
require_once "iplan/models/provisioning/ProvisioningPlataformas.php";

//echo "Archivos requeridos OK\n";

date_default_timezone_set('America/Buenos_Aires');

error_reporting(E_ALL);
//Acá hacer un manejador de excepciones

/**
 * Defino las constantes de provider y user de ejecución.
 */
$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
$_SESSION['uws_domain_id']  = 1;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
$_SESSION['uws_user_id']    = 1;//1=Admin Wholesale ; 3=Admin Localhostero

$file_exec = array_shift($argv);
$provisioning_param = array_shift($argv);

$myPID = getmypid();

switch ($provisioning_param) {
	case ProvisioningPlataformas::CENTRAL_VIRTUAL:
		$action_execute = "AutoProvisioning.provisioningCVI";
		break;
	case ProvisioningPlataformas::GOOGLE_APPS:
		$action_execute = "GoogleApps.aprovisionar";
		break;
	case ProvisioningPlataformas::TELEFONIA:
		$action_execute = "AutoProvisioning.provisioningTel";
		break;
	case ProvisioningPlataformas::SUSPENSIONES:
		$action_execute = "AutoProvisioning.provisioningSus";
		break;
	case ProvisioningPlataformas::FAX_IPLAN:
		$action_execute = "AutoProvisioning.provisioningFaxIPLAN";
		break;
	case ProvisioningPlataformas::SERVIDORES_VIRTUALES:
		$action_execute = "AutoProvisioning.provisioningServ";
		break;
	case ProvisioningPlataformas::ESB_CHECKER:
	case false:
		$provisioning_param = ProvisioningPlataformas::ESB_CHECKER;
		$action_execute = "AutoProvisioning.esbCheck";
		break;
	default:
		echo date("c") . " | PID: [$myPID] - No se encuentra configurado un provisioining para el sistema [$provisioning_param]";
		break;
}

echo date("c") . " | PID: [$myPID] - Inicio Thread [" . ProvisioningPlataformas::$aDescripcionesSistemas[$provisioning_param] . "]...\n";
echo date("c") . " | PID: [$myPID] - Preparo la aplicación...\n";
$application = Application::getInstance();
echo date("c") . " | PID: [$myPID] - Instanciada la aplicación.\n";
echo date("c") . " | PID: [$myPID] - Ejecutando $action_execute...\n";
echo date("c") . " | PID: [$myPID] - Retorno [".$application->execute($action_execute)."]\n";
echo date("c") . " | PID: [$myPID] - Fin\n";


?>
