<?php

/*
 * Creado el 18-04-2012
 * @author Jorge Alexis Viqueira
 * 
 * Applicación cliente para autoaprovisionar el servicio de GoogleApps
 */

session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";

echo "Archivos requeridos OK\n";

error_reporting(E_ALL);
//Acá hacer un manejador de excepciones
$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
$_SESSION['uws_domain_id']  = 2;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
$_SESSION['uws_user_id']    = 1;//141=Admin Wholesale ; 101=Admin Localhostero

$application = Application::getInstance();
echo "Instanciada la aplicación OK\n";

chdir("iplan/models/provisioning/");
require_once 'LogMessages.php';
chdir("../../../");
echo "Requeridos archivos de log OK\n";


//Datos de Conexión a Maqueta
$connRead = new OracleConnection("ADMIN_IUNI", "wholesale2010", "SSWMC");
$connRead->connect();
$ormMaqueta = new ORM();
$ormMaqueta->setLanguage('EN');
$ormMaqueta->setDatabase(new OracleDatabase($connRead));

//Datos de Conexión a Produccion
/*$connRead = new OracleConnection("ADMIN_IUNI", "wholesale2010", "AUTOPROPDB");
$connRead->connect();
$ormMaqueta = new ORM();
$ormMaqueta->setLanguage('EN');
$ormMaqueta->setDatabase(new OracleDatabase($connRead));*/

/* Preparo donde voy a loguear */

$log = LogMessages::GetInstance($connRead, $_SESSION['uws_user_id'], LogMessages::SYS_CA);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();
//Logueo el Inicio de las pruebas
set_error_handler("miGestorErrores");



/* Migración de Usuarios */

// Cargo de Usuarios Activos
$sql = "SELECT PERFIL_ID, NOMBRE, MAIL, USUARIO, PASSWORD 
		FROM USUARIO where perfil_id in (1, 2) 
			AND fe_baja is null 
			AND usuario != 'admin' 
			AND usuario != 'pruebaps' ";
$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Consulto Usuarios [$sql]");
$statement = $connRead->prepareStatement($sql);
$connRead->execute($statement);
$aUsuariosMigrar = $connRead->fetchAll($statement);

//Busco el Provider IPLAN
$oProviderIplan = $ormMaqueta->query("Provider")->filterBy("id", "=", $_SESSION['uws_provider_id'])->findOne();
$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Provider Consultado [" . $oProviderIplan->getName() . "]");

$oPerfilesBasicos = array();
$oPerfilesBasicos = $ormMaqueta->query("Profile")
								->filterBy("name", "IN", 
								array("Usuarios Registrados - iPlan", "Implementaciones Básico", "Provisioning Teléfonos",
										"Provisioning Routers", "Vista Central Virtual", "Vista Telefonía"))
								->find();

$oPerfilAdmin = $ormMaqueta->query("Profile")->filterBy("name", "=", "Aministrador de Implementaciones")->findOne();

$cant = 0;
foreach ($aUsuariosMigrar as $usuario) {
	
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Proceso Usuario [" . $usuario["USUARIO"] . "]");
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Mail [" . $usuario["MAIL"] . "]");
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Nombre [" . $usuario["NOMBRE"] . "]");
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Perfil [" . $usuario["PERFIL_ID"] . "]");
	
	$oUserNuevo = new User();
	$oUserNuevo->setLoginUnificado(false);
	$oUserNuevo->setMail($usuario["MAIL"]);
	$oUserNuevo->setName($usuario["NOMBRE"]);
	$oUserNuevo->setProvider($oProviderIplan);
	$oUserNuevo->setUsername($usuario["USUARIO"]);
	$oUserNuevo->setPassword(sha1($usuario["PASSWORD"]));
	$oUserNuevo->setForcePasswordChange(false);
	
	switch ($usuario["PERFIL_ID"]){
		case "2":
			//Caso Administrador
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Perfil usuario administrador agregado [" . $oPerfilAdmin->getName() . "]");
			$oUserNuevo->addProfile($oPerfilAdmin);
		case "1":
			//Caso Implementador
			foreach ($oPerfilesBasicos as $oPerfilBasico) {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Perfil usuario implementador agregado [" . $oPerfilBasico->getName() . "]");
				$oUserNuevo->addProfile($oPerfilBasico);
			}
			break;
	}
	try {
		$oUserNuevo->save($ormMaqueta);
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Usuario guardado correctamente");
		$cant++;
	} catch (Exception $e) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Fallo al guardar usuario.");
	}
	
}
$log->closeLog();
echo "\n\nUsuarios Migrados: [$cant]\n";
echo "Fin xd\n";

?>
