<?php

/*
 * @author Federico Bernoldi
 * 
 * Web Service de Fax Server, para cambio de password y usuario en BS y XMedius
 * 
 */


ini_set("session.use_cookies", "0");
session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";
require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
require_once "iplan/models/provisioning/webservicestools/WSTools.php";
require_once "iplan/models/provisioning/xmedius/FaxServerServiceFunctions.php";

$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
$_SESSION['uws_domain_id']  = 1;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
//$_SESSION['uws_user_id']    = 1;//141=Admin Wholesale ; 101=Admin Localhostero

chdir("iplan/models/provisioning/");
require_once 'LogMessages.php';
chdir("../../../");

$application = Application::getInstance();
$context = $application->getContext();
$orm = $application->getORM();
	
//Traigo la Conexion
$dbconn = $orm->getDatabase()->getConnection();
//Traigo el usuario q ejecuta los packages
$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
//Traigo la instancia de LOG
$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_WSF);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();

try {
	$proceso_id = GenerarProceso($dbconn, $userEjecutaPackages, LogMessages::SYS_CASV);
} catch (SoapFault $sf) {
	throw $sf;
}

$_SESSION["WS_PROCESO_ID"] = $proceso_id;
$_SESSION["WS_USER_EJECUTA_PACKAGES"] = $userEjecutaPackages;

//$rsc = fopen("tmp/AvamarService.log", "a+");

$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Remote Address: " . $_SERVER['REMOTE_ADDR']);

$headers = apache_request_headers();
if ($headers) {
	foreach($headers as $key => $header) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Header - $key: $header");
	}
}

/* Capturo el request */
$request = file_get_contents("php://input");

/* Creo el objeto de plataformas */
$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, null, null);

/* Guardo el mensaje de request */
$servicePlataformas->saveLastXMLMessages(array("33" => $request));

/* Creo el Servicio */
$server = new SOAPServer("services/faxserver/FaxServerService.wsdl");

/* Agrego las funciones que procesa */
$server->addFunction(array("AuthHeader", "ModifyUser"));

/* Capturo la salida */
ob_start();

/* Proceso el Web Service */
$server->handle();

/* Guardo la salida */
$servicePlataformas->saveLastXMLMessages(array("34" => ob_get_contents()));

/* Sigo como si nada hubiera sido capturado */
ob_end_flush();

?>