<?php

/*
 * @author Federico Bernoldi
 * 
 * Web Service para modificación de passwords de BS y teléfonos.
 */

ini_set("session.use_cookies", "0");
ini_set("soap.wsdl_cache_enabled", "0");

session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";
require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
require_once 'iplan/models/provisioning/ProvisioningManager.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
require_once "iplan/models/provisioning/webservicestools/WSTools.php";
require_once "iplan/models/provisioning/passwords/PasswordsFunctions.php";

$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
$_SESSION['uws_domain_id']  = 1;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
//$_SESSION['uws_user_id']    = 1;//141=Admin Wholesale ; 101=Admin Localhostero

chdir("iplan/models/provisioning/");
require_once 'LogMessages.php';
chdir("../../../");


$application = Application::getInstance();
$orm = $application->getORM();
	
//Traigo la Conexion
$dbconn = $orm->getDatabase()->getConnection();
//Traigo el usuario q ejecuta los packages
$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
//Traigo la instancia de LOG
$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_WSP);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();

try {
	$proceso_id = GenerarProceso($dbconn, $userEjecutaPackages, LogMessages::SYS_CASV);
} catch (SoapFault $sf) {
	throw $sf;
}

$_SESSION["WS_PROCESO_ID"] = $proceso_id;
$_SESSION["WS_USER_EJECUTA_PACKAGES"] = $userEjecutaPackages;

$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Remote Address: " . getIp(), null, $proceso_id);

$headers = apache_request_headers();
if ($headers) {
	foreach($headers as $key => $header) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Header - $key: $header");
	}
}

/* Capturo el request */
$request = file_get_contents("php://input");

/* Creo el objeto de plataformas */
$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, null, null);

/* Guardo el mensaje de request */
$servicePlataformas->saveLastXMLMessages(array("31" => $request));

/* Creo el Servicio */
$server = new SoapServer('services/broadsoft/Tools.wsdl',  array('soap_version' => SOAP_1_2));

/* Agrego las funciones que procesa */
$server->addFunction( 
		array(	/*'resetPassword', // Quitado por seguridad */ 
				'resetPasswordSIPConfirm',
				'resetPasswordPortalConfirm',
				'resetPasswordGroupAdminConfirm',
				'isAutoprovisionedLine',
				'setUserVoicemail',
				'getUserVoicemail',
				'addDefaultCallNotifycation',
				'getUserByExtension',
				'getUserByLastName',
				'getUserByMail') //Para autenticar agregar: "AuthHeader"
		);

/* Capturo la salida */
ob_start();

/* Proceso el Web Service */
$server->handle();

/* Guardo la salida */
$servicePlataformas->saveLastXMLMessages(array("32" => ob_get_contents()));

/* Sigo como si nada hubiera sido capturado */
ob_end_flush();

?>