<?php

/*
 * @author Federico Bernoldi
 * 
 * Servicio WEB de Avamar
 * 
 */


function getEmailBySubscription($pedido) {
	ini_set("session.use_cookies", "0");
	session_start();
	require_once 'retro_functions.php';
	require_once 'lib/Twig/Autoloader.php';
	require_once 'lib/krumo/class.krumo.php';
	Twig_Autoloader::register();
	require_once "iplan/security/Application.php";

	$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
	$_SESSION['uws_domain_id']  = 1;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
	//$_SESSION['uws_user_id']    = 1;//141=Admin Wholesale ; 101=Admin Localhostero

	chdir("iplan/models/provisioning/");
	require_once 'LogMessages.php';
	chdir("../../../");

	$application = Application::getInstance();
	$context = $application->getContext();
	$orm = $application->getORM();
	
	$context->set("username", $pedido->username);
	$context->set("password", $pedido->password);
	
	$log = $application->execute("Security.login");
	$context = $application->getContext();
	$errores = $context->get("errors");
	
	
	//Error de Sistema
	if (!is_a($log, "Renderable")) return new SoapFault("Server", "Hubo un error al procesar la autenticación", "Server", "No se recibió la respuesta esperada" , "NormalFault");
	
	$aErrors = array();
	if (is_array($errores) && isset($errores['messages'])) {
		if (is_array($errores['messages']))	{
			for ($i = 0; $i < count($errores['messages']); $i++) {
				if ($errores['messages'][$i]['descriptions']) $aErrors[] = $errores['messages'][$i]['descriptions'];
			}
		}
	}
	$desc_errores = implode("|", $aErrors);
	
	if ($desc_errores) {
		return new SoapFault("Client", "Fallo al autenticar el usuario", "Server", array("codigo"=>"1001", "descripcion" => $desc_errores), "ExtendedFault");
	}
	
	$context->set("suscription", $pedido->subscription);
	
	$email = "";
	try {
		$oRenderable = $application->execute("Backup.getMailBySuscription");
		if (is_a($oRenderable, "Renderable")) {
			$email = $oRenderable->getContent();
		} else {
			return new SoapFault("Server", "Hubo un error al procesar la suscripción", "Server", "No se recibió la respuesta esperada", "NormalFault");
		}
	} catch (Exception $e) {
		return new SoapFault("Client", "Error en la suscripción", null, array("codigo" => $e->getCode(), "descripcion" => $e->getMessage()), "ExtendedFault");
	}
	
	/*	
	 * $pedido->username
	 * $pedido->password
	 * 
	*/
	
   session_write_close();
	
	return $email;
}

$rsc = fopen("tmp/AvamarService.log", "a+");

fwrite($rsc, "\n\nRemote Address: " . $_SERVER["REMOTE_ADDR "] . "\n\n");
$headers = apache_request_headers();
if ($headers) {
	foreach($headers as $key => $header) {
		fwrite($rsc, "$key:$header\n");
	}
}
fwrite($rsc, "\n\n".file_get_contents("php://input") . "\n------------------------\n");
fclose($rsc);

$server = new SOAPServer("services/avamar/AvamarService.wsdl");

$server->addFunction("getEmailBySubscription");

try {
$server->handle();
} catch (Exception $e) {
    $rsc = fopen("tmp/AvamarService.log", "a+");
    fwrite($e->getMessage());
    fclose($rsc);
}


?>
