/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.commons.csv.mapper.ognl;

import com.interstarinc.commons.csv.mapper.CsvRecord;
import com.interstarinc.commons.csv.mapper.DefaultColumnPropertyMapping;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class OgnlColumnPropertyMapping
extends DefaultColumnPropertyMapping {
    private Object expression;

    public OgnlColumnPropertyMapping(String property, String mappedValue) throws OgnlException {
        super(property, mappedValue);
        if (mappedValue.startsWith("${")) {
            mappedValue = mappedValue.substring(2, mappedValue.lastIndexOf("}"));
            this.expression = Ognl.parseExpression((String)mappedValue);
        }
    }

    public Object getExpression() {
        return this.expression;
    }

    public Object getPropertyValue(CsvRecord record) {
        if (this.expression != null) {
            try {
                return (String)Ognl.getValue((Object)this.expression, (Map)new OgnlContext(), (Object)record);
            }
            catch (OgnlException e) {
                return null;
            }
        }
        return super.getPropertyValue(record);
    }
}

