/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.commons.csv.mapper;

import com.interstarinc.commons.csv.mapper.ColumnPropertyMapping;
import com.interstarinc.commons.csv.mapper.CsvRecord;
import com.interstarinc.commons.csv.mapper.DefaultColumnPropertyMapping;
import com.interstarinc.commons.csv.mapper.StringCsvValue;
import com.interstarinc.commons.iterator.Mapper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCsvMapper
implements Mapper<String[], CsvRecord> {
    protected HashMap<String, ColumnPropertyMapping> mappings;
    protected ArrayList<String> headers;

    public DefaultCsvMapper(String[] headers, Properties mapping) throws ParseException {
        this.setHeaders(headers);
        this.setMappings(mapping);
    }

    protected void setMappings(Properties mapping) throws ParseException {
        this.mappings = new HashMap();
        Enumeration<?> properties = mapping.propertyNames();
        while (properties.hasMoreElements()) {
            String property = (String)properties.nextElement();
            String mappedValue = mapping.getProperty(property);
            if (mappedValue == null || mappedValue.length() == 0) continue;
            this.mappings.put(property, new DefaultColumnPropertyMapping(property, mappedValue));
        }
    }

    protected void setHeaders(String[] headers) throws ParseException {
        if (headers == null || headers.length == 0) {
            throw new ParseException("The header is invalid", 0);
        }
        this.headers = new ArrayList();
        for (int index = 0; index < headers.length; ++index) {
            this.headers.add(headers[index].trim());
        }
    }

    public ColumnPropertyMapping getMapping(String property) {
        return this.mappings.get(property);
    }

    public ArrayList<String> getHeaders() {
        return this.headers;
    }

    public ArrayList<String> getProperties() {
        return new ArrayList<String>(this.mappings.keySet());
    }

    @Override
    public CsvRecord map(String[] columns) {
        CsvRecord record = new CsvRecord(this);
        for (int index = 0; index < columns.length && index < this.headers.size(); ++index) {
            String column = columns[index].trim();
            String header = this.headers.get(index);
            record.setColumn(header, new StringCsvValue(header, column));
        }
        return record;
    }
}

