/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.commons.csv.mapper;

import com.interstarinc.commons.csv.mapper.ColumnPropertyMapping;
import com.interstarinc.commons.csv.mapper.CsvValue;
import com.interstarinc.commons.csv.mapper.DefaultCsvMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvRecord {
    private DefaultCsvMapper mapper;
    private HashMap<String, CsvValue<?>> columns = new HashMap();

    public CsvRecord(DefaultCsvMapper mapper) {
        this.mapper = mapper;
    }

    public List<CsvValue<?>> getColumns() {
        return new ArrayList(this.columns.values());
    }

    public CsvValue<?> getColumn(String header) {
        CsvValue<?> value = this.columns.get(header);
        if (value == null) {
            throw new NullPointerException(header);
        }
        return value;
    }

    public void setColumn(String header, CsvValue<?> column) {
        this.columns.put(header, column);
    }

    public Object getProperty(String property) {
        ColumnPropertyMapping columnProperty = this.mapper.getMapping(property);
        try {
            return columnProperty.getPropertyValue(this);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ArrayList<String> getProperties() {
        return this.mapper.getProperties();
    }
}

