/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.commons.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvReader
implements Iterator<String[]> {
    private static Logger logger = Logger.getLogger(CsvReader.class.getName());
    public static final String DELIMITERS = ";,\t";
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    private char quotechar = (char)34;
    private BufferedReader reader;
    private String[] buffer;
    private IOException exception;
    private char delimiter = (char)44;

    public CsvReader(InputStream input, String encoding) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(input, encoding));
        String firstLine = this.reader.readLine();
        this.setDelimiter(firstLine);
        this.buffer = this.parseLine(firstLine);
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.assertState();
        String[] result = (String[])this.buffer.clone();
        try {
            this.buffer = this.parseLine(this.reader.readLine());
        }
        catch (IOException e) {
            this.exception = e;
        }
        return result;
    }

    private void assertState() {
        if (this.exception != null) {
            logger.log(Level.INFO, "An error occurred during reading the input", this.exception);
            throw new NoSuchElementException(this.exception.getMessage());
        }
    }

    private String[] parseLine(String nextLine) throws IOException {
        if (nextLine == null) {
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        do {
            if (inQuotes) {
                sb.append("\n");
                nextLine = this.reader.readLine();
                if (nextLine == null) break;
            }
            for (int i = 0; i < nextLine.length(); ++i) {
                char c = nextLine.charAt(i);
                if (c == this.quotechar) {
                    if (inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar) {
                        sb.append(nextLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    boolean bl = inQuotes = !inQuotes;
                    if (i <= 2 || nextLine.charAt(i - 1) == this.delimiter || nextLine.length() <= i + 1 || nextLine.charAt(i + 1) == this.delimiter) continue;
                    sb.append(c);
                    continue;
                }
                if (c == this.delimiter && !inQuotes) {
                    tokensOnThisLine.add(sb.toString());
                    sb = new StringBuffer();
                    continue;
                }
                sb.append(c);
            }
        } while (inQuotes);
        tokensOnThisLine.add(sb.toString());
        return tokensOnThisLine.toArray(new String[0]);
    }

    private void setDelimiter(String header) {
        for (int i = 0; i < DELIMITERS.length(); ++i) {
            char c = DELIMITERS.charAt(i);
            if (header.indexOf(c) == -1) continue;
            this.delimiter = c;
            break;
        }
    }
}

