/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class Network {
    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
            if (!localHost.isLoopbackAddress()) {
                return localHost;
            }
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        Enumeration<NetworkInterface> netinterfaces = null;
        try {
            netinterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("Unable to retrieve address for local host");
        }
        InetAddress IPV6Address = null;
        while (netinterfaces.hasMoreElements()) {
            NetworkInterface nextint = netinterfaces.nextElement();
            Enumeration<InetAddress> netaddresses = nextint.getInetAddresses();
            while (netaddresses.hasMoreElements()) {
                InetAddress address = netaddresses.nextElement();
                if (!address.isLoopbackAddress()) {
                    if (!(address instanceof Inet4Address)) continue;
                    return address;
                }
                IPV6Address = address;
            }
        }
        if (IPV6Address != null) {
            return IPV6Address;
        }
        throw new UnknownHostException("Unable to retrieve address for local host");
    }
}

