/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transport;

import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.transport.Current;
import org.jacorb.transport.DefaultStatisticsProvider;
import org.jacorb.transport.NoContext;
import org.omg.CORBA.LocalObject;

public class DefaultCurrentImpl
extends LocalObject
implements Current,
TransportListener,
Configurable {
    private int statistics_provider_index_ = -1;
    private static final ThreadLocal tss_transport_event_ = new ThreadLocal();
    private Logger logger_;

    public void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration cfg = (org.jacorb.config.Configuration)configuration;
        this.logger_ = cfg.getNamedLogger("jacorb.transport.current");
        List statsProviderClassNames = cfg.getAttributeList("jacorb.connection.statistics_providers");
        statsProviderClassNames.add(DefaultStatisticsProvider.class.getName());
        StringBuffer buff = new StringBuffer();
        Iterator iter = statsProviderClassNames.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (!iter.hasNext()) continue;
            buff.append(',');
        }
        cfg.setAttribute("jacorb.connection.statistics_providers", buff.toString());
        this.statistics_provider_index_ = statsProviderClassNames.size() - 1;
    }

    public void transportSelected(TransportListener.Event event) {
        tss_transport_event_.set(event);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Transport selected " + event);
        }
    }

    protected TransportListener.Event getLatestTransportCurentEvent() throws NoContext {
        TransportListener.Event e = (TransportListener.Event)tss_transport_event_.get();
        if (e == null) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("No events were available. Is traits() called outside of an upcall or interceptor?");
            }
            throw new NoContext();
        }
        return e;
    }

    public int id() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        return e.hashCode();
    }

    public long bytes_sent() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.bytes_sent_;
    }

    public long bytes_received() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.bytes_received_;
    }

    public long messages_sent() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.messages_sent_;
    }

    public long messages_received() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.messages_received_;
    }

    public long open_since() throws NoContext {
        TransportListener.Event e = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider p = (DefaultStatisticsProvider)e.getStatisticsProvider(this.statistics_provider_index_);
        return p.created_;
    }
}

