/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.security.ssl.sun_jsse.DefaultKeyStoreLoader;
import org.jacorb.security.ssl.sun_jsse.JSSEUtil;
import org.jacorb.security.ssl.sun_jsse.KeyStoreLoader;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;

public class SSLSocketFactory
extends AbstractSocketFactory {
    private SocketFactory factory = null;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private boolean trusteesFromKS = false;
    private short clientSupportedOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private final SSLSessionListener sslListener;
    private SSLRandom sslRandom;
    private KeyStoreLoader keystore_loader = null;

    public SSLSocketFactory(ORB orb) {
        this.sslListener = orb.getTransportManager().getSocketFactoryManager().getSSLListener();
        this.keystore_loader = new DefaultKeyStoreLoader();
    }

    public SSLSocketFactory(ORB orb, KeyStoreLoader keystore_loader) {
        this.sslListener = orb.getTransportManager().getSocketFactoryManager().getSSLListener();
        this.keystore_loader = keystore_loader;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        StringTokenizer tokenizer;
        int tokens;
        block8: {
            super.configure(configuration);
            this.sslRandom = new SSLRandom();
            this.sslRandom.configure(configuration);
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore", "UNSET");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password", "UNSET");
            this.clientSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.client.supported_options", "0"), 16);
            try {
                this.trustManager = (TrustManager)((org.jacorb.config.Configuration)configuration).getAttributeAsObject("jacorb.security.ssl.client.trust_manager");
            }
            catch (ConfigurationException e) {
                if (!this.logger.isErrorEnabled()) break block8;
                this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.client.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.client.trust_manager", ""), e);
            }
        }
        if (JSSEUtil.isJDK14() && configuration.getAttribute("jacorb.security.ssl.client.protocols", null) != null) {
            this.enabledProtocols = (String[])((org.jacorb.config.Configuration)configuration).getAttributeList("jacorb.security.ssl.client.protocols").toArray();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified client enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.client.protocols", ""));
            }
        }
        try {
            this.factory = this.createSocketFactory();
        }
        catch (Exception e) {
            this.logger.error("Unable to create SSLSocketFactory!", e);
            throw new ConfigurationException("Unable to create SSLSocketFactory!", e);
        }
        String cipher_suite_list = configuration.getAttribute("jacorb.security.ssl.server.cipher_suites", null);
        if (cipher_suite_list != null && (tokens = (tokenizer = new StringTokenizer(cipher_suite_list, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[tokens];
            while (tokenizer.hasMoreElements()) {
                this.cipher_suites[--tokens] = tokenizer.nextToken();
            }
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port);
        this.initSSLSocket(socket);
        return socket;
    }

    public Socket doCreateSocket(String host, int port, int timeout) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket();
        socket.connect(new InetSocketAddress(host, port), timeout);
        this.initSSLSocket(socket);
        return socket;
    }

    private void initSSLSocket(SSLSocket socket) {
        if (this.cipher_suites != null) {
            socket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            JSSEUtil.setEnabledProtocols(socket, this.enabledProtocols);
        }
        socket.addHandshakeCompletedListener(new SSLHandshakeListener(this.logger, this.sslListener));
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        JSSEUtil.registerSecurityProvider();
        KeyManagerFactory kmf = null;
        KeyStore key_store = null;
        if (this.trusteesFromKS || (this.clientSupportedOptions & 0x40) != 0) {
            key_store = this.keystore_loader.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray());
            if ((this.clientSupportedOptions & 0x40) != 0) {
                kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(key_store, this.keystore_passphrase.toCharArray());
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        if (key_store != null && this.trusteesFromKS) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading certs from keystore " + key_store.getType());
            }
            tmf.init(key_store);
        } else {
            tmf.init((KeyStore)null);
        }
        if (this.trustManager == null) {
            trustManagers = tmf.getTrustManagers();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified client TrustManger : " + this.trustManager.getClass().getName());
            }
            trustManagers = new TrustManager[]{this.trustManager};
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf == null ? null : kmf.getKeyManagers(), trustManagers, this.sslRandom.getSecureRandom());
        return ctx.getSocketFactory();
    }
}

