/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.SASComponentInterceptor;
import org.jacorb.security.sas.ATLASPolicyFactory;
import org.jacorb.security.sas.SASClientInterceptor;
import org.jacorb.security.sas.SASPolicyFactory;
import org.jacorb.security.sas.SASTargetInterceptor;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class SASInitializer
extends LocalObject
implements ORBInitializer {
    private Logger logger = null;
    public static final int SecurityAttributeService = 15;
    public static int sasPrincipalNamePIC = -1;

    public void post_init(ORBInitInfo info) {
        block16: {
            block15: {
                block14: {
                    ORB orb = ((ORBInitInfoImpl)info).getORB();
                    this.logger = orb.getConfiguration().getNamedLogger("jacorb.security.SAS");
                    try {
                        sasPrincipalNamePIC = info.allocate_slot_id();
                        info.add_server_request_interceptor(new SASTargetInterceptor(info));
                    }
                    catch (ConfigurationException ce) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("ConfigurationException", ce);
                        }
                    }
                    catch (DuplicateName duplicateName) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("TSS DuplicateName", duplicateName);
                        }
                    }
                    catch (UnknownEncoding unknownEncoding) {
                        if (!this.logger.isErrorEnabled()) break block14;
                        this.logger.error("TSS UnknownEncoding", unknownEncoding);
                    }
                }
                try {
                    info.add_client_request_interceptor(new SASClientInterceptor(info));
                }
                catch (ConfigurationException ce) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("ConfigurationException", ce);
                    }
                }
                catch (DuplicateName duplicateName) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("CSS DuplicateName", duplicateName);
                    }
                }
                catch (UnknownEncoding unknownEncoding) {
                    if (!this.logger.isErrorEnabled()) break block15;
                    this.logger.error("CSS UnknownEncoding", unknownEncoding);
                }
            }
            try {
                info.add_ior_interceptor(new SASComponentInterceptor(info));
            }
            catch (DuplicateName duplicateName) {
                if (!this.logger.isErrorEnabled()) break block16;
                this.logger.error("IOR DuplicateName", duplicateName);
            }
        }
        info.register_policy_factory(102, new SASPolicyFactory());
        info.register_policy_factory(103, new ATLASPolicyFactory());
    }

    public void pre_init(ORBInitInfo info) {
    }
}

