/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.poa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import org.jacorb.poa.gui.POAMonitorController;
import org.jacorb.poa.gui.POAMonitorView;
import org.jacorb.poa.gui.beans.CloseButtonPanel;
import org.jacorb.poa.gui.beans.CloseButtonPanelController;
import org.jacorb.poa.gui.beans.ConsolePanel;
import org.jacorb.poa.gui.beans.DoubleListDialog;
import org.jacorb.poa.gui.beans.FillLevelBar;
import org.jacorb.poa.gui.beans.MessageDialog;
import org.jacorb.poa.gui.poa.DetailsButtonController;
import org.jacorb.poa.gui.poa.ObjectListItem;
import org.jacorb.poa.gui.poa.ObjectListItemController;
import org.jacorb.poa.gui.poa.POAStatePanel;
import org.jacorb.poa.gui.poa.QueueListItem;
import org.jacorb.poa.gui.poa.QueueListItemController;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;

public class POAFrame
extends Frame
implements CloseButtonPanelController,
DetailsButtonController,
ObjectListItemController,
QueueListItemController,
POAMonitorView,
WindowListener {
    private POAMonitorController controller = null;
    private static Color aomBarColor = new Color(196, 196, 0);
    private static Color queueBarColor = new Color(0, 128, 128);
    private static Color activeRequestsBarColor1 = new Color(0, 128, 0);
    private static Color activeRequestsBarColor2 = new Color(128, 0, 0);
    private static Color threadPoolBarColor = new Color(0, 128, 0);
    private String poaName = "";
    private FillLevelBar aomBar = null;
    private FillLevelBar queueBar = null;
    private FillLevelBar activeRequestsBar = null;
    private FillLevelBar threadPoolBar = null;
    private Label stateLabel = null;
    private Label threadLabel = null;
    private Label lifespanLabel = null;
    private Label idUniquenessLabel = null;
    private Label idAssignmentLabel = null;
    private Label servantRetentionLabel = null;
    private Label requestProcessingLabel = null;
    private Label implicitActivationLabel = null;
    private FontMetrics fontMetrics1 = null;
    private CloseButtonPanel ivjButtonPanel = null;
    private ConsolePanel ivjConsolePanel = null;
    private Panel ivjContentsPane = null;
    private POAStatePanel ivjPOAStatePanel = null;

    public void _actionCloseButtonPressed() {
        if (this.controller != null) {
            this.controller.actionCloseView();
        }
    }

    public void _actionDeactivateObject(String oidStr) {
        if (this.controller != null) {
            this.controller.actionDeactivateObject(oidStr);
        }
    }

    public void _actionDetailsButtonPressed(String source) {
        if (source.equals("aom")) {
            this._showAOMDialog();
        } else if (source.equals("queue")) {
            this._showQueueDialog();
        } else {
            System.err.println("details unknown source: " + source);
        }
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this._actionCloseButtonPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void _destroy() {
        this.dispose();
    }

    private FontMetrics _fontMetrics1() {
        if (this.fontMetrics1 == null) {
            this.fontMetrics1 = this.getPOAStatePanel()._getPolicyPanel()._getThreadLabel().getGraphics().getFontMetrics();
        }
        return this.fontMetrics1;
    }

    private FillLevelBar _getActiveRequestsBar() {
        if (this.activeRequestsBar == null) {
            this.activeRequestsBar = this.getPOAStatePanel()._getTMPanel()._getActiveRequestsBar();
        }
        return this.activeRequestsBar;
    }

    private FillLevelBar _getAOMBar() {
        if (this.aomBar == null) {
            this.aomBar = this.getPOAStatePanel()._getAOMPanel()._getAOMBar();
        }
        return this.aomBar;
    }

    private CloseButtonPanel getButtonPanel() {
        if (this.ivjButtonPanel == null) {
            try {
                this.ivjButtonPanel = new CloseButtonPanel();
                this.ivjButtonPanel.setName("ButtonPanel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPanel;
    }

    private ConsolePanel getConsolePanel() {
        if (this.ivjConsolePanel == null) {
            try {
                this.ivjConsolePanel = new ConsolePanel();
                this.ivjConsolePanel.setName("ConsolePanel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsolePanel;
    }

    private Panel getContentsPane() {
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(new BorderLayout());
                this.ivjContentsPane.setBackground(SystemColor.control);
                this.getContentsPane().add((Component)this.getButtonPanel(), "South");
                this.getContentsPane().add((Component)this.getConsolePanel(), "Center");
                this.getContentsPane().add((Component)this.getPOAStatePanel(), "North");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjContentsPane;
    }

    private Label _getIdAssignmentLabel() {
        if (this.idAssignmentLabel == null) {
            this.idAssignmentLabel = this.getPOAStatePanel()._getPolicyPanel()._getIdAssignmentLabel();
        }
        return this.idAssignmentLabel;
    }

    private Label _getIdUniquenessLabel() {
        if (this.idUniquenessLabel == null) {
            this.idUniquenessLabel = this.getPOAStatePanel()._getPolicyPanel()._getIdUniquenessLabel();
        }
        return this.idUniquenessLabel;
    }

    private Label _getImplicitActivationLabel() {
        if (this.implicitActivationLabel == null) {
            this.implicitActivationLabel = this.getPOAStatePanel()._getPolicyPanel()._getImplicitActivationLabel();
        }
        return this.implicitActivationLabel;
    }

    private Label _getLifespanLabel() {
        if (this.lifespanLabel == null) {
            this.lifespanLabel = this.getPOAStatePanel()._getPolicyPanel()._getLifespanLabel();
        }
        return this.lifespanLabel;
    }

    private POAStatePanel getPOAStatePanel() {
        if (this.ivjPOAStatePanel == null) {
            try {
                this.ivjPOAStatePanel = new POAStatePanel();
                this.ivjPOAStatePanel.setName("POAStatePanel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPOAStatePanel;
    }

    private FillLevelBar _getQueueBar() {
        if (this.queueBar == null) {
            this.queueBar = this.getPOAStatePanel()._getQueuePanel()._getQueueBar();
        }
        return this.queueBar;
    }

    private Label _getRequestProcessingLabel() {
        if (this.requestProcessingLabel == null) {
            this.requestProcessingLabel = this.getPOAStatePanel()._getPolicyPanel()._getRequestProcessingLabel();
        }
        return this.requestProcessingLabel;
    }

    private Label _getServantRetentionLabel() {
        if (this.servantRetentionLabel == null) {
            this.servantRetentionLabel = this.getPOAStatePanel()._getPolicyPanel()._getServantRetentionLabel();
        }
        return this.servantRetentionLabel;
    }

    private Label _getStateLabel() {
        if (this.stateLabel == null) {
            this.stateLabel = this.getPOAStatePanel()._getStatePanel()._getStateLabel();
        }
        return this.stateLabel;
    }

    private Label _getThreadLabel() {
        if (this.threadLabel == null) {
            this.threadLabel = this.getPOAStatePanel()._getPolicyPanel()._getThreadLabel();
        }
        return this.threadLabel;
    }

    private FillLevelBar _getThreadPoolBar() {
        if (this.threadPoolBar == null) {
            this.threadPoolBar = this.getPOAStatePanel()._getTMPanel()._getThreadPoolBar();
        }
        return this.threadPoolBar;
    }

    private void handleException(Throwable exception) {
    }

    public void _initActiveRequestsBar(int avg, int max) {
        this._getActiveRequestsBar().init(0, avg, max, activeRequestsBarColor1, activeRequestsBarColor2, true, false);
    }

    public void _initAOMBar(int max, boolean isVariable) {
        this._getAOMBar().init(0, 0, max, aomBarColor, null, false, isVariable);
    }

    private void initConnections() {
        this.addWindowListener(this);
    }

    private void initialize() {
        this.setName("POAFrame");
        this.setLayout(new BorderLayout());
        this.setSize(698, 310);
        this.setTitle("POA Monitor");
        this.add((Component)this.getContentsPane(), "Center");
        this.initConnections();
        this.getButtonPanel()._init(this, "Close");
        this.getPOAStatePanel()._getAOMPanel()._init(this);
        this.getPOAStatePanel()._getQueuePanel()._init(this);
    }

    public void _initQueueBar(int max, boolean isVariable) {
        this._getQueueBar().init(0, 0, max, queueBarColor, null, false, isVariable);
    }

    public void _initThreadPoolBar(int max) {
        this._getThreadPoolBar().init(0, 0, max, threadPoolBarColor, null, false, false);
    }

    public void _inspectRequest(String oidStr) {
        new MessageDialog((Frame)this, "Message", "This function is not yet implemented!").setVisible(true);
    }

    public void _inspectServantClass(String oidStr) {
        new MessageDialog((Frame)this, "Message", "This function is not yet implemented!").setVisible(true);
    }

    public POAFrame(POAMonitorController _controller) {
        this.controller = _controller;
        this.initialize();
    }

    public POAFrame(String title) {
        super(title);
    }

    public static void main(String[] args) {
        try {
            POAFrame aPOAFrame = new POAFrame();
            try {
                Class<?> aCloserClass = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] parmTypes = new Class[]{Window.class};
                Object[] parms = new Object[]{aPOAFrame};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            aPOAFrame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of java.awt.Frame");
            exception.printStackTrace(System.out);
        }
    }

    public void _printMessage(String str) {
        this.getConsolePanel()._printMessage(str);
    }

    public void _removeRequest(String ridStr) {
        if (this.controller != null) {
            this.controller.actionRemoveRequestFromQueue(ridStr);
        }
    }

    public void _setMaxThreadPoolBar(int value) {
        this._getThreadPoolBar().setMaxValue(value);
    }

    public void _setName(String str) {
        this.poaName = str;
        this.setTitle(this.poaName + " Monitor (" + this._getStateLabel().getText() + ")");
    }

    public void _setPolicyIdAssignment(String str) {
        this._getIdAssignmentLabel().setText(" " + str);
    }

    public void _setPolicyIdUniqueness(String str) {
        this._getIdUniquenessLabel().setText(" " + str);
    }

    public void _setPolicyImplicitActivation(String str) {
        this._getImplicitActivationLabel().setText(" " + str);
    }

    public void _setPolicyLifespan(String str) {
        this._getLifespanLabel().setText(" " + str);
    }

    public void _setPolicyRequestProcessing(String str) {
        this._getRequestProcessingLabel().setText(" " + str);
    }

    public void _setPolicyServantRetention(String str) {
        this._getServantRetentionLabel().setText(" " + str);
    }

    public void _setPolicyThread(String str) {
        this._getThreadLabel().setText(" " + str);
    }

    public void _setState(String str) {
        this._getStateLabel().setText(str);
        this.setTitle(this.poaName + " Monitor (" + str + ")");
    }

    public void _setValueActiveRequestsBar(int value) {
        this._getActiveRequestsBar().setCurrentValue(value);
    }

    public void _setValueAOMBar(int value) {
        this._getAOMBar().setCurrentValue(value);
    }

    public void _setValueQueueBar(int value) {
        this._getQueueBar().setCurrentValue(value);
    }

    public void _setValueThreadPoolBar(int value) {
        this._getThreadPoolBar().setCurrentValue(value);
    }

    public void _setVisible(boolean visible) {
        this.setVisible(visible);
    }

    private void _showAOMDialog() {
        if (this.controller == null) {
            return;
        }
        StringPair[] data = this.controller.actionRetrieveAOMContent();
        DoubleListDialog showDialog = new DoubleListDialog((Frame)this, "Active Object Map Snapshot");
        showDialog._setHeaderLabel1("Object ID");
        showDialog._setHeaderLabel2("Servant Class");
        if (data != null) {
            int i;
            ObjectListItem[] items = new ObjectListItem[data.length];
            int firstMax = 100;
            int secondMax = 100;
            for (i = 0; i < data.length; ++i) {
                items[i] = new ObjectListItem();
                items[i]._init(this, data[i].first);
                String helpStr = POAUtil.convert(data[i].first.getBytes());
                items[i]._getFirstLabel().setText(helpStr);
                items[i]._getSecondLabel().setText(data[i].second);
                int helpInt = this._fontMetrics1().stringWidth(items[i]._getFirstLabel().getText());
                if (helpInt > firstMax) {
                    firstMax = helpInt;
                }
                if ((helpInt = this._fontMetrics1().stringWidth(items[i]._getSecondLabel().getText())) <= secondMax) continue;
                secondMax = helpInt;
            }
            showDialog._setSize(firstMax + 20, secondMax + 20);
            for (i = 0; i < data.length; ++i) {
                items[i]._setWidth(firstMax + 20, secondMax + 20);
                showDialog._addItem(items[i]);
            }
        }
        showDialog.setVisible(true);
    }

    private void _showQueueDialog() {
        if (this.controller == null) {
            return;
        }
        StringPair[] data = this.controller.actionRetrieveQueueContent();
        DoubleListDialog showDialog = new DoubleListDialog((Frame)this, "Queue Snapshot");
        showDialog._setHeaderLabel1("Request ID");
        showDialog._setHeaderLabel2("Object ID");
        if (data != null) {
            int i;
            QueueListItem[] items = new QueueListItem[data.length];
            int firstMax = 100;
            int secondMax = 100;
            for (i = 0; i < data.length; ++i) {
                items[i] = new QueueListItem();
                items[i]._init(this, data[i].first);
                items[i]._getFirstLabel().setText(data[i].first);
                String helpStr = POAUtil.convert(data[i].second.getBytes());
                items[i]._getSecondLabel().setText(helpStr);
                int helpInt = this._fontMetrics1().stringWidth(items[i]._getFirstLabel().getText());
                if (helpInt > firstMax) {
                    firstMax = helpInt;
                }
                if ((helpInt = this._fontMetrics1().stringWidth(items[i]._getSecondLabel().getText())) <= secondMax) continue;
                secondMax = helpInt;
            }
            showDialog._setSize(firstMax + 20, secondMax + 20);
            for (i = 0; i < data.length; ++i) {
                items[i]._setWidth(firstMax + 20, secondMax + 20);
                showDialog._addItem(items[i]);
            }
        }
        showDialog.setVisible(true);
    }

    public POAFrame() {
        this.initialize();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoC1(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

