/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.RequestInterceptorIterator;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.Interceptor;

public class ClientInterceptorIterator
extends RequestInterceptorIterator {
    public static final short SEND_REQUEST = 0;
    public static final short SEND_POLL = 1;
    public static final short RECEIVE_REPLY = 2;
    public static final short RECEIVE_EXCEPTION = 3;
    public static final short RECEIVE_OTHER = 4;
    private ClientRequestInfoImpl info = null;
    private final Logger logger;

    public ClientInterceptorIterator(Logger logger, Interceptor[] interceptors) {
        super(interceptors);
        this.logger = logger;
    }

    public void iterate(ClientRequestInfoImpl info, short op) throws UserException {
        this.info = info;
        this.op = op;
        this.setDirection(op == 0 || op == 1);
        this.iterate();
        if (this.interceptor_ex != null) {
            if (this.interceptor_ex instanceof ForwardRequest) {
                throw (ForwardRequest)this.interceptor_ex;
            }
            throw (SystemException)this.interceptor_ex;
        }
    }

    protected void invoke(Interceptor interceptor) throws UserException {
        this.info.caller_op = this.op;
        try {
            switch (this.op) {
                case 0: {
                    ((ClientRequestInterceptor)interceptor).send_request(this.info);
                    break;
                }
                case 1: {
                    ((ClientRequestInterceptor)interceptor).send_poll(this.info);
                    break;
                }
                case 2: {
                    ((ClientRequestInterceptor)interceptor).receive_reply(this.info);
                    break;
                }
                case 3: {
                    ((ClientRequestInterceptor)interceptor).receive_exception(this.info);
                    break;
                }
                case 4: {
                    ((ClientRequestInterceptor)interceptor).receive_other(this.info);
                }
            }
        }
        catch (ForwardRequest _fwd) {
            this.reverseDirection();
            this.op = (short)4;
            this.info.reply_status = (short)3;
            this.info.forward_reference = _fwd.forward;
            this.interceptor_ex = _fwd;
        }
        catch (SystemException _sysex) {
            this.reverseDirection();
            this.op = (short)3;
            this.interceptor_ex = _sysex;
            SystemExceptionHelper.insert(this.info.received_exception, _sysex);
            try {
                this.info.received_exception_id = SystemExceptionHelper.type(_sysex).id();
            }
            catch (BadKind _bk) {
                this.logger.error("unexpected exception", _bk);
            }
        }
        catch (Exception e) {
            this.logger.error("unexpected exception during invoke", e);
        }
        this.info.caller_op = this.op;
    }
}

