/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.util.Network;

public class SSLHandshakeListener
implements HandshakeCompletedListener {
    private final Logger logger;
    private final SSLSessionListener sslListener;

    public SSLHandshakeListener(Logger logger, SSLSessionListener listener) {
        this.logger = logger;
        this.sslListener = listener;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        X509Certificate[] certs = null;
        String localhost = null;
        try {
            certs = event.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handshakeCompleted - SSLPeerUnverifiedException");
            }
            certs = new X509Certificate[]{};
        }
        try {
            localhost = Network.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve local IP address - using default");
            }
            localhost = "127.0.0.1";
        }
        this.sslListener.sessionCreated(new SSLSessionEvent(event.getSource(), event.getSocket().getInetAddress().getHostAddress(), event.getSocket().getPort(), certs, event.getSocket().getLocalPort(), localhost, null));
    }
}

