/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.diop.DIOPFactories;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Factories;

public class TransportManager
implements Configurable {
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private List factoryClassNames = null;
    private ProfileSelector profileSelector = null;
    private final SocketFactoryManager socketFactoryManager;
    private Map factoriesMap = null;
    private List factoriesList = null;
    private TransportListener listener = null;

    public TransportManager(ORB orb) {
        this.socketFactoryManager = new SocketFactoryManager(orb);
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.giop");
        this.socketFactoryManager.configure(this.configuration);
        this.factoryClassNames = this.configuration.getAttributeList("jacorb.transport.factories");
        if (this.factoryClassNames.isEmpty()) {
            this.factoryClassNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        this.profileSelector = (ProfileSelector)this.configuration.getAttributeAsObject("jacorb.transport.client.selector");
        if (this.profileSelector == null) {
            this.profileSelector = new DefaultProfileSelector();
        }
    }

    public ProfileSelector getProfileSelector() {
        return this.profileSelector;
    }

    public SocketFactoryManager getSocketFactoryManager() {
        return this.socketFactoryManager;
    }

    public synchronized Factories getFactories(int tag) {
        if (tag == 1413566212) {
            return DIOPFactories.getDIOPFactory();
        }
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return (Factories)this.factoriesMap.get(ObjectUtil.newInteger(tag));
    }

    public synchronized List getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private void loadFactories() {
        if (this.configuration == null) {
            throw new BAD_INV_ORDER("TransportManager not configured!");
        }
        if (this.factoryClassNames == null) {
            throw new INTERNAL("factoryClassNames may not be null");
        }
        this.factoriesMap = new HashMap();
        this.factoriesList = new ArrayList();
        Iterator i = this.factoryClassNames.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            Factories factories = this.instantiateFactories(className);
            this.factoriesMap.put(new Integer(factories.profile_tag()), factories);
            this.factoriesList.add(factories);
        }
    }

    private Factories instantiateFactories(String className) {
        try {
            Class clazz = ObjectUtil.classForName(className);
            Object instance = clazz.newInstance();
            if (instance instanceof Configurable) {
                Configurable configurable = (Configurable)instance;
                configurable.configure(this.configuration);
            }
            this.logger.debug("created org.omg.ETF.Factories: " + className);
            return (Factories)instance;
        }
        catch (Exception e) {
            throw new BAD_PARAM("could not instantiate Factories class " + className + ", exception: " + e);
        }
    }

    public void notifyTransportListeners(GIOPConnection giopc) {
        if (this.listener != null) {
            this.listener.transportSelected(new TransportListener.Event(giopc));
        }
    }

    public void addTransportListener(TransportListener tl) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Transport listener to add: " + tl);
        }
        if (tl != null) {
            this.addTransportListenerImpl(tl);
        }
    }

    private synchronized void addTransportListenerImpl(final TransportListener tl) {
        this.listener = this.listener == null ? tl : new TransportListener(){
            private final TransportListener next_;
            {
                this.next_ = TransportManager.this.listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transportSelected(TransportListener.Event event) {
                try {
                    tl.transportSelected(event);
                }
                finally {
                    this.next_.transportSelected(event);
                }
            }
        };
    }
}

