/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.POA;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener,
Configurable {
    private final ORB orb;
    private final POA rootPOA;
    private Logger logger = null;
    private boolean require_ssl = false;

    public ServerRequestListener(ORB orb, POA rootPOA) {
        this.orb = orb;
        this.rootPOA = rootPOA;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        org.jacorb.config.Configuration configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = configuration.getNamedLogger("jacorb.giop.server.listener");
        boolean supportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        if (supportSSL) {
            int required = configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = supportSSL && (required & 0x60) != 0;
        }
    }

    public void requestReceived(byte[] request, GIOPConnection connection) {
        RequestInputStream inputStream = new RequestInputStream(this.orb, request);
        if (this.require_ssl && !connection.isSSL()) {
            ReplyOutputStream out = new ReplyOutputStream(inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
            this.logger.debug("About to reject request because connection is not SSL.");
            SystemExceptionHelper.write(out, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
            try {
                connection.sendReply(out);
            }
            catch (IOException e) {
                this.logger.warn("IOException", e);
            }
            return;
        }
        if (Messages.responseExpected(inputStream.req_hdr.response_flags)) {
            connection.incPendingMessages();
        }
        if (!connection.isTCSNegotiated()) {
            if (inputStream.getGIOPMinor() == 0) {
                connection.markTCSNegotiated();
            } else {
                CodeSetContext ctx = CodeSet.getCodeSetContext(inputStream.req_hdr.service_context);
                if (ctx != null) {
                    connection.setCodeSets(ctx.char_data, ctx.wchar_data);
                    connection.markTCSNegotiated();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received CodeSetContext. Using " + CodeSet.csName(ctx.char_data) + " as TCS and " + CodeSet.csName(ctx.wchar_data) + " as TCSW");
                    }
                }
            }
        }
        inputStream.setCodeSet(connection.getTCS(), connection.getTCSW());
        inputStream.updateMutatorConnection(connection);
        ServerRequest server_request = null;
        try {
            server_request = new ServerRequest(this.orb, inputStream, connection);
        }
        catch (POAInternalError pie) {
            this.logger.warn("Received a request with a non-jacorb object key");
            if (inputStream.isLocateRequest()) {
                LocateReplyOutputStream lr_out = new LocateReplyOutputStream(inputStream.req_hdr.request_id, 0, inputStream.getGIOPMinor());
                try {
                    connection.sendReply(lr_out);
                }
                catch (IOException e) {
                    this.logger.warn("IOException", e);
                }
            } else {
                ReplyOutputStream out = new ReplyOutputStream(inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
                SystemExceptionHelper.write(out, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    connection.sendReply(out);
                }
                catch (IOException e) {
                    this.logger.warn("IOException", e);
                }
            }
            return;
        }
        this.deliverRequest(server_request);
    }

    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.requestReceived(request, connection);
    }

    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
    }

    private void deliverRequest(ServerRequest request) {
        POA tmp_poa = this.rootPOA;
        try {
            String res;
            String refImplName = "";
            String orbImplName = this.orb.getImplName();
            String orbServerId = this.orb.getServerIdString();
            try {
                refImplName = POAUtil.extractImplName(request.objectKey());
            }
            catch (POAInternalError pie) {
                this.logger.debug("serverRequestListener: reference generated by foreign POA");
            }
            if (!orbImplName.equals(refImplName) && !orbServerId.equals(refImplName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("serverRequestListener: impl_name mismatch (refImplName: " + refImplName + " and orbServerId " + orbServerId + " and orbImplName " + orbImplName);
                }
                throw new WrongAdapter();
            }
            List scopes = request.getScopes();
            for (int i = 0; i < scopes.size() && !(res = (String)scopes.get(i)).equals(""); ++i) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(res);
                    continue;
                }
                catch (ParentIsHolding p) {
                    String[] rest_of_name = new String[scopes.size() - i];
                    for (int j = 0; j < i; ++j) {
                        rest_of_name[j] = (String)scopes.get(j + i);
                    }
                    request.setRemainingPOAName(rest_of_name);
                    break;
                }
            }
            if (tmp_poa == null) {
                throw new INTERNAL("Request POA null!");
            }
            tmp_poa._invoke(request);
        }
        catch (WrongAdapter e) {
            request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            request.reply();
        }
        catch (SystemException e) {
            request.setSystemException(e);
            request.reply();
        }
        catch (RuntimeException e) {
            request.setSystemException(new UNKNOWN(e.toString()));
            request.reply();
            this.logger.warn("unexpected exception", e);
        }
    }
}

