/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.ArrayList;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.jacorb.util.Time;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.PrincipalHelper;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.TargetAddressHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.TimeBase.UtcT;

public class RequestOutputStream
extends ServiceContextTransportingOutputStream {
    private static final byte[] principal = new byte[0];
    private static final byte[] reserved = new byte[3];
    private final int request_id;
    private final boolean response_expected;
    private final short syncScope;
    private final String operation;
    private final UtcT requestStartTime;
    private final UtcT requestEndTime;
    private final UtcT replyEndTime;
    private Request request = null;
    private final ClientConnection connection;

    public RequestOutputStream(ORB orb, ClientConnection connection, int request_id, String operation, boolean response_expected, short syncScope, UtcT requestStartTime, UtcT requestEndTime, UtcT replyEndTime, byte[] object_key, int giop_minor) {
        super(orb);
        this.setGIOPMinor(giop_minor);
        this.request_id = request_id;
        this.response_expected = response_expected;
        this.syncScope = syncScope;
        this.operation = operation;
        this.connection = connection;
        this.requestStartTime = requestStartTime;
        this.requestEndTime = requestEndTime;
        this.replyEndTime = replyEndTime;
        if (requestStartTime != null || requestEndTime != null || replyEndTime != null) {
            this.addServiceContext(this.createInvocationPolicies());
        }
        this.writeGIOPMsgHeader(0, giop_minor);
        switch (giop_minor) {
            case 0: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(request_id);
                this.write_boolean(response_expected);
                this.write_long(object_key.length);
                this.write_octet_array(object_key, 0, object_key.length);
                this.write_string(operation);
                PrincipalHelper.write(this, principal);
                break;
            }
            case 1: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(request_id);
                this.write_boolean(response_expected);
                this.write_long(object_key.length);
                this.write_octet_array(object_key, 0, object_key.length);
                this.write_string(operation);
                PrincipalHelper.write(this, principal);
                break;
            }
            case 2: {
                TargetAddress addr = new TargetAddress();
                addr.object_key(object_key);
                this.write_ulong(request_id);
                if (response_expected) {
                    this.write_octet((byte)3);
                } else {
                    switch (syncScope) {
                        case 0: 
                        case 1: {
                            this.write_octet((byte)0);
                            break;
                        }
                        case 2: {
                            this.write_octet((byte)1);
                            break;
                        }
                        case 3: {
                            this.write_octet((byte)3);
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid SYNC_SCOPE: " + syncScope);
                        }
                    }
                }
                this.write_octet_array(reserved, 0, 3);
                TargetAddressHelper.write(this, addr);
                this.write_string(operation);
                ServiceContextListHelper.write(this, Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + giop_minor);
            }
        }
    }

    public int requestId() {
        return this.request_id;
    }

    public boolean response_expected() {
        return this.response_expected;
    }

    public short syncScope() {
        return this.syncScope;
    }

    public String operation() {
        return this.operation;
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public void write_to(GIOPConnection conn) throws IOException {
        if (!conn.isTCSNegotiated()) {
            this.addServiceContext(CodeSet.createCodesetContext(conn.getTCS(), conn.getTCSW()));
            conn.markTCSNegotiated();
        }
        super.write_to(conn);
    }

    private PolicyValue[] getTimingPolicyValues() {
        ArrayList<PolicyValue> list = new ArrayList<PolicyValue>();
        if (this.requestStartTime != null) {
            list.add(new PolicyValue(27, Time.toCDR(this.requestStartTime)));
        }
        if (this.requestEndTime != null) {
            list.add(new PolicyValue(28, Time.toCDR(this.requestEndTime)));
        }
        if (this.replyEndTime != null) {
            list.add(new PolicyValue(30, Time.toCDR(this.replyEndTime)));
        }
        return list.toArray(new PolicyValue[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContext createInvocationPolicies() {
        CDROutputStream out = new CDROutputStream();
        try {
            out.beginEncapsulatedArray();
            PolicyValueSeqHelper.write(out, this.getTimingPolicyValues());
            ServiceContext serviceContext = new ServiceContext(7, out.getBufferCopy());
            return serviceContext;
        }
        finally {
            out.close();
        }
    }
}

