/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;

public class CodeSet {
    public static final int ISO8859_1 = 65537;
    public static final int UTF8 = 0x5010001;
    public static final int UTF16 = 65801;
    public static final String ISO8859_STR = "ISO8859_1";
    public static final String UTF8_STR = "UTF8";
    public static final String UTF16_STR = "UTF16";
    private static Logger logger = new NullLogger();
    private static boolean isConfigured = false;
    private static int nativeCodeSetChar = -1;
    private static int nativeCodeSetWchar = 65801;

    public static String csName(int cs) {
        switch (cs) {
            case 65537: {
                return ISO8859_STR;
            }
            case 65801: {
                return UTF16_STR;
            }
            case 0x5010001: {
                return UTF8_STR;
            }
        }
        return "Unknown TCS: " + Integer.toHexString(cs);
    }

    public static synchronized void configure(Configuration config) throws ConfigurationException {
        if (!isConfigured) {
            int value;
            String ncsc = config.getAttribute("jacorb.native_char_codeset", "");
            String ncsw = config.getAttribute("jacorb.native_wchar_codeset", "");
            if (ncsc != null && !"".equals(ncsc)) {
                value = CodeSet.csInt(ncsc);
                if (value != -1) {
                    nativeCodeSetChar = value;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSC to " + ncsc);
                }
            }
            if (ncsw != null && !"".equals(ncsw)) {
                value = CodeSet.csInt(ncsw);
                if (value != -1) {
                    nativeCodeSetWchar = value;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSW to " + ncsw);
                }
            }
            logger = config.getNamedLogger("org.jacorb.orb.codeset");
            isConfigured = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("CodeSet is already configured; further attempts to reconfigure will be ignored!");
        }
    }

    public static int csInt(String name) {
        try {
            return Integer.parseInt(name, 16);
        }
        catch (NumberFormatException ex) {
            String ucName = name.toUpperCase();
            if (ucName.equals(ISO8859_STR)) {
                return 65537;
            }
            if (ucName.equals(UTF8_STR)) {
                return 0x5010001;
            }
            if (ucName.equals(UTF16_STR)) {
                return 65801;
            }
            return -1;
        }
    }

    public static int getTCSDefault() {
        if (nativeCodeSetChar == -1) {
            OutputStreamWriter defaultStream = new OutputStreamWriter(new ByteArrayOutputStream());
            String sysenc = defaultStream.getEncoding();
            try {
                defaultStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (sysenc.equals(ISO8859_STR)) {
                nativeCodeSetChar = 65537;
            } else if (sysenc.equals(UTF8_STR)) {
                nativeCodeSetChar = 0x5010001;
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("Warning - unknown codeset (" + sysenc + ") - defaulting to ISO-8859-1");
                }
                nativeCodeSetChar = 65537;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("TCS set to " + CodeSet.csName(nativeCodeSetChar));
            }
        }
        return nativeCodeSetChar;
    }

    public static int getTCSWDefault() {
        return nativeCodeSetWchar;
    }

    public static int getConversionDefault() {
        return 0x5010001;
    }

    public static int selectTCS(CodeSetComponentInfo cs_info) {
        int with_native = CodeSet.selectCodeSet(cs_info.ForCharData, CodeSet.getTCSDefault());
        if (with_native == -1) {
            return CodeSet.selectCodeSet(cs_info.ForCharData, CodeSet.getConversionDefault());
        }
        return with_native;
    }

    public static int selectTCSW(CodeSetComponentInfo cs_info) {
        int with_native = CodeSet.selectCodeSet(cs_info.ForWcharData, CodeSet.getTCSWDefault());
        if (with_native == -1) {
            return CodeSet.selectCodeSet(cs_info.ForWcharData, CodeSet.getConversionDefault());
        }
        return with_native;
    }

    private static int selectCodeSet(CodeSetComponent cs_component, int native_cs) {
        if (cs_component.native_code_set == native_cs) {
            return native_cs;
        }
        for (int i = 0; i < cs_component.conversion_code_sets.length; ++i) {
            if (cs_component.conversion_code_sets[i] != native_cs) continue;
            return native_cs;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext createCodesetContext(int tcs, int tcsw) {
        CDROutputStream os = new CDROutputStream();
        try {
            os.beginEncapsulatedArray();
            CodeSetContextHelper.write(os, new CodeSetContext(tcs, tcsw));
            ServiceContext serviceContext = new ServiceContext(1, os.getBufferCopy());
            return serviceContext;
        }
        finally {
            os.close();
        }
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] contexts) {
        for (int i = 0; i < contexts.length; ++i) {
            if (contexts[i].context_id != 1) continue;
            CDRInputStream is = new CDRInputStream((ORB)null, contexts[i].context_data);
            is.openEncapsulatedArray();
            return CodeSetContextHelper.read(is);
        }
        return null;
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0 && (args[0].equals("-h") || !args[0].equals("-a"))) {
            System.out.println("Usage: org.jacorb.orb.connection.CodeSet [-a]");
            System.exit(1);
        }
        Properties props = System.getProperties();
        String osName = (String)props.get("os.name");
        System.out.println("Operating system name: " + osName);
        System.out.println("Operating system version: " + props.get("os.version"));
        System.out.println("Operating system architecture: " + props.get("os.arch"));
        System.out.println("User region: " + System.getProperty("user.region"));
        System.out.println("JVM: " + props.get("java.vm.version"));
        System.out.println("JacORB: 2.3.0, 17-Feb-2007");
        System.out.println("System file encoding property: " + System.getProperty("file.encoding"));
        String defaultIOEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        System.out.println("Cannonical encoding: " + defaultIOEncoding);
        System.out.println("Default WChar encoding: " + CodeSet.csName(nativeCodeSetWchar));
        if (osName.toLowerCase().indexOf("windows") == -1 && args != null && args.length == 1 && args[0].equals("-a")) {
            String line;
            BufferedReader buffer;
            Process locale;
            System.out.println("Locale is:");
            try {
                locale = Runtime.getRuntime().exec("locale");
                buffer = new BufferedReader(new InputStreamReader(locale.getInputStream()));
                while ((line = buffer.readLine()) != null) {
                    System.out.println("    " + line);
                }
                buffer.close();
            }
            catch (IOException e) {
                System.err.println("Caught exception " + e);
            }
            System.out.println("All available locales are:");
            try {
                locale = Runtime.getRuntime().exec("locale -a");
                buffer = new BufferedReader(new InputStreamReader(locale.getInputStream()));
                while ((line = buffer.readLine()) != null) {
                    System.out.println("        " + line);
                }
                buffer.close();
            }
            catch (IOException e) {
                System.err.println("Caught exception " + e);
            }
        }
    }
}

